/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.owlapi;

import java.net.URI;
import java.util.Set;
import org.mindswap.pellet.KBLoader;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.io.OWLOntologyCreationIOException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLAPILoader
extends KBLoader {
    private OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    private Reasoner pellet = new Reasoner(this.manager);

    public KnowledgeBase getKB() {
        return this.pellet.getKB();
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public Set<OWLOntology> getOntologies() {
        return this.manager.getOntologies();
    }

    public Reasoner getReasoner() {
        return this.pellet;
    }

    public void load() {
        this.pellet.loadOntologies(this.manager.getOntologies());
    }

    protected void parseFile(String file) {
        try {
            this.manager.loadOntology(URI.create(file));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Cannot parse file: " + file);
        }
        catch (OWLOntologyCreationIOException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (OWLOntologyCreationException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        this.pellet.clearOntologies();
        for (OWLOntology ont : this.manager.getOntologies()) {
            this.manager.removeOntology(ont.getURI());
        }
    }
}

