/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.BasicStringWrapper;
import com.wcohen.ss.api.Token;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

class BagOfTokens
extends BasicStringWrapper {
    private Map weightMap = new TreeMap();
    private double totalWeight = 0.0;
    private Token[] tokens;

    BagOfTokens(String s, Token[] tokens) {
        super(s);
        this.tokens = tokens;
        int i = 0;
        while (i < tokens.length) {
            this.weightMap.put(tokens[i], new Double(this.getWeight(tokens[i]) + 1.0));
            ++i;
        }
        this.totalWeight = tokens.length;
    }

    Iterator tokenIterator() {
        return this.weightMap.keySet().iterator();
    }

    boolean contains(Token tok) {
        return this.weightMap.get(tok) != null;
    }

    double getWeight(Token tok) {
        Double f = (Double)this.weightMap.get(tok);
        return f == null ? 0.0 : f;
    }

    void setWeight(Token tok, double d) {
        Double oldWeight = (Double)this.weightMap.get(tok);
        this.totalWeight += oldWeight == null ? d : d - oldWeight;
        this.weightMap.put(tok, new Double(d));
    }

    int size() {
        return this.weightMap.keySet().size();
    }

    double getTotalWeight() {
        return this.totalWeight;
    }

    Token[] getTokens() {
        return this.tokens;
    }
}

