/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.AffineGap;
import com.wcohen.ss.CharMatchScore;
import com.wcohen.ss.api.StringWrapper;
import java.util.HashSet;
import java.util.Set;

public class MongeElkan
extends AffineGap {
    private boolean scaling = true;
    private static final int CHAR_EXACT_MATCH_SCORE = 5;
    private static final int CHAR_APPROX_MATCH_SCORE = 3;
    private static final int CHAR_MISMATCH_MATCH_SCORE = -3;
    private static Set[] approx = new Set[7];
    private static final CharMatchScore MY_CHAR_MATCH_SCORE;

    static {
        MongeElkan.approx[0] = new HashSet();
        approx[0].add(new Character('d'));
        approx[0].add(new Character('t'));
        MongeElkan.approx[1] = new HashSet();
        approx[1].add(new Character('g'));
        approx[1].add(new Character('j'));
        MongeElkan.approx[2] = new HashSet();
        approx[2].add(new Character('l'));
        approx[2].add(new Character('r'));
        MongeElkan.approx[3] = new HashSet();
        approx[3].add(new Character('m'));
        approx[3].add(new Character('n'));
        MongeElkan.approx[4] = new HashSet();
        approx[4].add(new Character('b'));
        approx[4].add(new Character('p'));
        approx[4].add(new Character('v'));
        MongeElkan.approx[5] = new HashSet();
        approx[5].add(new Character('a'));
        approx[5].add(new Character('e'));
        approx[5].add(new Character('i'));
        approx[5].add(new Character('o'));
        approx[5].add(new Character('u'));
        MongeElkan.approx[6] = new HashSet();
        approx[6].add(new Character(','));
        approx[6].add(new Character('.'));
        MY_CHAR_MATCH_SCORE = new CharMatchScore(){

            public double matchScore(char c, char d) {
                if ((c = Character.toLowerCase(c)) == (d = Character.toLowerCase(d))) {
                    return 5.0;
                }
                Character objC = new Character(c);
                Character objD = new Character(d);
                int i = 0;
                while (i < approx.length) {
                    if (approx[i].contains(objC) && approx[i].contains(objD)) {
                        return 3.0;
                    }
                    ++i;
                }
                return -3.0;
            }
        };
    }

    public void setScaling(boolean flag) {
        this.scaling = flag;
    }

    public void setScaling(Double flag) {
        this.scaling = flag != 0.0;
    }

    public MongeElkan() {
        super(MY_CHAR_MATCH_SCORE, -5.0, -1.0, 0.0);
        this.setScaling(true);
    }

    public String toString() {
        return "[MongeElkan]";
    }

    public double score(StringWrapper s, StringWrapper t) {
        if (this.scaling) {
            int minLen = Math.min(s.unwrap().length(), t.unwrap().length());
            return super.score(s, t) / (double)(minLen * 5);
        }
        return super.score(s, t);
    }

    public String explainScore(StringWrapper s, StringWrapper t) {
        if (this.scaling) {
            int minLen = Math.min(s.unwrap().length(), t.unwrap().length());
            double scaledDist = super.score(s, t) / (double)(minLen * 5);
            return String.valueOf(super.explainScore(s, t)) + "\nScaling factor: " + minLen * 5 + "\nScaled score: " + scaledDist;
        }
        return super.explainScore(s, t);
    }

    public static void main(String[] argv) {
        MongeElkan.doMain(new MongeElkan(), argv);
    }
}

