/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.BasicStringWrapper;
import com.wcohen.ss.api.StringDistance;
import com.wcohen.ss.api.StringWrapper;

public class MultiStringWrapper
extends BasicStringWrapper {
    private String s;
    private StringWrapper[] f;
    private int[] learnerIndex;
    private int[] fieldIndex;
    private boolean fieldsPrepared;

    public MultiStringWrapper(String s, String delim) {
        this(s, 1, delim);
    }

    public MultiStringWrapper(String s, int numCopies) {
        this(s, numCopies, null);
    }

    public MultiStringWrapper(String s, int numCopies, String delim) {
        super(s);
        this.s = s;
        String[] fields = delim != null ? s.split(delim, -1) : new String[]{s};
        this.f = new StringWrapper[fields.length * numCopies];
        this.learnerIndex = new int[this.f.length];
        this.fieldIndex = new int[this.f.length];
        int i = 0;
        while (i < fields.length) {
            int j = 0;
            while (j < numCopies) {
                int k = i * numCopies + j;
                this.f[k] = new BasicStringWrapper(fields[i]);
                this.learnerIndex[k] = j++;
                this.fieldIndex[k] = i;
            }
            ++i;
        }
        this.fieldsPrepared = false;
    }

    public int size() {
        return this.f.length;
    }

    public int getDistanceLearnerIndex(int i) {
        return this.learnerIndex[i];
    }

    public int getFieldIndex(int i) {
        return this.fieldIndex[i];
    }

    public StringWrapper get(int i) {
        return this.f[i];
    }

    public void set(int i, StringWrapper w) {
        this.f[i] = w;
    }

    public void prepare(StringDistance[] innerDistances) {
        if (!this.fieldsPrepared) {
            int i = 0;
            while (i < this.size()) {
                StringDistance d = innerDistances[this.getDistanceLearnerIndex(i)];
                this.set(i, d.prepare(this.get(i).unwrap()));
                ++i;
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[multiwrap '" + this.s + "':");
        int i = 0;
        while (i < this.size()) {
            buf.append(" '" + this.get(i) + "'");
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    public static void main(String[] args) {
        try {
            if (args.length == 3) {
                int numCopies = Integer.parseInt(args[0]);
                String delim = args[1];
                String s = args[2];
                System.out.println(new MultiStringWrapper(s, numCopies, delim));
            } else if (args.length == 2) {
                int numCopies = Integer.parseInt(args[0]);
                String s = args[1];
                System.out.println(new MultiStringWrapper(s, numCopies, null));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("usage: numCopies delim string");
        }
    }
}

