/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.BasicStringWrapper;
import com.wcohen.ss.MemoMatrix;
import com.wcohen.ss.PrintfFormat;
import com.wcohen.ss.api.StringWrapper;
import java.util.Random;

public class SLIM
extends AbstractStringDistance {
    private static final boolean TRACE = false;
    private static final int MAX_EM_ITERATIONS = 20;
    private static final double MIN_PARAMETER_CHANGE = 0.01;
    private static final double RANDOM_GAUSSIAN_SD = 1.0;
    private static double parameterPriorWeight = 0.0;
    private static double priorMean = 0.0;
    private static double priorVar = 1.0;
    private static double mixturePriorWeight = 0.0;
    private static double mixturePrior = 0.5;
    private static final boolean USE_TWO_GAUSSIANS = false;
    private static final boolean USE_TRIVIAL_MODEL = true;

    public String toString() {
        return "[SLIM]";
    }

    public double score(StringWrapper s, StringWrapper t) {
        double tOverlap;
        double sOverlap;
        String str2;
        String str1 = s.unwrap().toLowerCase();
        if (str1.equals(str2 = t.unwrap().toLowerCase())) {
            return 1.0;
        }
        Histogram hist = new Histogram(str1, str2);
        if (hist.getTotalCount() <= 1) {
            sOverlap = (double)hist.getTotalCount() / (double)str1.length();
            tOverlap = (double)hist.getTotalCount() / (double)str2.length();
        } else {
            MixtureModel model = new MixtureModel(hist);
            sOverlap = this.overlap(str1, str2, model);
            tOverlap = this.overlap(str2, str1, model);
        }
        double score = 0.5 * (sOverlap + tOverlap);
        return score;
    }

    public String explainScore(StringWrapper s, StringWrapper t) {
        double tOverlap;
        double sOverlap;
        String str2;
        String str1 = s.unwrap().toLowerCase();
        if (str1.equals(str2 = t.unwrap().toLowerCase())) {
            return "Strings are equal: score = 1.0";
        }
        StringBuffer buf = new StringBuffer("");
        buf.append("Co-occurence matrix:\n");
        buf.append(new MatchMemoMatrix(s, t).toString());
        buf.append("\n\n");
        Histogram hist = new Histogram(str1, str2);
        if (hist.getTotalCount() <= 1) {
            buf.append("No mixture model for " + hist.getTotalCount() + " common letter(s)\n");
            sOverlap = (double)hist.getTotalCount() / (double)str1.length();
            tOverlap = (double)hist.getTotalCount() / (double)str2.length();
        } else {
            MixtureModel model = new MixtureModel(hist);
            buf.append("Mixture model " + model.toString() + "\n");
            PrintfFormat fmt = new PrintfFormat("%3d Pr(%3d): ");
            int d = hist.getMinDiff();
            while (d <= hist.getMaxDiff()) {
                double p = model.posteriorProbOfGaussian(d);
                buf.append(fmt.sprintf(new Object[]{new Integer(d), new Integer((int)(100.0 * p))}));
                int j = 0;
                while (j < hist.getCount(d)) {
                    buf.append('*');
                    ++j;
                }
                buf.append("\n");
                ++d;
            }
            buf.append("\nPosterior probability of Gaussian:\n");
            buf.append(new MixMemoMatrix(s, t, model).toString());
            buf.append("\n\n");
            sOverlap = this.overlap(str1, str2, model);
            tOverlap = this.overlap(str2, str1, model);
        }
        double score = 0.5 * (sOverlap + tOverlap);
        buf.append("sOverlap=" + sOverlap + " tOverlap=" + tOverlap + " score=" + score + "\n");
        buf.append("Score=" + this.score(s, t) + "\n");
        return buf.toString();
    }

    private double overlap(String s, String t, MixtureModel model, int len) {
        double n = 0.0;
        int i = 0;
        while (i < len) {
            double thisCharWeight = 1.0;
            int j = 0;
            while (j < t.length()) {
                if (s.charAt(i) == t.charAt(j)) {
                    thisCharWeight *= 1.0 - model.posteriorProbOfGaussian(i - j);
                }
                ++j;
            }
            thisCharWeight = 1.0 - thisCharWeight;
            n += thisCharWeight;
            ++i;
        }
        return n / (double)s.length();
    }

    private double overlap(String s, String t, MixtureModel model) {
        return this.overlap(s, t, model, s.length());
    }

    public StringWrapper prepare(String s) {
        return new BasicStringWrapper(s);
    }

    public static void main(String[] argv) {
        SLIM.doMain(new SLIM(), argv);
    }

    private static class Histogram {
        int maxLength;
        int[] count;
        int totalCount;

        public Histogram(String s, String t) {
            this.maxLength = Math.max(s.length(), t.length());
            this.count = new int[2 * this.maxLength + 1];
            this.totalCount = 0;
            int i = 0;
            while (i < s.length()) {
                int j = 0;
                while (j < t.length()) {
                    if (s.charAt(i) == t.charAt(j)) {
                        int diff = i - j;
                        int n = diff + this.maxLength;
                        this.count[n] = this.count[n] + 1;
                        ++this.totalCount;
                    }
                    ++j;
                }
                ++i;
            }
        }

        public int getMinDiff() {
            return -this.maxLength;
        }

        public int getMaxDiff() {
            return this.maxLength;
        }

        public int getCount(int diff) {
            return this.count[diff + this.maxLength];
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            PrintfFormat fmt = new PrintfFormat("%3d: ");
            int d = this.getMinDiff();
            while (d <= this.getMaxDiff()) {
                buf.append(fmt.sprintf(d));
                int i = 0;
                while (i < this.getCount(d)) {
                    buf.append('*');
                    ++i;
                }
                buf.append("\n");
                ++d;
            }
            return buf.toString();
        }

        public double[] toSample() {
            double[] sample = new double[this.totalCount];
            Random rand = new Random(0L);
            int k = 0;
            int d = this.getMinDiff();
            while (d <= this.getMaxDiff()) {
                int i = 0;
                while (i < this.getCount(d)) {
                    sample[k++] = (double)d + rand.nextGaussian() * 1.0;
                    ++i;
                }
                ++d;
            }
            return sample;
        }
    }

    private static class MixtureModel {
        double[] z;
        double[] s;
        double probGaussian;
        double bigVariance;
        double bigMean;
        double mean;
        double var;
        double spread;

        public MixtureModel(Histogram hist) {
        }

        private boolean changed(double newV, double oldV) {
            double diff = oldV - newV;
            if (diff < 0.0) {
                diff = -diff;
            }
            return diff > 0.01;
        }

        private String toString(double[] z) {
            StringBuffer buf = new StringBuffer();
            PrintfFormat fmt = new PrintfFormat(" %.2g");
            int i = 0;
            while (i < z.length) {
                buf.append(fmt.sprintf(z[i]));
                ++i;
            }
            return buf.toString();
        }

        private double logPGaussian(double s, double mean, double var) {
            double d = s - mean;
            return -2.0 * Math.log(6.2831854 * var) - d * d / (2.0 * var);
        }

        public double posteriorProbOfGaussian(double s) {
            return 1.0;
        }

        public String toString() {
            return "[mix:trivial]";
        }
    }

    private static class MatchMemoMatrix
    extends MemoMatrix {
        public MatchMemoMatrix(StringWrapper s, StringWrapper t) {
            super(s, t);
        }

        double compute(int i, int j) {
            return this.sAt(i) == this.tAt(j) ? 1 : 0;
        }
    }

    private static class MixMemoMatrix
    extends MemoMatrix {
        private MixtureModel model;

        public MixMemoMatrix(StringWrapper s, StringWrapper t, MixtureModel model) {
            super(s, t);
            this.model = model;
        }

        double compute(int i, int j) {
            if (this.sAt(i) != this.tAt(j)) {
                return 0.0;
            }
            double p = this.model.posteriorProbOfGaussian(i - j);
            if (p == 1.0) {
                return 99.0;
            }
            return (int)(p * 100.0);
        }
    }
}

