/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.cls.expt.EvaluationGroup;
import com.wcohen.ss.DirichletJS;
import com.wcohen.ss.Jaccard;
import com.wcohen.ss.Jaro;
import com.wcohen.ss.JaroWinkler;
import com.wcohen.ss.JaroWinklerTFIDF;
import com.wcohen.ss.JelinekMercerJS;
import com.wcohen.ss.Levenstein;
import com.wcohen.ss.MongeElkan;
import com.wcohen.ss.TokenFelligiSunter;
import com.wcohen.ss.WizardUI;
import com.wcohen.ss.api.StringDistanceLearner;
import com.wcohen.ss.expt.Blocker;
import com.wcohen.ss.expt.MatchData;
import com.wcohen.ss.expt.MatchExpt;
import com.wcohen.ss.expt.NGramBlocker;
import com.wcohen.ss.expt.NullBlocker;
import com.wcohen.ss.expt.TokenBlocker;
import com.wcohen.util.IOUtil;
import com.wcohen.util.ProgressCounter;
import com.wcohen.util.gui.ComponentViewer;
import com.wcohen.util.gui.TypeSelector;
import com.wcohen.util.gui.Viewer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jwf.NullWizardPanel;
import jwf.Wizard;
import jwf.WizardAdapter;
import jwf.WizardListener;
import jwf.WizardPanel;

public class WizardUI {
    private static final Blocker DEFAULT_BLOCKER = new NullBlocker();
    private static final StringDistanceLearner DEFAULT_DISTANCE = new JaroWinklerTFIDF();

    public static void main(String[] args) {
        JFrame frame = new JFrame("SecondString");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        Wizard wizard = new Wizard();
        wizard.addWizardListener((WizardListener)new WizardAdapter(){

            public void wizardFinished(Wizard wizard) {
                System.exit(0);
            }

            public void wizardCancelled(Wizard wizard) {
                System.exit(0);
            }
        });
        frame.setContentPane((Container)wizard);
        frame.pack();
        frame.setVisible(true);
        wizard.start((WizardPanel)new PickTask());
    }

    private static abstract class WizardViewer
    extends ComponentViewer {
        private String myKey;
        protected final Map viewerContext;
        private final WizardPanel wizardPanel;

        public WizardViewer(String key, Map viewerContext) {
            this.myKey = key;
            this.viewerContext = viewerContext;
            this.wizardPanel = this.buildWizardPanel();
        }

        public WizardViewer(String key) {
            this(key, new HashMap());
        }

        public WizardPanel getWizardPanel() {
            return this.wizardPanel;
        }

        public JComponent componentFor(Object o) {
            return this.wizardPanel;
        }

        public boolean canHandle(int signal, Object argument, ArrayList senders) {
            return signal == 3;
        }

        public void handle(int signal, Object argument, ArrayList senders) {
            if (signal == 3) {
                System.out.println("selected " + argument);
                this.viewerContext.put(this.myKey, argument);
            }
        }

        public abstract WizardPanel buildWizardPanel();
    }

    private static class SSTypeSelector
    extends TypeSelector {
        private static Class[] ssClasses = new Class[]{NullBlocker.class, TokenBlocker.class, NGramBlocker.class, DirichletJS.class, JelinekMercerJS.class, Jaccard.class, Jaro.class, JaroWinkler.class, JaroWinklerTFIDF.class, Levenstein.class, MongeElkan.class, TokenFelligiSunter.class};

        public SSTypeSelector(Class rootClass) {
            super(ssClasses, rootClass);
        }
    }

    private static class PickTask
    extends NullWizardPanel {
        private JRadioButton doExpt;
        private JRadioButton reviewResult;

        public PickTask() {
            this.setBorder(new TitledBorder("SecondString: task selection"));
            this.add(new JLabel("Welcome to SecondString!"));
            this.add(new JLabel("Please select a task:"));
            this.doExpt = new JRadioButton("Perform an experiment", true);
            this.reviewResult = new JRadioButton("Review saved experimental results", false);
            ButtonGroup group = new ButtonGroup();
            this.add(this.doExpt);
            this.add(this.reviewResult);
            group.add(this.doExpt);
            group.add(this.reviewResult);
        }

        public boolean hasNext() {
            return true;
        }

        public boolean validateNext(List list) {
            return true;
        }

        public WizardPanel next() {
            if (this.doExpt.isSelected()) {
                return new PickBlocker().getWizardPanel();
            }
            return new PickExptFile().getWizardPanel();
        }
    }

    private static class PickExptFile
    extends WizardViewer {
        private MatchExpt matchExpt = null;
        private EvaluationGroup evalGroup = new EvaluationGroup();
        private int groupSize = 0;

        public PickExptFile() {
            super("ExptFile");
        }

        public WizardPanel buildWizardPanel() {
            return new ExptFileWizardPanel((Viewer)this);
        }

        static /* synthetic */ void access$0(PickExptFile pickExptFile, MatchExpt matchExpt) {
            pickExptFile.matchExpt = matchExpt;
        }

        static /* synthetic */ void access$4(PickExptFile pickExptFile, int n) {
            pickExptFile.groupSize = n;
        }

        private class ExptFileWizardPanel
        extends NullWizardPanel {
            public ExptFileWizardPanel(Viewer enclosingViewer) {
                this.setBorder(new TitledBorder("SecondString: saved experiment selection"));
                this.add(new JLabel("Please select one or more previously-saved experiments:"));
                JTextField filePane = new JTextField(20);
                this.add(filePane);
                ArrayList exptListData = new ArrayList();
                JList exptList = new JList();
                Dimension wide = new Dimension(600, 100);
                exptList.setPreferredSize(wide);
                JFileChooser chooser = new JFileChooser();
                this.add(new JButton(new AbstractAction(this, "Browse", chooser, filePane, exptListData, exptList){
                    final /* synthetic */ ExptFileWizardPanel this$2;
                    private final /* synthetic */ JFileChooser val$chooser;
                    private final /* synthetic */ JTextField val$filePane;
                    private final /* synthetic */ ArrayList val$exptListData;
                    private final /* synthetic */ JList val$exptList;
                    {
                        this.this$2 = exptFileWizardPanel;
                        this.val$chooser = jFileChooser;
                        this.val$filePane = jTextField;
                        this.val$exptListData = arrayList;
                        this.val$exptList = jList;
                        super($anonymous0);
                    }

                    public void actionPerformed(ActionEvent ev) {
                        int returnVal = this.val$chooser.showOpenDialog(null);
                        if (returnVal == 0) {
                            File exptFile = this.val$chooser.getSelectedFile();
                            this.val$filePane.setText(exptFile.getName());
                            try {
                                PickExptFile.access$0(ExptFileWizardPanel.access$0(this.this$2), (MatchExpt)IOUtil.loadSerialized((File)exptFile));
                                this.val$exptListData.add(PickExptFile.access$1(ExptFileWizardPanel.access$0(this.this$2)));
                                PickExptFile.access$2(ExptFileWizardPanel.access$0(this.this$2)).add(exptFile.getName(), PickExptFile.access$1(ExptFileWizardPanel.access$0(this.this$2)).toEvaluation());
                                PickExptFile pickExptFile = ExptFileWizardPanel.access$0(this.this$2);
                                PickExptFile.access$4(pickExptFile, PickExptFile.access$3(pickExptFile) + 1);
                                this.val$exptList.setListData(this.val$exptListData.toArray());
                            }
                            catch (IOException ex) {
                                System.err.println("can't load " + exptFile + ": " + ex);
                            }
                        }
                    }
                }));
                JPanel listPanel = new JPanel();
                listPanel.setPreferredSize(wide);
                listPanel.setBorder(new TitledBorder("Selected experiments"));
                JScrollPane scroller = new JScrollPane(exptList);
                scroller.setPreferredSize(wide);
                listPanel.add(scroller);
                this.add(listPanel);
            }

            public boolean hasNext() {
                return true;
            }

            public boolean validateNext(List list) {
                list.add("You need to pick a file!");
                return PickExptFile.this.groupSize >= 1;
            }

            public WizardPanel next() {
                if (PickExptFile.this.groupSize == 1) {
                    return new ResultWizardPanel(PickExptFile.this.matchExpt.toGUI(), null);
                }
                return new ResultWizardPanel(PickExptFile.this.evalGroup.toGUI(), null);
            }

            static /* synthetic */ PickExptFile access$0(ExptFileWizardPanel exptFileWizardPanel) {
                return exptFileWizardPanel.PickExptFile.this;
            }
        }
    }

    private static class PickBlocker
    extends WizardViewer {
        public PickBlocker() {
            super("Blocker");
        }

        public WizardPanel buildWizardPanel() {
            return new BlockerWizardPanel((Viewer)this);
        }

        private class BlockerWizardPanel
        extends NullWizardPanel {
            public BlockerWizardPanel(Viewer enclosingViewer) {
                this.setBorder(new TitledBorder("SecondString: blocker selection"));
                this.add(new JLabel("Please select a blocking strategy:"));
                SSTypeSelector selector = new SSTypeSelector(Blocker.class);
                selector.setSuperView(enclosingViewer);
                selector.receiveContent(DEFAULT_BLOCKER);
                PickBlocker.this.viewerContext.put("Blocker", DEFAULT_BLOCKER);
                this.add((Component)((Object)selector));
            }

            public boolean hasNext() {
                return true;
            }

            public boolean validateNext(List list) {
                return true;
            }

            public WizardPanel next() {
                return new PickDistance(PickBlocker.this.viewerContext).getWizardPanel();
            }

            public boolean hasHelp() {
                return true;
            }

            public void help() {
                String helpMsg = "A \"blocker\" is used to make an initial guess about which pairs to match.\nThe NullBlocker picks all pairs; the TokenBlocker picks all pairs that share\na common token; and the NGramBlocker picks all pairs that share a common NGram.";
                JOptionPane.showMessageDialog((Component)((Object)this), helpMsg, "Blocker Help", 1);
            }
        }
    }

    private static class PickDistance
    extends WizardViewer {
        public PickDistance(Map viewerContext) {
            super("Distance", viewerContext);
        }

        public WizardPanel buildWizardPanel() {
            return new DistanceWizardPanel((Viewer)this);
        }

        private class DistanceWizardPanel
        extends NullWizardPanel {
            public DistanceWizardPanel(Viewer enclosingViewer) {
                this.setBorder(new TitledBorder("SecondString: distance selection"));
                this.add(new JLabel("Please select a string distance:"));
                SSTypeSelector selector = new SSTypeSelector(StringDistanceLearner.class);
                selector.setSuperView(enclosingViewer);
                selector.receiveContent(DEFAULT_DISTANCE);
                PickDistance.this.viewerContext.put("Distance", DEFAULT_DISTANCE);
                this.add((Component)((Object)selector));
            }

            public boolean hasNext() {
                return true;
            }

            public boolean validateNext(List list) {
                return true;
            }

            public WizardPanel next() {
                return new PickDatafile(PickDistance.this.viewerContext).getWizardPanel();
            }
        }
    }

    private static class PickDatafile
    extends WizardViewer {
        public PickDatafile(Map viewerContext) {
            super("File", viewerContext);
        }

        public WizardPanel buildWizardPanel() {
            return new DatafileWizardPanel((Viewer)this);
        }

        private class DatafileWizardPanel
        extends NullWizardPanel {
            public DatafileWizardPanel(Viewer enclosingViewer) {
                this.setBorder(new TitledBorder("SecondString: datafile selection"));
                this.add(new JLabel("Please select a datafile:"));
                JTextField filePane = new JTextField(20);
                this.add(filePane);
                JFileChooser chooser = new JFileChooser();
                this.add(new JButton(new AbstractAction(this, "Browse", chooser, filePane){
                    final /* synthetic */ DatafileWizardPanel this$2;
                    private final /* synthetic */ JFileChooser val$chooser;
                    private final /* synthetic */ JTextField val$filePane;
                    {
                        this.this$2 = datafileWizardPanel;
                        this.val$chooser = jFileChooser;
                        this.val$filePane = jTextField;
                        super($anonymous0);
                    }

                    public void actionPerformed(ActionEvent ev) {
                        int returnVal = this.val$chooser.showOpenDialog(null);
                        if (returnVal == 0) {
                            DatafileWizardPanel.access$0((DatafileWizardPanel)this.this$2).viewerContext.put("File", this.val$chooser.getSelectedFile());
                            this.val$filePane.setText(((File)DatafileWizardPanel.access$0((DatafileWizardPanel)this.this$2).viewerContext.get("File")).getName());
                        }
                    }
                }));
            }

            public boolean hasNext() {
                return true;
            }

            public boolean validateNext(List list) {
                list.add("You need to pick a file!");
                return PickDatafile.this.viewerContext.get("File") != null;
            }

            public WizardPanel next() {
                return new RunExperiment(PickDatafile.this.viewerContext).getWizardPanel();
            }

            static /* synthetic */ PickDatafile access$0(DatafileWizardPanel datafileWizardPanel) {
                return datafileWizardPanel.PickDatafile.this;
            }
        }
    }

    private static class RunExperiment
    extends WizardViewer {
        private MatchExpt matchExpt;
        private Viewer matchExptViewer;
        private boolean matchExptComplete = false;

        public RunExperiment(Map viewerContext) {
            super("none", viewerContext);
        }

        public WizardPanel buildWizardPanel() {
            return new RunExperimentWizard((Viewer)this);
        }

        static /* synthetic */ void access$0(RunExperiment runExperiment, MatchExpt matchExpt) {
            runExperiment.matchExpt = matchExpt;
        }

        static /* synthetic */ MatchExpt access$1(RunExperiment runExperiment) {
            return runExperiment.matchExpt;
        }

        static /* synthetic */ void access$2(RunExperiment runExperiment, Viewer viewer) {
            runExperiment.matchExptViewer = viewer;
        }

        static /* synthetic */ Viewer access$3(RunExperiment runExperiment) {
            return runExperiment.matchExptViewer;
        }

        static /* synthetic */ void access$4(RunExperiment runExperiment, boolean bl) {
            runExperiment.matchExptComplete = bl;
        }

        private class RunExperimentWizard
        extends NullWizardPanel {
            public RunExperimentWizard(Viewer enclosingViewer) {
                this.setBorder(new TitledBorder("SecondString: confirm and run experiment"));
                this.setLayout(new GridBagLayout());
                String[] keys = new String[]{"Blocker", "Distance", "File"};
                Object[][] tableData = new Object[keys.length][2];
                int i = 0;
                while (i < keys.length) {
                    tableData[i][0] = keys[i];
                    tableData[i][1] = RunExperiment.this.viewerContext.get(keys[i]);
                    ++i;
                }
                JTable table = new JTable(tableData, new String[]{"Parameter", "Value"});
                JScrollPane tableScroller = new JScrollPane(table);
                tableScroller.setHorizontalScrollBarPolicy(30);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.weighty = 1.0;
                gbc.weightx = 1.0;
                gbc.fill = 1;
                this.add(tableScroller, gbc);
                JPanel progressPanel = new JPanel();
                progressPanel.setBorder(new TitledBorder("Progress on Experiment"));
                JProgressBar progressBar = new JProgressBar();
                progressPanel.add(new JButton(new AbstractAction(this, "Start Experiment", progressPanel){
                    final /* synthetic */ RunExperimentWizard this$2;
                    private final /* synthetic */ JPanel val$progressPanel;
                    {
                        this.this$2 = runExperimentWizard;
                        this.val$progressPanel = jPanel;
                        super($anonymous0);
                    }

                    public void actionPerformed(ActionEvent ev) {
                        Blocker blocker = (Blocker)RunExperimentWizard.access$0((RunExperimentWizard)this.this$2).viewerContext.get("Blocker");
                        StringDistanceLearner learner = (StringDistanceLearner)RunExperimentWizard.access$0((RunExperimentWizard)this.this$2).viewerContext.get("Distance");
                        File datafile = (File)RunExperimentWizard.access$0((RunExperimentWizard)this.this$2).viewerContext.get("File");
                        MatchData data = new MatchData(datafile.getAbsolutePath());
                        Thread exptThread = new Thread(this, data, learner, blocker, this.val$progressPanel){
                            final /* synthetic */ 1 this$3;
                            private final /* synthetic */ MatchData val$data;
                            private final /* synthetic */ StringDistanceLearner val$learner;
                            private final /* synthetic */ Blocker val$blocker;
                            private final /* synthetic */ JPanel val$progressPanel;
                            {
                                this.this$3 = var1_1;
                                this.val$data = matchData;
                                this.val$learner = stringDistanceLearner;
                                this.val$blocker = blocker;
                                this.val$progressPanel = jPanel;
                            }

                            public void run() {
                                RunExperiment.access$0(RunExperimentWizard.access$0(1.access$0(this.this$3)), new MatchExpt(this.val$data, this.val$learner, this.val$blocker));
                                RunExperiment.access$2(RunExperimentWizard.access$0(1.access$0(this.this$3)), RunExperiment.access$1(RunExperimentWizard.access$0(1.access$0(this.this$3))).toGUI());
                                RunExperimentWizard.access$0((RunExperimentWizard)1.access$0(this.this$3)).viewerContext.put("MatchExpt", RunExperiment.access$1(RunExperimentWizard.access$0(1.access$0(this.this$3))));
                                RunExperimentWizard.access$0((RunExperimentWizard)1.access$0(this.this$3)).viewerContext.put("ExptViewer", RunExperiment.access$3(RunExperimentWizard.access$0(1.access$0(this.this$3))));
                                RunExperiment.access$4(RunExperimentWizard.access$0(1.access$0(this.this$3)), true);
                                this.val$progressPanel.add(new JLabel("Experiment complete!"));
                                this.val$progressPanel.revalidate();
                            }
                        };
                        exptThread.start();
                    }

                    static /* synthetic */ RunExperimentWizard access$0(1 var0) {
                        return var0.this$2;
                    }
                }));
                ProgressCounter.setGraphicContext((JProgressBar[])new JProgressBar[]{progressBar});
                progressPanel.add(progressBar);
                gbc = new GridBagConstraints();
                gbc.weightx = 1.0;
                gbc.weighty = 0.5;
                gbc.gridy = 1;
                gbc.fill = 2;
                this.add(progressPanel, gbc);
            }

            public boolean hasNext() {
                return true;
            }

            public boolean validateNext(List list) {
                list.clear();
                list.add("You need to run the experiment and wait for it to finish before you can go to the next step.");
                return RunExperiment.this.matchExptComplete;
            }

            public WizardPanel next() {
                return new ShowResults(RunExperiment.this.viewerContext).getWizardPanel();
            }

            static /* synthetic */ RunExperiment access$0(RunExperimentWizard runExperimentWizard) {
                return runExperimentWizard.RunExperiment.this;
            }
        }

        private class ResultWizardPanel
        extends NullWizardPanel {
            public ResultWizardPanel(Viewer v) {
                this.setBorder(new TitledBorder("SecondString: results"));
                this.add((Component)v);
            }
        }
    }

    private static class ShowResults
    extends WizardViewer {
        public ShowResults(Map viewerContext) {
            super("Result", viewerContext);
        }

        public WizardPanel buildWizardPanel() {
            return new ResultWizardPanel((Viewer)this.viewerContext.get("ExptViewer"), new SaveResults(this.viewerContext).getWizardPanel());
        }
    }

    private static class ResultWizardPanel
    extends NullWizardPanel {
        WizardPanel nextPanel = null;

        public ResultWizardPanel(Viewer v, WizardPanel nextPanel) {
            this.nextPanel = nextPanel;
            this.setBorder(new TitledBorder("SecondString: results"));
            this.add((Component)v);
        }

        public boolean hasNext() {
            return this.nextPanel != null;
        }

        public boolean validateNext(List list) {
            return this.nextPanel != null;
        }

        public WizardPanel next() {
            return this.nextPanel;
        }
    }

    private static class SaveResults
    extends WizardViewer {
        private boolean fileWasSaved = false;

        public SaveResults(Map viewerContext) {
            super("SavedResult", viewerContext);
        }

        public WizardPanel buildWizardPanel() {
            return new SaveResultPanel((Viewer)this);
        }

        static /* synthetic */ void access$0(SaveResults saveResults, boolean bl) {
            saveResults.fileWasSaved = bl;
        }

        private class SaveResultPanel
        extends NullWizardPanel {
            public SaveResultPanel(Viewer enclosingViewer) {
                this.setBorder(new TitledBorder("SecondString: save results?"));
                this.add(new JLabel("Select a file to store these results in:"));
                JTextField filePane = new JTextField(20);
                filePane.setEditable(false);
                this.add(filePane);
                JFileChooser chooser = new JFileChooser();
                this.add(new JButton(new AbstractAction(this, "Browse", chooser, filePane){
                    final /* synthetic */ SaveResultPanel this$2;
                    private final /* synthetic */ JFileChooser val$chooser;
                    private final /* synthetic */ JTextField val$filePane;
                    {
                        this.this$2 = saveResultPanel;
                        this.val$chooser = jFileChooser;
                        this.val$filePane = jTextField;
                        super($anonymous0);
                    }

                    public void actionPerformed(ActionEvent ev) {
                        int returnVal = this.val$chooser.showSaveDialog(null);
                        if (returnVal == 0) {
                            File file = this.val$chooser.getSelectedFile();
                            this.val$filePane.setText(file.getName());
                            Object evaluation = ((Viewer)SaveResultPanel.access$0((SaveResultPanel)this.this$2).viewerContext.get("ExptViewer")).getContent();
                            try {
                                IOUtil.saveSerialized((Serializable)((Serializable)evaluation), (File)file);
                                SaveResults.access$0(SaveResultPanel.access$0(this.this$2), true);
                            }
                            catch (IOException ex) {
                                System.err.println("error saving: " + ex);
                            }
                        }
                    }
                }));
            }

            public boolean canFinish() {
                return true;
            }

            public boolean validateFinish(List list) {
                list.add("You haven't saved the results. Click cancel to exit without saving them");
                return SaveResults.this.fileWasSaved;
            }

            static /* synthetic */ SaveResults access$0(SaveResultPanel saveResultPanel) {
                return saveResultPanel.SaveResults.this;
            }
        }
    }
}

