/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.expt;

import com.wcohen.ss.api.DistanceInstance;
import com.wcohen.ss.api.StringWrapper;
import com.wcohen.ss.expt.MatchData;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;

public abstract class Blocker {
    protected boolean clusterMode;

    public abstract void block(MatchData var1);

    public abstract Pair getPair(int var1);

    public abstract int size();

    public final void setClusterMode(boolean flag) {
        this.clusterMode = flag;
    }

    public final void setClusterMode(Boolean flag) {
        this.clusterMode = flag;
    }

    public abstract int numCorrectPairs();

    protected int countCorrectPairs(MatchData data) {
        HashMap<IdKey, Integer> counter = new HashMap<IdKey, Integer>();
        int i = 0;
        while (i < data.numSources()) {
            String src = data.getSource(i);
            int j = 0;
            while (j < data.numInstances(src)) {
                String id = data.getInstance(src, j).getId();
                if (id != null) {
                    IdKey key;
                    Integer c = (Integer)counter.get(key = new IdKey(id, src));
                    counter.put(key, c == null ? new Integer(1) : new Integer(c + 1));
                }
                ++j;
            }
            ++i;
        }
        int numCorrectPairs = 0;
        HashSet<String> idsInSrc1 = new HashSet<String>();
        int i2 = 0;
        while (i2 < data.numSources()) {
            String src1 = data.getSource(i2);
            idsInSrc1.clear();
            int j = 0;
            while (j < data.numInstances(src1)) {
                String id = data.getInstance(src1, j).getId();
                idsInSrc1.add(id);
                int k = i2 + 1;
                while (k < data.numSources()) {
                    String src2 = data.getSource(k);
                    Integer cInteger = (Integer)counter.get(new IdKey(id, src2));
                    if (cInteger != null) {
                        numCorrectPairs += cInteger.intValue();
                    }
                    ++k;
                }
                ++j;
            }
            if (this.clusterMode) {
                for (String id : idsInSrc1) {
                    Integer cInteger = (Integer)counter.get(new IdKey(id, src1));
                    int c = cInteger;
                    numCorrectPairs += c * (c - 1) / 2;
                }
            }
            ++i2;
        }
        return numCorrectPairs;
    }

    public static class Pair
    implements Comparable,
    Serializable,
    DistanceInstance {
        private static final long serialVersionUID = 1L;
        private static int CURRENT_SERIALIZED_VERSION_NUMBER = 1;
        private final transient StringWrapper a;
        private final transient StringWrapper b;
        private boolean sameIds;
        private double distance = -9999.0;

        public Pair(MatchData.Instance a, MatchData.Instance b, boolean sameIds) {
            this.a = a;
            this.b = b;
            this.sameIds = sameIds;
        }

        public String toString() {
            return "[pair: " + this.a + ";" + this.b + "]";
        }

        public StringWrapper getA() {
            return this.a;
        }

        public StringWrapper getB() {
            return this.b;
        }

        public boolean isCorrect() {
            return this.sameIds;
        }

        public double getDistance() {
            return this.distance;
        }

        public void setDistance(double d) {
            this.distance = d;
        }

        public int compareTo(Object o) {
            Pair other = (Pair)o;
            if (other.distance > this.distance) {
                return 1;
            }
            if (other.distance < this.distance) {
                return -1;
            }
            return 0;
        }
    }

    private static class IdKey {
        public String id;
        public String src;

        public IdKey(String id, String src) {
            this.id = id;
            this.src = src;
        }

        public int hashCode() {
            return this.id.hashCode() ^ this.src.hashCode();
        }

        public boolean equals(Object o) {
            IdKey key = (IdKey)o;
            return key.id.equals(this.id) && key.src.equals(this.src);
        }
    }
}

