/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.expt;

import com.wcohen.ss.BasicStringWrapper;
import com.wcohen.ss.api.StringWrapper;
import com.wcohen.ss.api.StringWrapperIterator;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MatchData {
    private Map sourceLists;
    private ArrayList sourceNames;
    private String filename;

    public MatchData(String filename) throws InputFormatException {
        this.filename = filename;
        this.sourceNames = new ArrayList();
        this.sourceLists = new HashMap();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            int lineNum = 0;
            while ((line = in.readLine()) != null) {
                ++lineNum;
                String[] tok = line.split("\t", -1);
                int toklen = tok.length;
                if (toklen < 1) {
                    throw new InputFormatException(filename, lineNum, "no source");
                }
                String src = tok[0];
                if (toklen < 2) {
                    throw new InputFormatException(filename, lineNum, "no id");
                }
                String id = tok[1];
                if (toklen < 3) {
                    throw new InputFormatException(filename, lineNum, "no text fields");
                }
                String text = tok[2];
                int i = 3;
                while (i < toklen) {
                    text = String.valueOf(text) + "\t" + tok[i];
                    ++i;
                }
                this.addInstance(src, id, text);
            }
            in.close();
        }
        catch (IOException e) {
            throw new InputFormatException(filename, 0, e.toString());
        }
    }

    public MatchData() {
        this.filename = "none";
        this.sourceNames = new ArrayList();
        this.sourceLists = new HashMap();
    }

    public void addInstance(String src, String id, String text) {
        Instance inst = new Instance(src, id, text);
        ArrayList<Instance> list = (ArrayList<Instance>)this.sourceLists.get(src);
        if (list == null) {
            list = new ArrayList<Instance>();
            this.sourceLists.put(src, list);
            this.sourceNames.add(src);
        }
        list.add(inst);
    }

    public int numSources() {
        return this.sourceNames.size();
    }

    public String getSource(int i) {
        return (String)this.sourceNames.get(i);
    }

    public int numInstances(String src) {
        return ((ArrayList)this.sourceLists.get(src)).size();
    }

    public Instance getInstance(String src, int j) {
        return (Instance)((ArrayList)this.sourceLists.get(src)).get(j);
    }

    public StringWrapperIterator getIterator() {
        return new MatchIterator(this);
    }

    public String getFilename() {
        return this.filename;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.numSources()) {
            String src = this.getSource(i);
            int j = 0;
            while (j < this.numInstances(src)) {
                Instance inst = this.getInstance(src, j);
                buf.append(String.valueOf(inst.toString()) + "\n");
                ++j;
            }
            ++i;
        }
        return buf.toString();
    }

    public static void main(String[] argv) {
        try {
            System.out.println(new MatchData(argv[0]).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Instance
    extends BasicStringWrapper {
        private final String source;
        private final String id;

        public Instance(String source, String id, String text) {
            super(text);
            this.source = source.trim();
            this.id = id.trim();
        }

        public String getSource() {
            return this.source;
        }

        public String getId() {
            return this.id;
        }

        public boolean sameId(Instance b) {
            return this.id != null && b.id != null && this.id.equals(b.id);
        }

        public String toString() {
            return "[src: '" + this.source + "' id: '" + this.id + "' unwrapped: '" + this.unwrap() + "']";
        }
    }

    public static class MatchIterator
    implements StringWrapperIterator {
        private int sourceCursor;
        private int instanceCursor;
        private String src;
        private MatchData data;

        public MatchIterator(MatchData data) {
            this.data = data;
            this.sourceCursor = 0;
            this.instanceCursor = 0;
            this.src = data.getSource(this.sourceCursor);
        }

        public void remove() {
            throw new IllegalStateException("remove not implemented");
        }

        public String getSource() {
            return this.src;
        }

        public StringWrapper nextStringWrapper() {
            return (StringWrapper)this.next();
        }

        public boolean hasNext() {
            return this.sourceCursor < this.data.numSources() && this.instanceCursor < this.data.numInstances(this.src);
        }

        public Object next() {
            Instance inst = this.data.getInstance(this.src, this.instanceCursor++);
            if (this.instanceCursor > this.data.numInstances(this.src)) {
                ++this.sourceCursor;
                this.instanceCursor = 0;
                if (this.sourceCursor < this.data.numSources()) {
                    this.src = this.data.getSource(this.sourceCursor);
                }
            }
            return inst;
        }
    }

    public static class InputFormatException
    extends RuntimeException {
        public InputFormatException(String file, int line, String msg) {
            super("line " + line + " of file " + file + ": " + msg);
        }
    }
}

