/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.QueryCmdUtils;
import arq.cmd.ResultsFormat;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.shared.PrefixMapping;

public class ModResultsOut
implements ArgModuleGeneral {
    protected final ArgDecl resultsFmtDecl = new ArgDecl(true, "results", "out", "rfmt");
    private ResultsFormat resultsFormat = ResultsFormat.FMT_UNKNOWN;

    public void processArgs(CmdArgModule cmdline) throws IllegalArgumentException {
        if (cmdline.contains(this.resultsFmtDecl)) {
            String rFmt = cmdline.getValue(this.resultsFmtDecl);
            this.resultsFormat = ResultsFormat.lookup(rFmt);
            if (this.resultsFormat == null) {
                cmdline.cmdError("Unrecognized output format: " + rFmt);
            }
        }
    }

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Results");
        cmdLine.add(this.resultsFmtDecl, "--results", "Results format (Result set: text, XML, JSON; Graph: RDF serialization)");
    }

    public void checkCommandLine(CmdArgModule cmdLine) {
    }

    public void printResultSet(ResultSet resultSet, PrefixMapping prefixMapping) {
        QueryCmdUtils.outputResultSet(resultSet, prefixMapping, this.resultsFormat);
    }

    public ResultsFormat getResultsFormat() {
        return this.resultsFormat;
    }
}

