/*
 * Decompiled with CFR 0.152.
 */
package arq.examples;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.expr.E_Regex;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeVar;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.DC;
import java.io.OutputStream;

public class ExProg2 {
    public static final String NL = System.getProperty("line.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Model model = ExProg2.createModel();
        Query query2 = QueryFactory.make();
        query2.setQueryType(111);
        ElementGroup elg = new ElementGroup();
        Var varTitle = Var.alloc((String)"title");
        Var varX = Var.alloc((String)"x");
        Triple t1 = new Triple((Node)varX, DC.title.asNode(), (Node)varTitle);
        elg.addTriplePattern(t1);
        E_Regex expr = new E_Regex((Expr)new NodeVar(varTitle), "sparql", "i");
        ElementFilter filter = new ElementFilter((Expr)expr);
        elg.addElementFilter(filter);
        query2.setQueryPattern((Element)elg);
        query2.addResultVar((Node)varTitle);
        query2.getPrefixMapping().setNsPrefix("dc", DC.getURI());
        query2.serialize(new IndentedWriter((OutputStream)System.out, true));
        System.out.println();
        QueryExecution qexec = QueryExecutionFactory.create((Query)query2, (Model)model);
        try {
            ResultSet rs = qexec.execSelect();
            System.out.println("Titles: ");
            while (rs.hasNext()) {
                QuerySolution rb = rs.nextSolution();
                RDFNode x = rb.get("title");
                if (x instanceof Literal) {
                    Literal titleStr = (Literal)x;
                    System.out.println("    " + titleStr);
                    continue;
                }
                System.out.println("Strange - not a literal: " + x);
            }
        }
        finally {
            qexec.close();
        }
    }

    public static Model createModel() {
        Model model = ModelFactory.createDefaultModel();
        Resource r1 = model.createResource("http://example.org/book#1");
        Resource r2 = model.createResource("http://example.org/book#2");
        Resource r3 = model.createResource("http://example.org/book#3");
        r1.addProperty(DC.title, "SPARQL - the book").addProperty(DC.description, "A book about SPARQL");
        r2.addProperty(DC.title, "Advanced techniques for SPARQL");
        r3.addProperty(DC.title, "Jena - an RDF framework for Java").addProperty(DC.description, "A book about Jena");
        return model;
    }
}

