/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.util.GraphUtils;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestAPI
extends TestCase {
    private static final String ns = "http://example/ns#";
    Model m = null;

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestAPI.class);
        ts.setName("TestMisc");
        return ts;
    }

    public void setUp() {
        this.m = GraphUtils.makeJenaDefaultModel();
        Resource r1 = this.m.createResource();
        Property p1 = this.m.createProperty("http://example/ns#p1");
        Property p2 = this.m.createProperty("http://example/ns#p1");
        Property p3 = this.m.createProperty("http://example/ns#p1");
        this.m.add(r1, p1, "x1");
        this.m.add(r1, p2, "X2");
        this.m.add(r1, p3, "y1");
    }

    public void tearDown() {
    }

    public void testInitialBindingsConstruct() {
        QueryExecution qExec = this.makeQExec("CONSTRUCT {?s ?p ?z} {?s ?p 'x1'}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("z", (RDFNode)this.m.createLiteral("zzz"));
        qExec.setInitialBinding((QuerySolution)init);
        Model r = qExec.execConstruct();
        TestAPI.assertTrue((String)"Empty model", (r.size() > 0L ? 1 : 0) != 0);
        Property p1 = this.m.createProperty("http://example/ns#p1");
        TestAPI.assertTrue((String)"Empty model", (boolean)r.contains(null, p1, init.get("z")));
        qExec.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_API1() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");
        try {
            ResultSet rs = qExec.execSelect();
            TestAPI.assertTrue((String)"No results", (boolean)rs.hasNext());
            QuerySolution qs = rs.nextSolution();
            Resource qr = qs.getResource("s");
            TestAPI.assertSame((String)"Not the same model as queried", (Object)qr.getModel(), (Object)this.m);
        }
        finally {
            qExec.close();
        }
    }

    public void testInitialBindings1() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("o", (RDFNode)this.m.createLiteral("y1"));
        qExec.setInitialBinding((QuerySolution)init);
        int count = this.queryAndCount(qExec);
        TestAPI.assertEquals((String)"Initial binding didn't restrict query properly", (int)1, (int)count);
    }

    public void testInitialBindings2() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("z", (RDFNode)this.m.createLiteral("zzz"));
        qExec.setInitialBinding((QuerySolution)init);
        int count = this.queryAndCount(qExec);
        TestAPI.assertEquals((String)"Initial binding restricted query improperly", (int)3, (int)count);
    }

    public void testInitialBindings3() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p 'x1'}");
        QuerySolutionMap init = new QuerySolutionMap();
        init.add("z", (RDFNode)this.m.createLiteral("zzz"));
        qExec.setInitialBinding((QuerySolution)init);
        ResultSet rs = qExec.execSelect();
        QuerySolution qs = rs.nextSolution();
        TestAPI.assertTrue((String)"Initial setting not set correctly now", (boolean)qs.getLiteral("z").getLexicalForm().equals("zzz"));
        qExec.close();
    }

    private QueryExecution makeQExec(String queryString) {
        Query q = QueryFactory.create((String)queryString);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Model)this.m);
        return qExec;
    }

    private int queryAndCount(String queryString) {
        QueryExecution qExec = this.makeQExec(queryString);
        return this.queryAndCount(qExec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int queryAndCount(QueryExecution qExec) {
        try {
            ResultSet rs = qExec.execSelect();
            int n = ResultSetFormatter.consume((ResultSet)rs);
            return n;
        }
        finally {
            qExec.close();
        }
    }
}

