/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprNotComparableException;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.nodevalue.Functions;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueDecimal;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueDouble;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueFloat;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueInteger;
import com.hp.hpl.jena.query.util.Symbol;
import com.hp.hpl.jena.query.util.Utils;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestFunctions
extends TestCase {
    private static final double accuracyExact_D = 0.0;
    private static final double accuracyExact_F = 0.0;
    private static final double accuracyClose_D = 1.0E-6;
    private static final double accuracyClose_F = (double)1.0E-6f;

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestFunctions.class);
        ts.setName(Utils.classShortName((Class)TestFunctions.class));
        return ts;
    }

    public void testAddIntegerInteger() {
        NodeValue nv1 = NodeValue.makeInteger((long)5L);
        NodeValue nv2 = NodeValue.makeInteger((long)7L);
        NodeValue r = Functions.add((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        TestFunctions.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        TestFunctions.assertEquals((String)"Wrong result", (long)12L, (long)r.getInteger().longValue());
    }

    public void testAddDecimalDecimal() {
        NodeValue nv1 = NodeValue.makeDecimal((double)4.3);
        NodeValue nv2 = NodeValue.makeDecimal((double)3.7);
        NodeValue r = Functions.add((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDecimal().doubleValue(), (double)0.0);
    }

    public void testAddFloatFloat() {
        NodeValue nv1 = NodeValue.makeFloat((float)7.5f);
        NodeValue nv2 = NodeValue.makeFloat((float)2.5f);
        NodeValue r = Functions.add((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a float: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestFunctions.assertEquals((String)"Wrong result", (double)10.0, (double)r.getFloat(), (double)0.0);
        TestFunctions.assertEquals((String)"Wrong result (as doubles)", (double)10.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddDoubleDouble() {
        NodeValue nv1 = NodeValue.makeDouble((double)7.5);
        NodeValue nv2 = NodeValue.makeDouble((double)2.5);
        NodeValue r = Functions.add((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)10.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddIntegerDecimal() {
        NodeValue nv1 = NodeValue.makeInteger((long)5L);
        NodeValue nv2 = NodeValue.makeDecimal((long)7L);
        NodeValue r = Functions.add((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (long)12L, (long)r.getDecimal().longValue());
    }

    public void testAddDecimalInteger() {
        NodeValue nv1 = NodeValue.makeDecimal((long)7L);
        NodeValue nv2 = NodeValue.makeInteger((long)5L);
        NodeValue r = Functions.add((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (long)12L, (long)r.getDecimal().longValue());
    }

    public void testAddIntegerFloat() {
        NodeValue nv1 = NodeValue.makeInteger((long)5L);
        NodeValue nv2 = NodeValue.makeFloat((float)7.0f);
        NodeValue r = Functions.add((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a float: " + r), (boolean)r.isFloat());
        TestFunctions.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestFunctions.assertEquals((String)"Wrong result", (double)12.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddFloatInteger() {
        NodeValue nv1 = NodeValue.makeFloat((float)7.0f);
        NodeValue nv2 = NodeValue.makeInteger((long)5L);
        NodeValue r = Functions.add((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a float: " + r), (boolean)r.isFloat());
        TestFunctions.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestFunctions.assertEquals((String)"Wrong result", (double)12.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddIntegerDouble() {
        NodeValue nv1 = NodeValue.makeInteger((long)5L);
        NodeValue nv2 = NodeValue.makeDouble((double)7.0);
        NodeValue r = Functions.add((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)12.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddDoubleInteger() {
        NodeValue nv1 = NodeValue.makeDouble((double)7.0);
        NodeValue nv2 = NodeValue.makeInteger((long)5L);
        NodeValue r = Functions.add((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)12.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddDecimalFloat() {
        NodeValue nv1 = NodeValue.makeDecimal((double)3.5);
        NodeValue nv2 = NodeValue.makeFloat((float)4.5f);
        NodeValue r = Functions.add((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a Float: " + r), (boolean)r.isFloat());
        TestFunctions.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestFunctions.assertEquals((String)"Wrong result", (double)8.0, (double)r.getFloat(), (double)0.0);
    }

    public void testAddFloatDecimal() {
        NodeValue nv1 = NodeValue.makeFloat((float)4.5f);
        NodeValue nv2 = NodeValue.makeDecimal((double)3.5);
        NodeValue r = Functions.add((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a Float: " + r), (boolean)r.isFloat());
        TestFunctions.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestFunctions.assertEquals((String)"Wrong result", (double)8.0, (double)r.getFloat(), (double)0.0);
    }

    public void testAddDecimalDouble() {
        NodeValue nv1 = NodeValue.makeDecimal((double)3.5);
        NodeValue nv2 = NodeValue.makeDouble((double)4.5);
        NodeValue r = Functions.add((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddDoubleDecimal() {
        NodeValue nv1 = NodeValue.makeDouble((double)4.5);
        NodeValue nv2 = NodeValue.makeDecimal((double)3.5);
        NodeValue r = Functions.add((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddDoubleFloat() {
        NodeValue nv1 = NodeValue.makeDouble((double)4.5);
        NodeValue nv2 = NodeValue.makeFloat((float)3.5f);
        NodeValue r = Functions.add((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddFloatDouble() {
        NodeValue nv1 = NodeValue.makeFloat((float)4.5f);
        NodeValue nv2 = NodeValue.makeDouble((double)3.5);
        NodeValue r = Functions.add((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDouble(), (double)0.0);
    }

    public void testDivideIntegerInteger() {
        NodeValue nv1 = NodeValue.makeInteger((long)25L);
        NodeValue nv2 = NodeValue.makeInteger((long)2L);
        NodeValue r = Functions.divide((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (double)12.5, (double)r.getDecimal().doubleValue(), (double)0.0);
    }

    public void testDivideByZero1() {
        NodeValue nv1 = NodeValue.makeInteger((long)1L);
        NodeValue nv2 = NodeValue.makeInteger((long)0L);
        try {
            NodeValue r = Functions.divide((NodeValue)nv1, (NodeValue)nv2);
            TestFunctions.fail((String)"No expection from .divide");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    public void testDivideByZero2() {
        NodeValue nv1 = NodeValue.makeInteger((long)1L);
        NodeValue nv2 = NodeValue.makeDouble((double)0.0);
        NodeValue r = Functions.divide((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a +INF: " + r), (r.getDouble() == Double.POSITIVE_INFINITY ? 1 : 0) != 0);
    }

    public void testDivideByZero4() {
        NodeValue nv1 = NodeValue.makeInteger((long)-1L);
        NodeValue nv2 = NodeValue.makeDouble((double)0.0);
        NodeValue r = Functions.divide((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a -INF: " + r), (r.getDouble() == Double.NEGATIVE_INFINITY ? 1 : 0) != 0);
    }

    public void testSubtractDoubleDecimal() {
        NodeValue nv1 = NodeValue.makeDouble((double)4.5);
        NodeValue nv2 = NodeValue.makeDecimal((double)3.5);
        NodeValue r = Functions.subtract((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)1.0, (double)r.getDouble(), (double)0.0);
    }

    public void testSubtractDecimalInteger() {
        NodeValue nv1 = NodeValue.makeDecimal((double)3.5);
        NodeValue nv2 = NodeValue.makeInteger((long)2L);
        NodeValue r = Functions.subtract((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertTrue((String)"Wrong result", (boolean)NodeValue.sameAs((NodeValue)NodeValue.makeDecimal((double)1.5), (NodeValue)r));
    }

    public void testMultiplyDoubleDecimal() {
        NodeValue nv1 = NodeValue.makeDouble((double)4.5);
        NodeValue nv2 = NodeValue.makeDecimal((double)3.5);
        NodeValue r = Functions.multiply((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)15.75, (double)r.getDouble(), (double)0.0);
    }

    public void testMultiplyDecimalInteger() {
        NodeValue nv1 = NodeValue.makeDecimal((double)3.5);
        NodeValue nv2 = NodeValue.makeInteger((long)2L);
        NodeValue r = Functions.multiply((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (long)7L, (long)r.getDecimal().longValue());
    }

    public void testCompare1() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeInteger((long)7L);
        TestFunctions.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)-1, (int)NodeValue.compare((NodeValue)nv5, (NodeValue)nv7));
        NodeValue nv5b = NodeValue.makeInteger((long)5L);
        TestFunctions.assertEquals((String)("Does not compare " + nv5 + " & " + nv5b), (int)0, (int)NodeValue.compare((NodeValue)nv5, (NodeValue)nv5b));
    }

    public void testCompare2() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeNodeInteger((long)7L);
        TestFunctions.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)-1, (int)NodeValue.compare((NodeValue)nv5, (NodeValue)nv7));
        NodeValue nv5b = NodeValue.makeNodeInteger((long)5L);
        TestFunctions.assertEquals((String)("Does not compare " + nv5 + " & " + nv5b), (int)0, (int)NodeValue.compare((NodeValue)nv5, (NodeValue)nv5b));
    }

    public void testCompare3() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeDouble((double)7.0);
        TestFunctions.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)-1, (int)NodeValue.compare((NodeValue)nv5, (NodeValue)nv7));
    }

    public void testCompare4() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeFloat((float)7.0f);
        TestFunctions.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)-1, (int)NodeValue.compare((NodeValue)nv5, (NodeValue)nv7));
    }

    public void testCompare5() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeDecimal((long)7L);
        TestFunctions.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)-1, (int)NodeValue.compare((NodeValue)nv5, (NodeValue)nv7));
    }

    public void testCompare10() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2005-10-14T13:09:43Z");
        NodeValue nv2 = NodeValue.makeNodeDateTime((String)"2005-10-14T14:09:43Z");
        TestFunctions.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)-1, (int)NodeValue.compare((NodeValue)nv1, (NodeValue)nv2));
    }

    public void testCompare11() {
        NodeValue nv1 = NodeValue.makeDateTime((String)"2005-10-14T13:09:43-08:00");
        NodeValue nv2 = NodeValue.makeNodeDateTime((String)"2005-10-14T13:09:43+01:00");
        TestFunctions.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)1, (int)NodeValue.compare((NodeValue)nv1, (NodeValue)nv2));
    }

    public void testCompare12() {
        if (!ARQ.isTrue((Symbol)ARQ.strictSPARQL)) {
            NodeValue nv1 = NodeValue.makeDate((String)"2006-07-21-08:00");
            NodeValue nv2 = NodeValue.makeNodeDate((String)"2006-07-21+01:00");
            TestFunctions.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)1, (int)NodeValue.compare((NodeValue)nv1, (NodeValue)nv2));
        }
    }

    public void testCompare15() {
        NodeValue nv1 = NodeValue.makeDate((String)"2005-10-14Z");
        NodeValue nv2 = NodeValue.makeNodeDateTime((String)"2005-10-14T14:09:43Z");
        try {
            NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
            TestFunctions.assertFalse((String)("Compared the uncomparable: " + nv1 + " & " + nv2), (boolean)true);
        }
        catch (ExprNotComparableException exprNotComparableException) {
            // empty catch block
        }
    }

    public void testCompare20() {
        NodeValue nv1 = NodeValue.makeString((String)"abcd");
        NodeValue nv2 = NodeValue.makeNodeString((String)"abc");
        TestFunctions.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)1, (int)NodeValue.compare((NodeValue)nv1, (NodeValue)nv2));
    }

    public void testCompare21() {
        NodeValue nv5 = NodeValue.makeInteger((long)5L);
        NodeValue nv7 = NodeValue.makeString((String)"5");
        try {
            NodeValue.compare((NodeValue)nv5, (NodeValue)nv7);
            TestFunctions.fail((String)("Should not compare (but did) " + nv5 + " & " + nv7));
        }
        catch (ExprEvalException ex) {
            // empty catch block
        }
        int x = NodeValue.compareAlways((NodeValue)nv5, (NodeValue)nv7);
        TestFunctions.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)1, (int)NodeValue.compareAlways((NodeValue)nv5, (NodeValue)nv7));
    }

    public void testCompare22() {
        NodeValue nv1 = NodeValue.makeNodeString((String)"aaa");
        NodeValue nv2 = NodeValue.makeString((String)"aaabbb");
        int x = NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertEquals((String)"Not CMP_LESS", (int)x, (int)-1);
        TestFunctions.assertTrue((String)"It's CMP_GREATER", (x != 1 ? 1 : 0) != 0);
        TestFunctions.assertTrue((String)"It's CMP_EQUAL", (x != 0 ? 1 : 0) != 0);
    }

    public void testCompare23() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createAnon());
        NodeValue nv2 = NodeValue.makeString((String)"5");
        try {
            NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
            TestFunctions.fail((String)("Should not compare (but did) " + nv1 + " & " + nv2));
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    public void testSame1() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createURI((String)"test:abc"));
        NodeValue nv2 = NodeValue.makeNode((Node)Node.createURI((String)"test:abc"));
        TestFunctions.assertTrue((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        TestFunctions.assertFalse((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        try {
            NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
            TestFunctions.fail((String)("Should not compare (but did) " + nv1 + " & " + nv2));
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    public void testSame2() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createAnon());
        NodeValue nv2 = NodeValue.makeNode((Node)Node.createURI((String)"test:abc"));
        TestFunctions.assertFalse((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        TestFunctions.assertTrue((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        try {
            NodeValue.compare((NodeValue)nv1, (NodeValue)nv2);
            TestFunctions.fail((String)("Should not compare (but did) " + nv1 + " & " + nv2));
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    public void testCompareGeneral1() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createAnon());
        NodeValue nv2 = NodeValue.makeString((String)"5");
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)-1, (int)NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2));
    }

    public void testCompareGeneral2() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createAnon());
        NodeValue nv2 = NodeValue.makeNode((Node)Node.createURI((String)"test:abc"));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)-1, (int)NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2));
    }

    public void testCompareGeneral3() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createLiteral((String)"test:abc"));
        NodeValue nv2 = NodeValue.makeNode((Node)Node.createURI((String)"test:abc"));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)1, (int)NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2));
    }

    public void testCompareGeneral4() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createURI((String)"test:abc"));
        NodeValue nv2 = NodeValue.makeNode((Node)Node.createURI((String)"test:xyz"));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2);
        TestFunctions.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)-1, (int)NodeValue.compareAlways((NodeValue)nv1, (NodeValue)nv2));
    }

    public void testAbs1() {
        NodeValue nv = NodeValue.makeInteger((long)2L);
        NodeValue r = Functions.abs((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        TestFunctions.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        TestFunctions.assertEquals((String)"Wrong result", (long)2L, (long)r.getInteger().longValue());
    }

    public void testAbs2() {
        NodeValue nv = NodeValue.makeInteger((long)-2L);
        NodeValue r = Functions.abs((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        TestFunctions.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        TestFunctions.assertEquals((String)"Wrong result", (long)2L, (long)r.getInteger().longValue());
    }

    public void testAbs3() {
        NodeValue nv = NodeValue.makeDecimal((long)2L);
        NodeValue r = Functions.abs((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDecimal().doubleValue(), (double)0.0);
    }

    public void testAbs4() {
        NodeValue nv = NodeValue.makeDecimal((long)-2L);
        NodeValue r = Functions.abs((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDecimal().doubleValue(), (double)0.0);
    }

    public void testAbs5() {
        NodeValue nv = NodeValue.makeFloat((float)2.0f);
        NodeValue r = Functions.abs((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not an float: " + r), (boolean)r.isFloat());
        TestFunctions.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestFunctions.assertEquals((String)"Wrong result", (double)2.0, (double)r.getFloat(), (double)0.0);
    }

    public void testAbs6() {
        NodeValue nv = NodeValue.makeFloat((float)-2.0f);
        NodeValue r = Functions.abs((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not an float: " + r), (boolean)r.isFloat());
        TestFunctions.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestFunctions.assertEquals((String)"Wrong result", (double)2.0, (double)r.getFloat(), (double)0.0);
    }

    public void testAbs7() {
        NodeValue nv = NodeValue.makeDouble((double)2.0);
        NodeValue r = Functions.abs((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not an double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAbs8() {
        NodeValue nv = NodeValue.makeDouble((double)-2.0);
        NodeValue r = Functions.abs((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not an double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDouble(), (double)0.0);
    }

    public void testCeiling1() {
        NodeValue nv = NodeValue.makeDecimal((double)2.6);
        NodeValue r = Functions.ceiling((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (long)3L, (long)r.getDecimal().longValue());
    }

    public void testCeiling2() {
        NodeValue nv = NodeValue.makeDecimal((double)-3.6);
        NodeValue r = Functions.ceiling((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (long)-3L, (long)r.getDecimal().longValue());
    }

    public void testCeiling3() {
        NodeValue nv = NodeValue.makeDouble((double)2.6);
        NodeValue r = Functions.ceiling((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)3.0, (double)r.getDouble(), (double)0.0);
    }

    public void testCeiling4() {
        NodeValue nv = NodeValue.makeDouble((double)-3.6);
        NodeValue r = Functions.ceiling((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)-3.0, (double)r.getDouble(), (double)0.0);
    }

    public void testCeiling5() {
        NodeValue nv = NodeValue.makeInteger((long)3L);
        NodeValue r = Functions.ceiling((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        TestFunctions.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        TestFunctions.assertEquals((String)"Wrong result", (long)3L, (long)r.getInteger().longValue());
    }

    public void testFloor1() {
        NodeValue nv = NodeValue.makeDecimal((double)2.6);
        NodeValue r = Functions.floor((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (long)2L, (long)r.getDecimal().longValue());
    }

    public void testFloor2() {
        NodeValue nv = NodeValue.makeDecimal((double)-3.6);
        NodeValue r = Functions.floor((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (long)-4L, (long)r.getDecimal().longValue());
    }

    public void testFloor3() {
        NodeValue nv = NodeValue.makeDouble((double)2.6);
        NodeValue r = Functions.floor((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDouble(), (double)0.0);
    }

    public void testFloor4() {
        NodeValue nv = NodeValue.makeDouble((double)-3.6);
        NodeValue r = Functions.floor((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)-4.0, (double)r.getDouble(), (double)0.0);
    }

    public void testFloor5() {
        NodeValue nv = NodeValue.makeInteger((long)3L);
        NodeValue r = Functions.floor((NodeValue)nv);
        TestFunctions.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        TestFunctions.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        TestFunctions.assertEquals((String)"Wrong result", (long)3L, (long)r.getInteger().longValue());
    }
}

