/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import weka.associations.Associator;
import weka.associations.ItemSet;
import weka.associations.PriorEstimation;
import weka.associations.RuleGeneration;
import weka.associations.RuleItem;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public class PredictiveApriori
extends Associator
implements OptionHandler {
    protected int m_premiseCount;
    protected int m_numRules;
    protected static final int m_numRandRules = 1000;
    protected static final int m_numIntervals = 100;
    protected FastVector m_Ls;
    protected FastVector m_hashtables;
    protected FastVector[] m_allTheRules;
    protected Instances m_instances;
    protected Hashtable m_priors;
    protected double[] m_midPoints;
    protected double m_expectation;
    protected TreeSet m_best;
    protected boolean m_bestChanged;
    protected int m_count;
    protected PriorEstimation m_priorEstimator;

    public String globalInfo() {
        return "Finds association rules sorted by predictive accuracy.";
    }

    public PredictiveApriori() {
        this.resetOptions();
    }

    public void resetOptions() {
        this.m_numRules = 105;
        this.m_premiseCount = 1;
        this.m_best = new TreeSet();
        this.m_bestChanged = false;
        this.m_expectation = 0.0;
        this.m_count = 1;
    }

    public void buildAssociations(Instances instances) throws Exception {
        int n;
        int n2 = this.m_premiseCount;
        int n3 = this.m_numRules - 5;
        if (instances.checkForStringAttributes()) {
            throw new Exception("Can't handle string attributes!");
        }
        this.m_instances = new Instances(instances);
        this.m_instances.setClassIndex(this.m_instances.numAttributes() - 1);
        this.m_priorEstimator = new PriorEstimation(this.m_instances, 1000, 100, false);
        this.m_priors = this.m_priorEstimator.estimatePrior();
        this.m_midPoints = this.m_priorEstimator.getMidPoints();
        this.m_Ls = new FastVector();
        this.m_hashtables = new FastVector();
        for (n = 1; n < this.m_instances.numAttributes(); ++n) {
            this.m_bestChanged = false;
            this.findLargeItemSets(n);
            this.findRulesQuickly();
            if (this.m_bestChanged) {
                n2 = this.m_premiseCount;
                while (RuleGeneration.expectation(this.m_premiseCount, this.m_premiseCount, this.m_midPoints, this.m_priors) <= this.m_expectation) {
                    ++this.m_premiseCount;
                    if (this.m_premiseCount <= this.m_instances.numInstances()) continue;
                }
            }
            if (this.m_premiseCount > this.m_instances.numInstances()) {
                this.m_allTheRules = new FastVector[3];
                this.m_allTheRules[0] = new FastVector();
                this.m_allTheRules[1] = new FastVector();
                this.m_allTheRules[2] = new FastVector();
                int n4 = 0;
                while (this.m_best.size() > 0 && n3 > 0) {
                    this.m_allTheRules[0].insertElementAt(((RuleItem)this.m_best.last()).premise(), n4);
                    this.m_allTheRules[1].insertElementAt(((RuleItem)this.m_best.last()).consequence(), n4);
                    this.m_allTheRules[2].insertElementAt(new Double(((RuleItem)this.m_best.last()).accuracy()), n4);
                    boolean bl = this.m_best.remove(this.m_best.last());
                    ++n4;
                    --n3;
                }
                return;
            }
            if (n2 == this.m_premiseCount || this.m_Ls.size() <= 0) continue;
            FastVector fastVector = (FastVector)this.m_Ls.lastElement();
            this.m_Ls.removeElementAt(this.m_Ls.size() - 1);
            fastVector = ItemSet.deleteItemSets(fastVector, this.m_premiseCount, Integer.MAX_VALUE);
            this.m_Ls.addElement(fastVector);
        }
        this.m_allTheRules = new FastVector[3];
        this.m_allTheRules[0] = new FastVector();
        this.m_allTheRules[1] = new FastVector();
        this.m_allTheRules[2] = new FastVector();
        n = 0;
        while (this.m_best.size() > 0 && n3 > 0) {
            this.m_allTheRules[0].insertElementAt(((RuleItem)this.m_best.last()).premise(), n);
            this.m_allTheRules[1].insertElementAt(((RuleItem)this.m_best.last()).consequence(), n);
            this.m_allTheRules[2].insertElementAt(new Double(((RuleItem)this.m_best.last()).accuracy()), n);
            boolean bl = this.m_best.remove(this.m_best.last());
            ++n;
            --n3;
        }
    }

    public Enumeration listOptions() {
        String string = "\tThe required number of rules. (default = " + (this.m_numRules - 5) + ")";
        FastVector fastVector = new FastVector(1);
        fastVector.addElement(new Option(string, "N", 1, "-N <required number of rules output>"));
        return fastVector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('N', stringArray);
        this.m_numRules = string.length() != 0 ? Integer.parseInt(string) + 5 : Integer.MAX_VALUE;
    }

    public String[] getOptions() {
        String[] stringArray = new String[10];
        int n = 0;
        stringArray[n++] = "-N";
        stringArray[n++] = "" + (this.m_numRules - 5);
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_allTheRules[0].size() == 0) {
            return "\nNo large itemsets and rules found!\n";
        }
        stringBuffer.append("\nPredictiveApriori\n===================\n\n");
        stringBuffer.append("\nBest rules found:\n\n");
        for (int i = 0; i < this.m_allTheRules[0].size(); ++i) {
            stringBuffer.append(Utils.doubleToString((double)i + 1.0, (int)(Math.log(this.m_numRules) / Math.log(10.0) + 1.0), 0) + ". " + ((ItemSet)this.m_allTheRules[0].elementAt(i)).toString(this.m_instances) + " ==> " + ((ItemSet)this.m_allTheRules[1].elementAt(i)).toString(this.m_instances) + "    acc:(" + Utils.doubleToString((Double)this.m_allTheRules[2].elementAt(i), 5) + ")");
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public String numRulesTipText() {
        return "Number of rules to find.";
    }

    public int getNumRules() {
        return this.m_numRules - 5;
    }

    public void setNumRules(int n) {
        this.m_numRules = n + 5;
    }

    private void findLargeItemSets(int n) throws Exception {
        FastVector fastVector = new FastVector();
        int n2 = 0;
        if (n == 1) {
            fastVector = ItemSet.singletons(this.m_instances);
            ItemSet.upDateCounters(fastVector, this.m_instances);
            fastVector = ItemSet.deleteItemSets(fastVector, this.m_premiseCount, Integer.MAX_VALUE);
            if (fastVector.size() == 0) {
                return;
            }
            this.m_Ls.addElement(fastVector);
        }
        if (n > 1) {
            if (this.m_Ls.size() > 0) {
                fastVector = (FastVector)this.m_Ls.lastElement();
            }
            this.m_Ls.removeAllElements();
            n2 = n - 2;
            FastVector fastVector2 = fastVector;
            fastVector = ItemSet.mergeAllItemSets(fastVector2, n2, this.m_instances.numInstances());
            Hashtable hashtable = ItemSet.getHashtable(fastVector2, fastVector2.size());
            this.m_hashtables.addElement(hashtable);
            fastVector = ItemSet.pruneItemSets(fastVector, hashtable);
            ItemSet.upDateCounters(fastVector, this.m_instances);
            fastVector = ItemSet.deleteItemSets(fastVector, this.m_premiseCount, Integer.MAX_VALUE);
            if (fastVector.size() == 0) {
                return;
            }
            this.m_Ls.addElement(fastVector);
        }
    }

    private void findRulesQuickly() throws Exception {
        for (int i = 0; i < this.m_Ls.size(); ++i) {
            FastVector fastVector = (FastVector)this.m_Ls.elementAt(i);
            Enumeration enumeration = fastVector.elements();
            while (enumeration.hasMoreElements()) {
                RuleGeneration ruleGeneration = new RuleGeneration((ItemSet)enumeration.nextElement());
                this.m_best = ruleGeneration.generateRules(this.m_numRules, this.m_midPoints, this.m_priors, this.m_expectation, this.m_instances, this.m_best, this.m_count);
                this.m_count = ruleGeneration.m_count;
                if (!this.m_bestChanged && ruleGeneration.m_change) {
                    this.m_bestChanged = true;
                }
                if (this.m_best.size() > 0) {
                    this.m_expectation = ((RuleItem)this.m_best.first()).accuracy();
                    continue;
                }
                this.m_expectation = 0.0;
            }
        }
    }

    public static void main(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        PredictiveApriori predictiveApriori = new PredictiveApriori();
        try {
            stringBuffer.append("\n\nPredictiveApriori options:\n\n");
            stringBuffer.append("-t <training file>\n");
            stringBuffer.append("\tThe name of the training file.\n");
            Enumeration enumeration = predictiveApriori.listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                stringBuffer.append(option.synopsis() + '\n');
                stringBuffer.append(option.description() + '\n');
            }
            String string = Utils.getOption('t', stringArray);
            if (string.length() == 0) {
                throw new Exception("No training file given!");
            }
            predictiveApriori.setOptions(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            predictiveApriori.buildAssociations(new Instances(bufferedReader));
            System.out.println(predictiveApriori);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("\n" + exception.getMessage() + stringBuffer);
        }
    }
}

