/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.clusterers.DensityBasedClusterer;
import weka.clusterers.NumberOfClustersRequestable;
import weka.clusterers.SimpleKMeans;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.estimators.DiscreteEstimator;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class MakeDensityBasedClusterer
extends DensityBasedClusterer
implements NumberOfClustersRequestable,
OptionHandler,
WeightedInstancesHandler {
    private Instances m_theInstances;
    private double[] m_priors;
    private double[][][] m_modelNormal;
    private DiscreteEstimator[][] m_model;
    private double m_minStdDev = 1.0E-6;
    private Clusterer m_wrappedClusterer = new SimpleKMeans();
    private ReplaceMissingValues m_replaceMissing;
    private static double m_normConst = 0.5 * Math.log(Math.PI * 2);

    public MakeDensityBasedClusterer() {
    }

    public MakeDensityBasedClusterer(Clusterer clusterer) {
        this.setClusterer(clusterer);
    }

    public void setNumClusters(int n) throws Exception {
        if (this.m_wrappedClusterer == null) {
            throw new Exception("Can't set the number of clusters to generate - no clusterer has been set yet.");
        }
        if (!(this.m_wrappedClusterer instanceof NumberOfClustersRequestable)) {
            throw new Exception("Can't set the number of clusters to generate - wrapped clusterer does not support this facility.");
        }
        ((NumberOfClustersRequestable)((Object)this.m_wrappedClusterer)).setNumClusters(n);
    }

    public void buildClusterer(Instances instances) throws Exception {
        int n;
        int n2;
        this.m_replaceMissing = new ReplaceMissingValues();
        this.m_replaceMissing.setInputFormat(instances);
        instances = Filter.useFilter(instances, this.m_replaceMissing);
        this.m_theInstances = new Instances(instances, 0);
        if (this.m_wrappedClusterer == null) {
            throw new Exception("No clusterer has been set");
        }
        this.m_wrappedClusterer.buildClusterer(instances);
        this.m_model = new DiscreteEstimator[this.m_wrappedClusterer.numberOfClusters()][instances.numAttributes()];
        this.m_modelNormal = new double[this.m_wrappedClusterer.numberOfClusters()][instances.numAttributes()][2];
        double[][] dArray = new double[this.m_wrappedClusterer.numberOfClusters()][instances.numAttributes()];
        this.m_priors = new double[this.m_wrappedClusterer.numberOfClusters()];
        for (int i = 0; i < this.m_wrappedClusterer.numberOfClusters(); ++i) {
            for (int j = 0; j < instances.numAttributes(); ++j) {
                if (!instances.attribute(j).isNominal()) continue;
                this.m_model[i][j] = new DiscreteEstimator(instances.attribute(j).numValues(), true);
            }
        }
        Instance instance = null;
        int[] nArray = new int[instances.numInstances()];
        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
            instance = instances.instance(n2);
            int n3 = n = this.m_wrappedClusterer.clusterInstance(instance);
            this.m_priors[n3] = this.m_priors[n3] + instance.weight();
            for (int i = 0; i < instances.numAttributes(); ++i) {
                if (instance.isMissing(i)) continue;
                if (instances.attribute(i).isNominal()) {
                    this.m_model[n][i].addValue(instance.value(i), instance.weight());
                    continue;
                }
                double[] dArray2 = this.m_modelNormal[n][i];
                dArray2[0] = dArray2[0] + instance.weight() * instance.value(i);
                double[] dArray3 = dArray[n];
                int n4 = i;
                dArray3[n4] = dArray3[n4] + instance.weight();
            }
            nArray[n2] = n;
        }
        for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
            if (!instances.attribute(n2).isNumeric()) continue;
            for (n = 0; n < this.m_wrappedClusterer.numberOfClusters(); ++n) {
                if (!(dArray[n][n2] > 0.0)) continue;
                double[] dArray4 = this.m_modelNormal[n][n2];
                dArray4[0] = dArray4[0] / dArray[n][n2];
            }
        }
        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
            instance = instances.instance(n2);
            for (n = 0; n < instances.numAttributes(); ++n) {
                if (instance.isMissing(n) || !instances.attribute(n).isNumeric()) continue;
                double d = this.m_modelNormal[nArray[n2]][n][0] - instance.value(n);
                double[] dArray5 = this.m_modelNormal[nArray[n2]][n];
                dArray5[1] = dArray5[1] + instance.weight() * d * d;
            }
        }
        for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
            if (!instances.attribute(n2).isNumeric()) continue;
            for (n = 0; n < this.m_wrappedClusterer.numberOfClusters(); ++n) {
                if (dArray[n][n2] > 0.0) {
                    this.m_modelNormal[n][n2][1] = Math.sqrt(this.m_modelNormal[n][n2][1] / dArray[n][n2]);
                } else if (dArray[n][n2] <= 0.0) {
                    this.m_modelNormal[n][n2][1] = Double.MAX_VALUE;
                }
                if (!(this.m_modelNormal[n][n2][1] <= this.m_minStdDev)) continue;
                this.m_modelNormal[n][n2][1] = instances.attributeStats((int)n2).numericStats.stdDev;
                if (!(this.m_modelNormal[n][n2][1] <= this.m_minStdDev)) continue;
                this.m_modelNormal[n][n2][1] = this.m_minStdDev;
            }
        }
        Utils.normalize(this.m_priors);
    }

    public double[] clusterPriors() {
        double[] dArray = new double[this.m_priors.length];
        System.arraycopy(this.m_priors, 0, dArray, 0, dArray.length);
        return dArray;
    }

    public double[] logDensityPerClusterForInstance(Instance instance) throws Exception {
        double[] dArray = new double[this.m_wrappedClusterer.numberOfClusters()];
        this.m_replaceMissing.input(instance);
        instance = this.m_replaceMissing.output();
        for (int i = 0; i < this.m_wrappedClusterer.numberOfClusters(); ++i) {
            double d = 0.0;
            for (int j = 0; j < instance.numAttributes(); ++j) {
                if (instance.isMissing(j)) continue;
                if (instance.attribute(j).isNominal()) {
                    d += Math.log(this.m_model[i][j].getProbability(instance.value(j)));
                    continue;
                }
                d += this.logNormalDens(instance.value(j), this.m_modelNormal[i][j][0], this.m_modelNormal[i][j][1]);
            }
            dArray[i] = d;
        }
        return dArray;
    }

    private double logNormalDens(double d, double d2, double d3) {
        double d4 = d - d2;
        return -(d4 * d4 / (2.0 * d3 * d3)) - m_normConst - Math.log(d3);
    }

    public int numberOfClusters() throws Exception {
        return this.m_wrappedClusterer.numberOfClusters();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MakeDensityBasedClusterer: \n\nWrapped clusterer: " + this.m_wrappedClusterer.toString());
        stringBuffer.append("\nFitted estimators (with ML estimates of variance):\n");
        for (int i = 0; i < this.m_priors.length; ++i) {
            stringBuffer.append("\nCluster: " + i + " Prior probability: " + Utils.doubleToString(this.m_priors[i], 4) + "\n\n");
            for (int j = 0; j < this.m_model[0].length; ++j) {
                stringBuffer.append("Attribute: " + this.m_theInstances.attribute(j).name() + "\n");
                if (this.m_theInstances.attribute(j).isNominal()) {
                    if (this.m_model[i][j] == null) continue;
                    stringBuffer.append(this.m_model[i][j].toString());
                    continue;
                }
                stringBuffer.append("Normal Distribution. Mean = " + Utils.doubleToString(this.m_modelNormal[i][j][0], 4) + " StdDev = " + Utils.doubleToString(this.m_modelNormal[i][j][1], 4) + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public void setClusterer(Clusterer clusterer) {
        this.m_wrappedClusterer = clusterer;
    }

    public Clusterer getClusterer() {
        return this.m_wrappedClusterer;
    }

    public String minStdDevTipText() {
        return "set minimum allowable standard deviation";
    }

    public void setMinStdDev(double d) {
        this.m_minStdDev = d;
    }

    public double getMinStdDev() {
        return this.m_minStdDev;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tminimum allowable standard deviation for normal density computation \n\t(default 1e-6)", "M", 1, "-M <num>"));
        vector.addElement(new Option("\tClusterer to wrap. (required)\n", "W", 1, "-W <clusterer name>"));
        if (this.m_wrappedClusterer != null && this.m_wrappedClusterer instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to clusterer " + this.m_wrappedClusterer.getClass().getName() + ":"));
            Enumeration enumeration = ((OptionHandler)((Object)this.m_wrappedClusterer)).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setMinStdDev(new Double(string));
        } else {
            this.setMinStdDev(1.0E-6);
        }
        String string2 = Utils.getOption('W', stringArray);
        if (string2.length() == 0) {
            string2 = SimpleKMeans.class.getName();
        }
        this.setClusterer(Clusterer.forName(string2, Utils.partitionOptions(stringArray)));
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_wrappedClusterer != null && this.m_wrappedClusterer instanceof OptionHandler) {
            stringArray = ((OptionHandler)((Object)this.m_wrappedClusterer)).getOptions();
        }
        String[] stringArray2 = new String[stringArray.length + 5];
        int n = 0;
        stringArray2[n++] = "-M";
        stringArray2[n++] = "" + this.getMinStdDev();
        if (this.getClusterer() != null) {
            stringArray2[n++] = "-W";
            stringArray2[n++] = this.getClusterer().getClass().getName();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(ClusterEvaluation.evaluateClusterer(new MakeDensityBasedClusterer(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

