/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;
import weka.core.Attribute;
import weka.core.Copyable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.Remove;

public class AddCluster
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    protected Clusterer m_Clusterer = new SimpleKMeans();
    protected Range m_IgnoreAttributesRange = null;
    protected Filter m_removeAttributes = new Remove();

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_removeAttributes = null;
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        Instances instances = this.getInputFormat();
        if (!this.m_FirstBatchDone) {
            Copyable copyable;
            Object object;
            Instances instances2 = instances;
            if (this.m_IgnoreAttributesRange != null || instances.classIndex() >= 0) {
                instances2 = new Instances(instances);
                this.m_removeAttributes = new Remove();
                object = "";
                if (this.m_IgnoreAttributesRange != null) {
                    object = (String)object + this.m_IgnoreAttributesRange.getRanges();
                }
                if (instances.classIndex() >= 0) {
                    object = ((String)object).length() > 0 ? (String)object + "," + (instances.classIndex() + 1) : "" + (instances.classIndex() + 1);
                }
                ((Remove)this.m_removeAttributes).setAttributeIndices((String)object);
                ((Remove)this.m_removeAttributes).setInvertSelection(false);
                this.m_removeAttributes.setInputFormat(instances);
                for (int i = 0; i < instances.numInstances(); ++i) {
                    this.m_removeAttributes.input(instances.instance(i));
                }
                this.m_removeAttributes.batchFinished();
                instances2 = this.m_removeAttributes.getOutputFormat();
                while ((copyable = this.m_removeAttributes.output()) != null) {
                    instances2.add((Instance)copyable);
                }
            }
            this.m_Clusterer.buildClusterer(instances2);
            object = new Instances(instances, 0);
            copyable = new FastVector(this.m_Clusterer.numberOfClusters());
            for (int i = 0; i < this.m_Clusterer.numberOfClusters(); ++i) {
                copyable.addElement("cluster" + (i + 1));
            }
            ((Instances)object).insertAttributeAt(new Attribute("cluster", (FastVector)copyable), ((Instances)object).numAttributes());
            this.setOutputFormat((Instances)object);
        }
        for (int i = 0; i < instances.numInstances(); ++i) {
            this.convertInstance(instances.instance(i));
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.outputFormatPeek() != null) {
            this.convertInstance(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    protected void convertInstance(Instance instance) throws Exception {
        Instance instance2 = instance;
        double[] dArray = new double[instance.numAttributes() + 1];
        for (int i = 0; i < instance.numAttributes(); ++i) {
            dArray[i] = instance2.value(i);
        }
        Instance instance3 = null;
        if (this.m_removeAttributes != null) {
            this.m_removeAttributes.input(instance);
            instance3 = this.m_removeAttributes.output();
        } else {
            instance3 = instance;
        }
        dArray[instance.numAttributes()] = this.m_Clusterer.clusterInstance(instance3);
        Instance instance4 = instance2 instanceof SparseInstance ? new SparseInstance(instance2.weight(), dArray) : new Instance(instance2.weight(), dArray);
        this.copyStringValues(instance2, false, instance2.dataset(), this.getOutputStringIndex(), this.getOutputFormat(), this.getOutputStringIndex());
        this.push(instance4);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tFull class name of clusterer to use, followed\n\tby scheme options. (required)\n\teg: \"weka.clusterers.SimpleKMeans -N 3\"", "W", 1, "-W <clusterer specification>"));
        vector.addElement(new Option("\tThe range of attributes the clusterer should ignore.\n", "I", 1, "-I <att1,att2-att4,...>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            throw new Exception("A clusterer must be specified with the -W option.");
        }
        String[] stringArray2 = Utils.splitOptions(string);
        if (stringArray2.length == 0) {
            throw new Exception("Invalid clusterer specification string");
        }
        String string2 = stringArray2[0];
        stringArray2[0] = "";
        this.setClusterer(Clusterer.forName(string2, stringArray2));
        this.setIgnoredAttributeIndices(Utils.getOption('I', stringArray));
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[5];
        int n = 0;
        stringArray[n++] = "-W";
        stringArray[n++] = "" + this.getClustererSpec();
        if (!this.getIgnoredAttributeIndices().equals("")) {
            stringArray[n++] = "-I";
            stringArray[n++] = this.getIgnoredAttributeIndices();
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String globalInfo() {
        return "A filter that adds a new nominal attribute representing the cluster assigned to each instance by the specified clustering algorithm.";
    }

    public String clustererTipText() {
        return "The clusterer to assign clusters with.";
    }

    public void setClusterer(Clusterer clusterer) {
        this.m_Clusterer = clusterer;
    }

    public Clusterer getClusterer() {
        return this.m_Clusterer;
    }

    protected String getClustererSpec() {
        Clusterer clusterer = this.getClusterer();
        if (clusterer instanceof OptionHandler) {
            return clusterer.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)clusterer)).getOptions());
        }
        return clusterer.getClass().getName();
    }

    public String ignoredAttributeIndicesTipText() {
        return "The range of attributes to be ignored by the clusterer. eg: first-3,5,9-last";
    }

    public String getIgnoredAttributeIndices() {
        if (this.m_IgnoreAttributesRange == null) {
            return "";
        }
        return this.m_IgnoreAttributesRange.getRanges();
    }

    public void setIgnoredAttributeIndices(String string) {
        if (string == null || string.length() == 0) {
            this.m_IgnoreAttributesRange = null;
        } else {
            this.m_IgnoreAttributesRange = new Range();
            this.m_IgnoreAttributesRange.setRanges(string);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new AddCluster(), stringArray);
            } else {
                Filter.filterFile(new AddCluster(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

