/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.servicematcher;

import de.dailab.jiactng.agentcore.AbstractAgentBean;
import de.dailab.jiactng.agentcore.IAgentNode;
import de.dailab.jiactng.agentcore.directory.IOntologyStorage;
import de.dailab.jiactng.agentcore.ontology.IServiceDescription;
import de.dailab.jiactng.servicematcher.ServiceDescription;
import de.dailab.jiactng.servicematcher.owlsparser.OWLSAnalyzer;
import java.net.URI;
import java.util.HashMap;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.io.OWLOntologyInputSource;
import org.semanticweb.owl.io.OWLOntologyOutputTarget;
import org.semanticweb.owl.io.StringInputSource;
import org.semanticweb.owl.io.StringOutputTarget;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;

public class OntologyStorageAgentBean
extends AbstractAgentBean
implements IOntologyStorage {
    private OWLOntologyManager ontologyManager = null;
    private HashMap<String, IServiceDescription> serviceDescriptionCash = null;

    public void doInit() throws Exception {
        super.doInit();
        this.ontologyManager = OWLManager.createOWLOntologyManager();
        this.serviceDescriptionCash = new HashMap();
    }

    public void doCleanup() throws Exception {
        super.doCleanup();
        this.ontologyManager = null;
    }

    public void addOntology(URI ontoURI) {
    }

    public void removeOntology(URI ontoURI) {
    }

    public Object findOntology(URI ontoURI) {
        return null;
    }

    public IServiceDescription loadServiceDescriptionFromOntology(URI ontURI) {
        ServiceDescription ret = null;
        IServiceDescription tempDescription = this.serviceDescriptionCash.get(ontURI.toString());
        if (tempDescription != null) {
            return tempDescription;
        }
        ret = OWLSAnalyzer.getServiceDescription(ontURI.toString(), this.ontologyManager, this.log);
        this.serviceDescriptionCash.put(ontURI.toString(), ret);
        return ret;
    }

    public String serializeServiceDescription(IServiceDescription serviceDescription) {
        String ret = null;
        if (serviceDescription instanceof ServiceDescription) {
            ServiceDescription serviceObject = (ServiceDescription)serviceDescription;
            StringOutputTarget sot = new StringOutputTarget();
            try {
                this.ontologyManager.saveOntology(serviceObject.getServiceOntology(), (OWLOntologyOutputTarget)sot);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ret = sot.toString();
        }
        return ret;
    }

    public IServiceDescription deserializeServiceDescription(String serviceString) {
        ServiceDescription ret = null;
        StringInputSource sis = new StringInputSource(serviceString);
        try {
            OWLOntology ont = this.ontologyManager.loadOntology((OWLOntologyInputSource)sis);
            ret = OWLSAnalyzer.createServiceDescriptionFromOntology(ont);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public OWLOntologyManager getOntologyManager() {
        return this.ontologyManager;
    }

    public void setAgentNode(IAgentNode agentNode) {
    }
}

