/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.servicematcher;

import de.dailab.jiactng.agentcore.action.Action;
import de.dailab.jiactng.agentcore.ontology.IServiceDescription;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.SWRLRule;

public class ServiceDescription
extends Action
implements IServiceDescription {
    private static final long serialVersionUID = -7214612761117519725L;
    String ontology = null;
    transient Vector<OWLClass> inputClasses = new Vector();
    transient Vector<OWLClass> outputClasses = new Vector();
    Set<String> referencedOntologies = new HashSet<String>();
    transient Vector<SWRLRule> preconditionRules;
    transient Vector<SWRLRule> effectRules;
    private String ontologySource = null;
    File localServiceDescriptionFile = null;
    Vector<String[]> inParOnt = new Vector();
    Vector<String[]> outParOnt = new Vector();
    Vector<String> inputs = new Vector();
    Vector<String> outputs = new Vector();
    private URI owlsFile;
    private transient OWLOntology serviceOntology = null;
    Vector<String> inputIndividualsAsURIs = new Vector();
    Vector<String> outputIndividualsAsURIs = new Vector();
    Vector<URI> preRulesAsURIs = new Vector();
    Vector<URI> effRulesAsURIs = new Vector();
    String textualServiceDescription = null;

    public ServiceDescription(String serviceName, OWLOntology owls, Vector<SWRLRule> pre, Vector<SWRLRule> eff, Vector<OWLClass> inClasses, Vector<OWLClass> outClasses, Vector<OWLIndividual> inputIndividuals, Vector<OWLIndividual> outputIndividuals, String textualServiceDescription) {
        super(serviceName);
        String[] paramPair;
        String entityName;
        String uriHead;
        String completeURI;
        this.textualServiceDescription = textualServiceDescription;
        for (SWRLRule preRule : pre) {
            this.preRulesAsURIs.add(preRule.getURI());
        }
        for (SWRLRule effRule : eff) {
            this.effRulesAsURIs.add(effRule.getURI());
        }
        ArrayList inputTypes = new ArrayList();
        for (OWLClass owlc : this.inputClasses) {
            inputTypes.add(owlc.getClass());
        }
        ArrayList resultTypes = new ArrayList();
        for (OWLClass owlc : this.outputClasses) {
            resultTypes.add(owlc.getClass());
        }
        this.setInputTypes(inputTypes);
        this.setResultTypes(resultTypes);
        this.inputClasses = inClasses;
        this.outputClasses = outClasses;
        for (OWLIndividual inputInd : inputIndividuals) {
            this.inputIndividualsAsURIs.add(inputInd.getURI().toString());
        }
        for (OWLIndividual outputInd : outputIndividuals) {
            this.outputIndividualsAsURIs.add(outputInd.getURI().toString());
        }
        for (OWLClass inClass : inClasses) {
            completeURI = inClass.getURI().toString();
            uriHead = this.resolveURI(completeURI);
            entityName = null;
            for (OWLEntity entity : inClass.getSignature()) {
                entityName = entity.toString();
            }
            if (entityName == null) continue;
            paramPair = new String[]{entityName, uriHead};
            this.inputs.add(entityName);
            this.inParOnt.add(paramPair);
            if (uriHead == null) continue;
            this.referencedOntologies.add(uriHead);
            if (this.ontology != null) continue;
            this.ontology = uriHead;
        }
        for (OWLClass outClass : outClasses) {
            completeURI = outClass.getURI().toString();
            uriHead = this.resolveURI(completeURI);
            entityName = null;
            for (OWLEntity entity : outClass.getSignature()) {
                entityName = entity.toString();
            }
            if (entityName == null) continue;
            paramPair = new String[]{entityName, uriHead};
            this.outputs.add(entityName);
            this.outParOnt.add(paramPair);
            if (uriHead == null) continue;
            this.referencedOntologies.add(uriHead);
            if (this.ontology != null) continue;
            this.ontology = uriHead;
        }
        this.owlsFile = owls.getURI();
        this.serviceOntology = owls;
        this.preconditionRules = pre;
        this.effectRules = eff;
    }

    private String resolveURI(String completeURI) {
        String uri = completeURI.substring(0, completeURI.indexOf("#"));
        return uri;
    }

    public void setLocalFile(File file) {
        this.localServiceDescriptionFile = file;
    }

    public File getLocalFile() {
        return this.localServiceDescriptionFile;
    }

    public OWLOntology getServiceOntology() {
        return this.serviceOntology;
    }

    public Vector<String> getInputs() {
        return this.inputs;
    }

    public String getOntology() {
        return this.ontology;
    }

    public Vector<String> getOutputs() {
        return this.outputs;
    }

    public Vector<String[]> getInParamOnts() {
        return this.inParOnt;
    }

    public Vector<String[]> getOutParamOnts() {
        return this.outParOnt;
    }

    public URI getProfileURI() {
        return this.owlsFile;
    }

    public Vector<SWRLRule> getPreRules() {
        if (this.preconditionRules.size() > 0) {
            return this.preconditionRules;
        }
        Vector<SWRLRule> rules = this.getPreRulesFromURIs();
        if (rules.size() > 0) {
            return rules;
        }
        return new Vector<SWRLRule>();
    }

    public Vector<SWRLRule> getEffRules() {
        if (this.effectRules.size() > 0) {
            return this.effectRules;
        }
        Vector<SWRLRule> rules = this.getEffRulesFromURIs();
        if (rules.size() > 0) {
            return rules;
        }
        return new Vector<SWRLRule>();
    }

    public Vector<SWRLRule> getPreRulesFromURIs() {
        Vector<SWRLRule> rules = new Vector<SWRLRule>();
        if (this.ontologySource != null) {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            for (URI ruleURI : this.preRulesAsURIs) {
                URI pureURI = URI.create(ruleURI.toString().substring(0, ruleURI.toString().indexOf("#")));
                if (!manager.contains(pureURI)) {
                    try {
                        manager.loadOntologyFromPhysicalURI(pureURI);
                    }
                    catch (OWLOntologyCreationException e) {
                        e.printStackTrace();
                    }
                }
                OWLOntology ontology = manager.getOntology(pureURI);
                for (SWRLRule rule : ontology.getRules()) {
                    if (!rule.getURI().equals(ruleURI)) continue;
                    rules.add(rule);
                }
            }
        }
        return rules;
    }

    public Vector<SWRLRule> getEffRulesFromURIs() {
        Vector<SWRLRule> rules = new Vector<SWRLRule>();
        if (this.ontologySource != null) {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            for (URI ruleURI : this.effRulesAsURIs) {
                URI pureURI = URI.create(ruleURI.toString().substring(0, ruleURI.toString().indexOf("#")));
                if (!manager.contains(pureURI)) {
                    try {
                        manager.loadOntologyFromPhysicalURI(pureURI);
                    }
                    catch (OWLOntologyCreationException e) {
                        e.printStackTrace();
                    }
                }
                OWLOntology ontology = manager.getOntology(pureURI);
                for (SWRLRule rule : ontology.getRules()) {
                    if (!rule.getURI().equals(ruleURI)) continue;
                    rules.add(rule);
                }
            }
        }
        return rules;
    }

    public Vector<OWLClass> getInputClasses() {
        return this.inputClasses;
    }

    public Vector<OWLClass> getOutputClasses() {
        return this.outputClasses;
    }

    public Set<String> getReferencedOntologies() {
        return this.referencedOntologies;
    }

    public Vector<String> getInputIndividualsAsURIs() {
        return this.inputIndividualsAsURIs;
    }

    public Vector<String> getOutputIndividualsAsURIs() {
        return this.outputIndividualsAsURIs;
    }

    public void addInputIndividualAsURI(String individual) {
        this.inputIndividualsAsURIs.add(individual);
    }

    public void addOutputIndividualAsURI(String individual) {
        this.outputIndividualsAsURIs.add(individual);
    }

    public String getTextualServiceDescription() {
        return this.textualServiceDescription;
    }

    public String toString() {
        String result = "ServiceAdvert: Ontology-URI: " + this.owlsFile + "\n";
        result = String.valueOf(result) + "InputParams:\n";
        for (OWLClass inClass : this.getInputClasses()) {
            result = String.valueOf(result) + "\t" + inClass.getURI().toString() + "\n";
        }
        result = String.valueOf(result) + "\n";
        result = String.valueOf(result) + "OutputParams:\n";
        for (OWLClass outClass : this.getOutputClasses()) {
            result = String.valueOf(result) + "\t" + outClass.getURI().toString() + "\n";
        }
        result = String.valueOf(result) + "\n";
        result = String.valueOf(result) + "Precondition Rules:\n";
        for (SWRLRule preRule : this.getPreRules()) {
            result = String.valueOf(result) + "\t" + preRule.toString() + "\n";
        }
        result = String.valueOf(result) + "\n";
        result = String.valueOf(result) + "Effect Rules:\n";
        for (SWRLRule effRule : this.getEffRules()) {
            result = String.valueOf(result) + "\t" + effRule.toString() + "\n";
        }
        result = String.valueOf(result) + "\n";
        return result;
    }

    public String getOntologySource() {
        return this.ontologySource;
    }

    public void setOntologySource(String ontologySource) {
        this.ontologySource = ontologySource;
    }
}

