/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.servicematcher.evaluator;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.format.UnderlineStyle;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class ExcelAccessor {
    public static String identifier = null;
    private WritableCellFormat timesBoldUnderline;
    private WritableCellFormat times;
    private WritableWorkbook workbook;
    private WritableSheet sheet = null;

    public void initialiseExcelSheet(String serviceRequest) {
        File file = new File("C:/temp/" + serviceRequest + ".xls");
        WorkbookSettings wbSettings = new WorkbookSettings();
        wbSettings.setLocale(new Locale("de", "DE"));
        try {
            this.workbook = Workbook.createWorkbook((File)file, (WorkbookSettings)wbSettings);
            this.workbook.createSheet("Report", 0);
            this.sheet = this.workbook.getSheet(0);
            this.createLabel();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
    }

    public void createLabel() throws WriteException {
        WritableFont times10pt = new WritableFont(WritableFont.TIMES, 10);
        this.times = new WritableCellFormat(times10pt);
        this.times.setWrap(true);
        WritableFont times10ptBoldUnderline = new WritableFont(WritableFont.TIMES, 10, WritableFont.BOLD, false, UnderlineStyle.SINGLE);
        this.timesBoldUnderline = new WritableCellFormat(times10ptBoldUnderline);
        this.timesBoldUnderline.setWrap(true);
        CellView cv = new CellView();
        cv.setFormat((CellFormat)this.times);
        cv.setFormat((CellFormat)this.timesBoldUnderline);
        cv.setAutosize(true);
        this.addCaption(0, 0, "Service Identifier");
        this.addCaption(1, 0, "Matching Result");
        this.addCaption(2, 0, "Levenshtein Result");
        this.addCaption(3, 0, "Jaro Result");
        this.addCaption(4, 0, "Jaro-Winkler Result");
        this.addCaption(5, 0, "Jaccard Result");
        this.addCaption(6, 0, "Block Result");
        this.addCaption(7, 0, "Matching Coefficient Result");
        this.addCaption(8, 0, "Mean Result");
    }

    public void addCaption(int column, int row, String s) {
        Label label = new Label(column, row, s, (CellFormat)this.timesBoldUnderline);
        try {
            this.sheet.addCell((WritableCell)label);
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
    }

    public void addNumber(int column, int row, double integer) {
        Number number = new Number(column, row, integer, (CellFormat)this.times);
        try {
            this.sheet.addCell((WritableCell)number);
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
    }

    public void addLabel(int column, int row, String s) {
        Label label = new Label(column, row, s, (CellFormat)this.times);
        try {
            this.sheet.addCell((WritableCell)label);
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
    }

    public void closeConnection() {
        try {
            this.workbook.write();
            this.workbook.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws WriteException, IOException {
        ExcelAccessor test = new ExcelAccessor();
        test.initialiseExcelSheet("Test");
        System.out.println("Please check the result file under c:/temp/lars.xls ");
    }
}

