/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.servicematcher.evaluator;

import de.dailab.jiactng.agentcore.ontology.IServiceDescription;
import de.dailab.jiactng.servicematcher.ServiceDescription;
import de.dailab.jiactng.servicematcher.matcher.ServiceMatcher;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class RuleReasoningTest {
    private final String SEND_EMAIL_SERVICE_URI = "http://user.cs.tu-berlin.de/~masuch/service/SendEmailService.owls";
    public final URI INSTANCES_MATCH_URI = URI.create("http://user.cs.tu-berlin.de/~masuch/instances/SendRequestInstances1.owl");
    public final URI INSTANCES_FAIL_URI = URI.create("http://user.cs.tu-berlin.de/~masuch/instances/SendRequestInstances2.owl");
    private ServiceMatcher serviceMatcher;

    @org.junit.Test
    public void ruleReasoningMatching() {
        try {
            this.serviceMatcher = new ServiceMatcher(null);
            URL emailURL = URI.create("http://user.cs.tu-berlin.de/~masuch/service/SendEmailService.owls").toURL();
            this.serviceMatcher.input(emailURL);
            ServiceDescription description = this.serviceMatcher.getLoadedServiceDescriptions().get(0);
            boolean reasoned = this.serviceMatcher.checkPreconditionOnIndividuals(this.INSTANCES_MATCH_URI, (IServiceDescription)description);
            Assert.assertEquals((Object)reasoned, (Object)Boolean.TRUE);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @org.junit.Test
    public void ruleReasoningNonMatching() {
        try {
            this.serviceMatcher = new ServiceMatcher(null);
            URL emailURL = URI.create("http://user.cs.tu-berlin.de/~masuch/service/SendEmailService.owls").toURL();
            this.serviceMatcher.input(emailURL);
            ServiceDescription description = this.serviceMatcher.getLoadedServiceDescriptions().get(0);
            boolean reasoned = this.serviceMatcher.checkPreconditionOnIndividuals(this.INSTANCES_FAIL_URI, (IServiceDescription)description);
            Assert.assertEquals((Object)reasoned, (Object)Boolean.FALSE);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static Test suite() {
        return new JUnit4TestAdapter(RuleReasoningTest.class);
    }
}

