/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.servicematcher.evaluator;

import de.dailab.jiactng.servicematcher.evaluator.MatcherEvaluator;
import de.dailab.jiactng.servicematcher.result.ServiceMatchingResult;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Vector;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.junit.BeforeClass;

public class TaxonomyMatchingTest {
    private final String SEND_EMAIL_SERVICE_URI = "http://user.cs.tu-berlin.de/~masuch/service/SendEmailService.owls";
    private final String SEND_EMAIL_QUERY_INPUT_SUPERCLASS_MATCHING_URI = "http://user.cs.tu-berlin.de/~masuch/queries/SendEmailServiceQuerySuperClassInputMatching.owls";
    private final String SEND_EMAIL_QUERY_INPUT_SUBCLASS_MATCHING_URI = "http://user.cs.tu-berlin.de/~masuch/queries/SendEmailServiceQuerySubClassInputMatching.owls";
    private static MatcherEvaluator matcherEvaluator;
    private final int SUPERCLASS_MATCHING_VALUE = 2;
    private final int SUBCLASS_MATCHING_VALUE = 4;

    @BeforeClass
    public static void runOnceBeforeAllTests() {
        matcherEvaluator = new MatcherEvaluator();
    }

    @org.junit.Test
    public void equalServicesMatching() {
        try {
            URL emailURL = URI.create("http://user.cs.tu-berlin.de/~masuch/service/SendEmailService.owls").toURL();
            matcherEvaluator.input(emailURL);
            matcherEvaluator.query(emailURL);
            Vector<ServiceMatchingResult> results = matcherEvaluator.getServiceMatchingResults();
            ServiceMatchingResult result = results.get(0);
            Assert.assertEquals((long)result.getOverallResult(), (long)result.getOverallPossible());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @org.junit.Test
    public void superClassTaxonomyServicesMatching() {
        try {
            URL emailURL = URI.create("http://user.cs.tu-berlin.de/~masuch/service/SendEmailService.owls").toURL();
            URL queryURL = URI.create("http://user.cs.tu-berlin.de/~masuch/queries/SendEmailServiceQuerySuperClassInputMatching.owls").toURL();
            matcherEvaluator.input(emailURL);
            matcherEvaluator.query(queryURL);
            Vector<ServiceMatchingResult> results = matcherEvaluator.getServiceMatchingResults();
            ServiceMatchingResult result = results.get(0);
            Assert.assertEquals((long)result.getInputMatchingResult(), (long)2L);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @org.junit.Test
    public void subClassTaxonomyServicesMatching() {
        try {
            URL emailURL = URI.create("http://user.cs.tu-berlin.de/~masuch/service/SendEmailService.owls").toURL();
            URL queryURL = URI.create("http://user.cs.tu-berlin.de/~masuch/queries/SendEmailServiceQuerySubClassInputMatching.owls").toURL();
            matcherEvaluator.input(emailURL);
            matcherEvaluator.query(queryURL);
            Vector<ServiceMatchingResult> results = matcherEvaluator.getServiceMatchingResults();
            ServiceMatchingResult result = results.get(0);
            Assert.assertEquals((long)result.getInputMatchingResult(), (long)4L);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TaxonomyMatchingTest.class);
    }
}

