/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.servicematcher.gui;

import de.dailab.jiactng.servicematcher.ServiceDescription;
import de.dailab.jiactng.servicematcher.evaluator.MatcherEvaluator;
import de.dailab.jiactng.servicematcher.result.ServiceMatchingResult;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SeMatcherGUI {
    private Display display;
    private static final String SEND_EMAIL_SERVICE_URI = "http://user.cs.tu-berlin.de/~masuch/service/SendEmailService.owls";
    private Shell shell;
    HashMap<String, String> parOntIn = new HashMap();
    HashMap<String, String> parOntOut = new HashMap();
    public final int NUMBER_OF_SHOWN_RESULTS = 20;
    Text serviceAdverts = null;
    Text outputParams = null;
    Label result = null;
    Combo c = null;
    Combo inputLabel = null;
    Combo outputLabel = null;
    Text refOWLText = null;
    Text refOWLExpText = null;
    Text inLevelText = null;
    Text inExpText = null;
    Text outLevelText = null;
    Text outExpText = null;
    Text preRuleText = null;
    Text preExpText = null;
    ProgressBar pb1 = null;
    Label req = null;
    Button load = null;
    Text serviceRequest = null;
    MatcherEvaluator evaluator = null;
    Label processingLabel = null;
    Label loadingLabel = null;
    Label loadingInformationLabel = null;
    Label loadProgress = null;
    Label queryProgress = null;
    HashMap<String, ServiceMatchingResult> profiles = new HashMap();
    String[] preRefs = new String[]{"http://localhost/owls/BabelFishTranslator.owl"};

    SeMatcherGUI() {
        this.display = new Display();
        this.shell = new Shell(this.display);
        this.shell.setSize(550, 250);
        this.shell.setText("DAI-Labor OWL-S Service Matcher");
        this.createGUI();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    private void createGUI() {
        this.evaluator = new MatcherEvaluator();
        GridLayout grid = new GridLayout();
        this.shell.setLayout((Layout)grid);
        grid.numColumns = 3;
        GridData introductionGrid = new GridData(1);
        introductionGrid.horizontalSpan = 3;
        Label introduction = new Label((Composite)this.shell, 0);
        introduction.setLayoutData((Object)introductionGrid);
        introduction.setSize(600, 20);
        introduction.setText("In order to use the OWL-S Service Matcher, please enter a valid address of the available services:");
        GridData nullGrid = new GridData(1);
        nullGrid.widthHint = 10;
        nullGrid.heightHint = 30;
        GridData text = new GridData(1);
        text.widthHint = 300;
        text.heightHint = 20;
        text.horizontalSpan = 1;
        GridData labelText = new GridData(1);
        labelText.widthHint = 80;
        labelText.heightHint = 20;
        Label inputs = new Label((Composite)this.shell, 0);
        inputs.setText("Service Directory:");
        this.serviceAdverts = new Text((Composite)this.shell, 0);
        this.serviceAdverts.setLayoutData((Object)text);
        this.serviceAdverts.setFocus();
        this.serviceAdverts.setText(SEND_EMAIL_SERVICE_URI);
        this.load = new Button((Composite)this.shell, 0);
        this.load.setText("Load Services");
        this.load.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String serviceLocation = SeMatcherGUI.this.serviceAdverts.getText();
                try {
                    SeMatcherGUI.this.loadProgress.setText("Loading services into memory...");
                    SeMatcherGUI.this.evaluator.input(URI.create(serviceLocation).toURL());
                    int profileNumber = SeMatcherGUI.this.evaluator.getNumberOfLoadedProfiles();
                    SeMatcherGUI.this.loadProgress.setForeground(SeMatcherGUI.this.display.getSystemColor(9));
                    SeMatcherGUI.this.loadProgress.setText("Loading done! Number of loaded services: " + profileNumber);
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.loadProgress = new Label((Composite)this.shell, 0);
        this.loadProgress.setLayoutData((Object)introductionGrid);
        this.loadProgress.setText("");
        this.loadProgress.setForeground(this.display.getSystemColor(3));
        Label filler = new Label((Composite)this.shell, 0);
        filler.setLayoutData((Object)nullGrid);
        Label queryIntroduction = new Label((Composite)this.shell, 0);
        queryIntroduction.setLayoutData((Object)introductionGrid);
        queryIntroduction.setSize(600, 30);
        queryIntroduction.setText("After having loaded the service descriptions, now please enter the url of the service request: ");
        Label queryLabel = new Label((Composite)this.shell, 0);
        queryLabel.setText("Service Request:");
        this.serviceRequest = new Text((Composite)this.shell, 0);
        this.serviceRequest.setLayoutData((Object)text);
        this.serviceRequest.setFocus();
        this.serviceRequest.setText(SEND_EMAIL_SERVICE_URI);
        Button query = new Button((Composite)this.shell, 0);
        query.setText("Query");
        query.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String serviceLocation = SeMatcherGUI.this.serviceRequest.getText();
                try {
                    SeMatcherGUI.this.queryProgress.setText("Querying the service matcher for appropriate services");
                    SeMatcherGUI.this.evaluator.query(URI.create(serviceLocation).toURL());
                    SeMatcherGUI.this.queryProgress.setForeground(SeMatcherGUI.this.display.getSystemColor(9));
                    SeMatcherGUI.this.queryProgress.setText("Querying done!");
                    SeMatcherGUI.this.openResultPopup();
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.queryProgress = new Label((Composite)this.shell, 0);
        this.queryProgress.setLayoutData((Object)introductionGrid);
        this.queryProgress.setText("");
        this.queryProgress.setForeground(this.display.getSystemColor(3));
    }

    protected void openResultPopup() {
        Shell queryPopup = new Shell(this.shell, 67680);
        queryPopup.setText("Service Matching Result:");
        queryPopup.setSize(1000, 600);
        Vector<ServiceMatchingResult> serviceResults = this.evaluator.getServiceMatchingResults();
        GridLayout grid = new GridLayout();
        grid.numColumns = 1;
        queryPopup.setLayout((Layout)grid);
        this.processingLabel = new Label((Composite)queryPopup, 0);
        this.processingLabel.setText("The following services are the most suitable ones:");
        Table table = new Table((Composite)queryPopup, 0);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn[] columns = new TableColumn[8];
        columns[0] = new TableColumn(table, 0);
        columns[0].setText("Service URI");
        columns[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }
        });
        columns[0].pack();
        columns[1] = new TableColumn(table, 0);
        columns[1].setText("Service Name");
        columns[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }
        });
        columns[1].pack();
        columns[2] = new TableColumn(table, 0);
        columns[2].setText("Matching Grade");
        columns[2].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }
        });
        columns[2].pack();
        columns[3] = new TableColumn(table, 0);
        columns[3].setText("Input");
        columns[3].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }
        });
        columns[3].pack();
        columns[4] = new TableColumn(table, 0);
        columns[4].setText("Output");
        columns[4].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }
        });
        columns[4].pack();
        columns[5] = new TableColumn(table, 0);
        columns[5].setText("Name");
        columns[5].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }
        });
        columns[5].pack();
        columns[6] = new TableColumn(table, 0);
        columns[6].setText("Precondition");
        columns[6].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }
        });
        columns[6].pack();
        columns[7] = new TableColumn(table, 0);
        columns[7].setText("Effect");
        columns[7].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }
        });
        columns[7].pack();
        int i = 0;
        while (i < 20) {
            if (i >= serviceResults.size()) break;
            ServiceMatchingResult matchingResult = serviceResults.get(i);
            if (matchingResult != null) {
                TableItem item = new TableItem(table, 0);
                item.setText(0, ((ServiceDescription)matchingResult.getDescription()).getProfileURI().toString());
                item.setText(1, matchingResult.getAdvServiceName());
                item.setText(2, String.valueOf(matchingResult.getOverallResult()) + " / " + matchingResult.getOverallPossible());
                item.setText(3, String.valueOf(matchingResult.getInputMatchingResult()) + " / " + matchingResult.PARAM_TAXONOMY_MATCHING_MAX_RESULT);
                item.setText(4, String.valueOf(matchingResult.getOutputMatchingResult()) + " / " + matchingResult.PARAM_TAXONOMY_MATCHING_MAX_RESULT);
                item.setText(6, String.valueOf(matchingResult.getPreconditionRuleStructureResult()) + " / " + matchingResult.RULE_STRUCTURE_MATCHING_MAX_RESULT);
                item.setText(7, String.valueOf(matchingResult.getEffectRuleStructureResult()) + " / " + matchingResult.RULE_STRUCTURE_MATCHING_MAX_RESULT);
                switch (matchingResult.getNameMatchingResult()) {
                    case 0: {
                        item.setText(5, "failed");
                        break;
                    }
                    case 1: {
                        item.setText(5, "partial");
                        break;
                    }
                    case 2: {
                        item.setText(5, "match");
                    }
                }
            }
            ++i;
        }
        columns[0].pack();
        columns[1].pack();
        queryPopup.open();
    }

    protected void editParams(String text) {
        Shell dialog = new Shell(this.shell, 67680);
        dialog.setText("Loading OWL-S Service Descriptions...");
        dialog.setSize(450, 250);
        Button button = dialog.getDefaultButton();
        Point point = button.computeSize(30, 40);
        if (point.equals((Object)"Test")) {
            RGB[] rgbs;
            Image image = button.getBackgroundImage();
            ImageData imageData = image.getImageData();
            RGB[] rGBArray = rgbs = imageData.getRGBs();
            int n = rgbs.length;
            int n2 = 0;
            while (n2 < n) {
                RGB rgb = rGBArray[n2];
                int blue = rgb.blue;
                int red = rgb.red;
                int n3 = rgb.green;
                ++n2;
            }
        }
        TabFolder tabFolder = new TabFolder((Composite)dialog, 2048);
        int loopIndex = 0;
        while (loopIndex < 10) {
            TabItem tabItem = new TabItem(tabFolder, 0);
            tabItem.setText("Tab " + loopIndex);
            Text text2 = new Text((Composite)tabFolder, 2048);
            text2.setText("This is page " + loopIndex);
            tabItem.setControl((Control)text2);
            ++loopIndex;
        }
        tabFolder.setSize(400, 200);
        dialog.open();
        while (!dialog.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
        GridLayout grid = new GridLayout();
        dialog.setLayout((Layout)grid);
        GridData labelText = new GridData(1);
        labelText.widthHint = 80;
        labelText.heightHint = 20;
        Label inputs = new Label((Composite)this.shell, 0);
        inputs.setText("Service Directory:");
        inputs.setLayoutData((Object)labelText);
        inputs.setFocus();
        dialog.pack();
        dialog.open();
        Rectangle shellBounds = this.shell.getBounds();
        Point dialogSize = dialog.getSize();
        dialog.setLocation(shellBounds.x + (shellBounds.width - dialogSize.x) / 2, shellBounds.y + (shellBounds.height - dialogSize.y) / 2);
    }

    protected void editPreRuleRef(String text) {
        final Shell dialog = new Shell(this.shell, 67680);
        dialog.setText("Edit Precondition Reference");
        GridLayout grid = new GridLayout();
        GridData individualGrid = new GridData(1);
        individualGrid.widthHint = 300;
        individualGrid.heightHint = 20;
        dialog.setLayout((Layout)grid);
        final Combo preCombo = new Combo((Composite)dialog, 8);
        preCombo.setLayoutData((Object)individualGrid);
        int i = 0;
        while (i < this.preRefs.length) {
            preCombo.add(this.preRefs[i]);
            ++i;
        }
        preCombo.setFocus();
        Button addPreRuleButton = new Button((Composite)dialog, 0);
        addPreRuleButton.setText("Add");
        final Text individualRef = new Text((Composite)dialog, 0);
        individualRef.setText("http://");
        individualRef.setLayoutData((Object)individualGrid);
        Button addIndPreButton = new Button((Composite)dialog, 0);
        addIndPreButton.setText("Add");
        Button close = new Button((Composite)dialog, 0);
        close.setText("Close");
        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                dialog.close();
            }
        });
        addPreRuleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SeMatcherGUI.this.preRuleText.setText(preCombo.getText());
            }
        });
        addIndPreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SeMatcherGUI.this.preRuleText.setText(individualRef.getText());
                individualRef.setText("");
            }
        });
        grid.numColumns = 2;
        dialog.pack();
        dialog.open();
        Rectangle shellBounds = this.shell.getBounds();
        Point dialogSize = dialog.getSize();
        dialog.setLocation(shellBounds.x + (shellBounds.width - dialogSize.x) / 2, shellBounds.y + (shellBounds.height - dialogSize.y) / 2);
    }

    protected void addParam(String refs, Button inputButton, Button outputButton) {
        if (inputButton.getSelection()) {
            this.serviceAdverts.setText(String.valueOf(this.serviceAdverts.getText()) + refs + "\n");
        } else if (outputButton.getSelection()) {
            if (this.outputParams.getText().equals("")) {
                this.outputParams.setText(String.valueOf(refs) + "\n");
            } else {
                this.outputParams.setText(String.valueOf(this.outputParams.getText()) + refs + "\n");
            }
        }
    }

    public static void main(String[] args) {
        new SeMatcherGUI();
    }
}

