/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.servicematcher.matcher;

import de.dailab.jiactng.servicematcher.matcher.TaxonomyMatcher;
import de.dailab.jiactng.servicematcher.result.MatchingResults;
import de.dailab.jiactng.servicematcher.result.ServiceMatchingResult;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.model.OWLClass;

public class IOParamMatcher {
    Log logger = null;

    public IOParamMatcher(Log logger) {
        this.logger = logger;
    }

    public int compareParams(Vector<OWLClass> req, Vector<OWLClass> adv, Reasoner taxReasoner, String type, ServiceMatchingResult result) {
        OWLClass advClass;
        Iterator<Object> iterator;
        Vector<Integer> matchingLevels = new Vector<Integer>();
        TaxonomyMatcher taxMatcher = new TaxonomyMatcher();
        Iterator<OWLClass> iter = req.iterator();
        block0: while (iter.hasNext()) {
            OWLClass reqClass = iter.next();
            iterator = adv.iterator();
            while (iterator.hasNext()) {
                advClass = iterator.next();
                if (!taxMatcher.exactMatch(reqClass, advClass, taxReasoner)) continue;
                req.remove(reqClass);
                adv.remove(advClass);
                iter = req.iterator();
                iterator = adv.iterator();
                this.logger.debug((Object)("IO Param Match! ReqParam: " + reqClass.toString() + ", AdvParam: " + advClass.toString()));
                if (type.equals("input")) {
                    result.setInputParamResult(MatchingResults.TAXMATCHING_MATCH.getValue(), reqClass, advClass);
                } else {
                    result.setOutputParamResult(MatchingResults.TAXMATCHING_MATCH.getValue(), reqClass, advClass);
                }
                matchingLevels.add(MatchingResults.TAXMATCHING_MATCH.getValue());
                continue block0;
            }
        }
        Iterator<OWLClass> iter2 = req.iterator();
        block2: while (iter2.hasNext()) {
            OWLClass req2Class = iter2.next();
            iterator = adv.iterator();
            while (iterator.hasNext()) {
                advClass = iterator.next();
                if (!taxMatcher.subMatch(req2Class, advClass, taxReasoner)) continue;
                req.remove(req2Class);
                adv.remove(advClass);
                iter2 = req.iterator();
                iterator = adv.iterator();
                this.logger.debug((Object)("IO Param Subclass! ReqParam: " + req2Class.toString() + " is subclass of AdvParam: " + advClass.toString()));
                if (type.equals("input")) {
                    result.setInputParamResult(MatchingResults.TAXMATCHING_SUBMATCHING_INPUT.getValue(), req2Class, advClass);
                    matchingLevels.add(MatchingResults.TAXMATCHING_SUBMATCHING_INPUT.getValue());
                    continue block2;
                }
                result.setOutputParamResult(MatchingResults.TAXMATCHING_SUBMATCHING_OUTPUT.getValue(), req2Class, advClass);
                matchingLevels.add(MatchingResults.TAXMATCHING_SUBMATCHING_OUTPUT.getValue());
                continue block2;
            }
        }
        Iterator<OWLClass> iter3 = req.iterator();
        block4: while (iter3.hasNext()) {
            OWLClass req3Class = iter3.next();
            iterator = adv.iterator();
            while (iterator.hasNext()) {
                advClass = iterator.next();
                if (!taxMatcher.superMatch(req3Class, advClass, taxReasoner)) continue;
                req.remove(req3Class);
                adv.remove(advClass);
                iter3 = req.iterator();
                iterator = adv.iterator();
                this.logger.debug((Object)("IO Param Superclass! ReqParam: " + req3Class.toString() + " is superclass of AdvParam: " + advClass.toString()));
                if (type.equals("input")) {
                    result.setInputParamResult(MatchingResults.TAXMATCHING_SUPERMATCHING_INPUT.getValue(), req3Class, advClass);
                    matchingLevels.add(MatchingResults.TAXMATCHING_SUPERMATCHING_INPUT.getValue());
                    continue block4;
                }
                result.setInputParamResult(MatchingResults.TAXMATCHING_SUPERMATCHING_OUTPUT.getValue(), req3Class, advClass);
                matchingLevels.add(MatchingResults.TAXMATCHING_SUPERMATCHING_OUTPUT.getValue());
                continue block4;
            }
        }
        for (OWLClass req4Class : req) {
            if (type.equals("input")) {
                result.setInputUnmatchableParam(req4Class);
            } else {
                result.setOutputUnmatchableParam(req4Class);
            }
            matchingLevels.add(0);
        }
        for (OWLClass advClass2 : adv) {
            if (type.equals("input")) {
                result.setInputUnmatchableParam(advClass2);
                continue;
            }
            result.setOutputUnmatchableParam(advClass2);
        }
        int count = matchingLevels.size();
        if (count != 0) {
            int valueSum = 0;
            for (Integer value : matchingLevels) {
                valueSum += value.intValue();
            }
            return valueSum / count;
        }
        return 0;
    }
}

