/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.servicematcher.matcher;

import com.clarkparsia.pellet.rules.model.Rule;
import de.dailab.jiactng.servicematcher.ServiceDescription;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.impl.Log4JLogger;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.RemoveAxiom;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLAtomObject;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;

public class RuleReasoningMatcher {
    private static final String REASONING_ONTOLOGY = "http://user.cs.tu-berlin.de/~masuch/ontology/Reasoning.owl";
    private static final String REASONING_PROPERTY = "fulfills";
    private OWLOntologyManager manager = null;
    private Reasoner ruleReasoner = null;
    private Vector<String> inputIndivdualsAsURIs = new Vector();
    private Vector<SWRLRule> preconditionRules = new Vector();
    private Vector<OWLIndividual> individuals = new Vector();
    private Log4JLogger logger;

    public RuleReasoningMatcher(OWLOntologyManager manager, Reasoner reasoner, ServiceDescription serviceRequest, ServiceDescription serviceAdvert, Log4JLogger log) {
        this.manager = manager;
        this.ruleReasoner = reasoner;
        this.inputIndivdualsAsURIs = serviceRequest.getInputIndividualsAsURIs();
        this.preconditionRules = serviceAdvert.getPreRules();
        this.logger = log;
    }

    public RuleReasoningMatcher(OWLOntologyManager manager, Reasoner reasoner, URI individualsURI, ServiceDescription serviceAdvert, Log4JLogger log) {
        this.manager = manager;
        this.ruleReasoner = reasoner;
        this.logger = log;
        Set inds = new HashSet();
        try {
            OWLOntology individualsOntology = this.manager.loadOntologyFromPhysicalURI(individualsURI);
            inds = individualsOntology.getIndividualsInSignature();
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
        for (OWLIndividual individual : inds) {
            this.inputIndivdualsAsURIs.add(individual.getURI().toString());
        }
        this.preconditionRules = serviceAdvert.getPreRules();
    }

    public boolean reason() {
        boolean reasonSuccess = false;
        Set loadedOnts = this.ruleReasoner.getLoadedOntologies();
        for (String inInd : this.inputIndivdualsAsURIs) {
            OWLIndividual individual = this.manager.getOWLDataFactory().getOWLIndividual(URI.create(inInd));
            this.individuals.add(individual);
            OWLOntology indOnt = this.manager.getOntology(URI.create(inInd.substring(0, inInd.indexOf("#"))));
            if (loadedOnts.contains(indOnt)) continue;
            this.ruleReasoner.loadOntology(indOnt);
        }
        for (SWRLRule rule : this.preconditionRules) {
            URI pureURI = URI.create(rule.getURI().toString().substring(0, rule.getURI().toString().indexOf("#")));
            OWLOntology ruleOnt = this.manager.getOntology(pureURI);
            if (ruleOnt == null) {
                try {
                    ruleOnt = this.manager.loadOntologyFromPhysicalURI(pureURI);
                }
                catch (OWLOntologyCreationException e) {
                    e.printStackTrace();
                }
            }
            if (!loadedOnts.contains(ruleOnt)) {
                this.ruleReasoner.loadOntology(ruleOnt);
            }
            this.printRuleInformation(ruleOnt);
            boolean success = this.removeRuleFromOntology(rule, ruleOnt);
            this.ruleReasoner.refresh();
            this.printRuleInformation(ruleOnt);
            SWRLRule modifiedRule = this.modifyRuleForReasoning(rule);
            success = this.addRuleToOntology(modifiedRule, ruleOnt);
            this.ruleReasoner.refresh();
            this.printRuleInformation(ruleOnt);
            this.ruleReasoner.classify();
            reasonSuccess = this.checkReasoningResults();
            if (reasonSuccess) {
                this.logger.info((Object)("Rule: " + rule + " has been fulfilled!"));
            } else {
                this.logger.info((Object)("Rule: " + rule + " has NOT been fulfilled!"));
            }
            this.removeRuleFromOntology(modifiedRule, ruleOnt);
            this.addRuleToOntology(rule, ruleOnt);
            this.ruleReasoner.refresh();
        }
        return reasonSuccess;
    }

    private boolean checkReasoningResults() {
        this.logger.trace((Object)"\n");
        for (OWLIndividual ind : this.individuals) {
            this.logger.trace((Object)("Individual: " + ind.toString()));
            Map dataResult = this.ruleReasoner.getDataPropertyRelationships(ind);
            this.logger.trace((Object)("Data Properties: " + dataResult));
            Map objResult = this.ruleReasoner.getObjectPropertyRelationships(ind);
            this.logger.trace((Object)("Object Properties: " + objResult + "/n"));
            for (OWLObjectProperty objProp : objResult.keySet()) {
                if (!objProp.getURI().getFragment().equals(REASONING_PROPERTY)) continue;
                return true;
            }
        }
        return false;
    }

    private SWRLRule modifyRuleForReasoning(SWRLRule rule) {
        OWLDataFactory factory = this.manager.getOWLDataFactory();
        boolean success = this.loadReasoningOntologyIntoReasoner();
        OWLObjectProperty prop = factory.getOWLObjectProperty(URI.create("http://user.cs.tu-berlin.de/~masuch/ontology/Reasoning.owl#fulfills"));
        Set bodyAtoms = rule.getBody();
        HashSet<SWRLObjectPropertyAtom> headAtoms = new HashSet<SWRLObjectPropertyAtom>();
        for (SWRLAtom atom : bodyAtoms) {
            Collection arguments = atom.getAllArguments();
            for (SWRLAtomObject atomObject : arguments) {
                if (!(atomObject instanceof SWRLAtomIObject)) continue;
                SWRLAtomIObject atomIObject = (SWRLAtomIObject)atomObject;
                SWRLObjectPropertyAtom propAtom = factory.getSWRLObjectPropertyAtom((OWLObjectPropertyExpression)prop, atomIObject, atomIObject);
                headAtoms.add(propAtom);
            }
        }
        SWRLRule modifiedRule = factory.getSWRLRule(bodyAtoms, headAtoms);
        return modifiedRule;
    }

    private boolean loadReasoningOntologyIntoReasoner() {
        try {
            OWLOntology reasoningOnt = this.manager.loadOntologyFromPhysicalURI(URI.create(REASONING_ONTOLOGY));
            this.ruleReasoner.loadOntology(reasoningOnt);
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void printRuleInformation(OWLOntology ruleOnt) {
        this.logger.debug((Object)("\nRule size in OWLOntology instance: " + ruleOnt.getRules().size()));
        this.logger.debug((Object)("Rule size in Pellet Knowledge Base: " + this.ruleReasoner.getKB().getRules().size()));
    }

    private boolean removeRuleFromOntology(SWRLRule rule, OWLOntology ruleOnt) {
        Set kbRules = this.ruleReasoner.getKB().getRules();
        for (Rule rule2 : kbRules) {
            this.logger.trace((Object)("Rule in Pellet KnowledgeBase: " + rule2.toString()));
        }
        try {
            this.manager.applyChange((OWLOntologyChange)new RemoveAxiom(ruleOnt, (OWLAxiom)rule));
        }
        catch (OWLOntologyChangeException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean addRuleToOntology(SWRLRule rule, OWLOntology ruleOnt) {
        try {
            this.manager.applyChange((OWLOntologyChange)new AddAxiom(ruleOnt, (OWLAxiom)rule));
        }
        catch (OWLOntologyChangeException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

