/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.servicematcher.matcher;

import de.dailab.jiactng.servicematcher.RuleProperties;
import de.dailab.jiactng.servicematcher.ServiceDescription;
import de.dailab.jiactng.servicematcher.result.MatchingResults;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.impl.Log4JLogger;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomObject;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.vocab.SWRLBuiltInsVocabulary;
import uk.ac.manchester.cs.owl.OWLClassImpl;
import uk.ac.manchester.cs.owl.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.OWLObjectPropertyImpl;
import uk.ac.manchester.cs.owl.SWRLAtomConstantObjectImpl;
import uk.ac.manchester.cs.owl.SWRLAtomDVariableImpl;
import uk.ac.manchester.cs.owl.SWRLAtomIVariableImpl;
import uk.ac.manchester.cs.owl.SWRLAtomIndividualObjectImpl;

public class RuleStructureMatcher {
    private static final String PRERULE = "PRE";
    private static final String EFFRULE = "EFF";
    private OWLOntology reqOntology;
    private OWLOntology advOntology;
    private OWLOntologyManager manager = null;
    private Reasoner taxonomyReasoner = null;
    private HashMap<URI, URI> argumentRelation = new HashMap();
    private HashMap<String, URI> constantRelation = new HashMap();
    private Log4JLogger logger;

    public RuleStructureMatcher(OWLOntologyManager manager, Reasoner reasoner, Log4JLogger log) {
        this.logger = log;
        this.manager = manager;
        this.taxonomyReasoner = reasoner;
    }

    public int compareAllRules(ServiceDescription servReq, ServiceDescription servAdv, String paramType) {
        int ruleStructureMatchingValue = 0;
        Vector<Integer> matchingResults = new Vector<Integer>();
        Vector reqRules = null;
        Vector advRules = null;
        if (paramType.equals(PRERULE)) {
            reqRules = (Vector)servReq.getPreRules().clone();
            advRules = (Vector)servAdv.getPreRules().clone();
        } else if (paramType.equals(EFFRULE)) {
            reqRules = (Vector)servReq.getEffRules().clone();
            advRules = (Vector)servAdv.getEffRules().clone();
        } else {
            return 0;
        }
        for (SWRLRule advRule : advRules) {
            SWRLRule bestRule = null;
            int bestRuleMatchingValue = 0;
            for (SWRLRule reqRule : reqRules) {
                String ruleURI = servReq.getOntology();
                if (ruleURI != null) {
                    try {
                        OWLOntology preOnt = this.manager.loadOntologyFromPhysicalURI(URI.create(ruleURI));
                        this.taxonomyReasoner.loadOntology(preOnt);
                    }
                    catch (OWLOntologyCreationException e) {
                        e.printStackTrace();
                    }
                }
                if ((ruleStructureMatchingValue = this.compareRules(reqRule, advRule, servReq.getServiceOntology(), servAdv.getServiceOntology(), this.taxonomyReasoner, paramType)) <= bestRuleMatchingValue) continue;
                bestRule = reqRule;
                bestRuleMatchingValue = ruleStructureMatchingValue;
            }
            if (bestRule == null) continue;
            matchingResults.add(bestRuleMatchingValue);
            reqRules.remove(bestRule);
        }
        int worstResult = 0;
        for (Integer resultValue : matchingResults) {
            if (worstResult == 0) {
                worstResult = resultValue;
                continue;
            }
            if (resultValue >= worstResult) continue;
            worstResult = resultValue;
        }
        return worstResult;
    }

    public int compareRules(SWRLRule ruleReq, SWRLRule ruleAdv, OWLOntology reqOnt, OWLOntology advOnt, Reasoner reasoner, String paramType) {
        this.reqOntology = reqOnt;
        this.advOntology = advOnt;
        int matchingValue = -1;
        this.argumentRelation.clear();
        this.constantRelation.clear();
        if (ruleReq != null && ruleAdv != null) {
            this.logger.debug((Object)("RuleRequest Body: " + ruleReq.getBody().toString()));
            this.logger.debug((Object)("RuleAdvert Body: " + ruleAdv.getBody().toString() + "\n"));
            TreeSet<SWRLAtom> bodyReq = new TreeSet();
            TreeSet<SWRLAtom> bodyAdv = new TreeSet();
            bodyReq = ruleReq.getBody();
            bodyAdv = ruleAdv.getBody();
            RuleProperties requestRuleProps = this.classifyRuleAtoms(bodyReq, paramType);
            RuleProperties advertRuleProps = this.classifyRuleAtoms(bodyAdv, paramType);
            Vector<Integer> results = new Vector<Integer>();
            results.addAll(this.compareObjectPropertyPredicates(requestRuleProps, advertRuleProps));
            results.addAll(this.compareDataPropertyPredicates(requestRuleProps, advertRuleProps));
            results.addAll(this.compareClassPropertyPredicates(requestRuleProps, advertRuleProps));
            matchingValue = this.calculateRuleComparisonResult(results, requestRuleProps, advertRuleProps);
        }
        return matchingValue;
    }

    private int calculateRuleComparisonResult(Vector<Integer> results, RuleProperties requestRuleProps, RuleProperties advertRuleProps) {
        int numberOfRequestPredicates = requestRuleProps.getClassProperties().size() + requestRuleProps.getDataProperties().size() + requestRuleProps.getObjectProperties().size();
        int numberOfAdvertPredicates = advertRuleProps.getClassProperties().size() + advertRuleProps.getDataProperties().size() + advertRuleProps.getObjectProperties().size();
        int numberOfPredFails = 0;
        int worstResult = 10;
        for (Integer result : results) {
            if (result.equals(MatchingResults.RULESTRUCTMATCH_FAIL.getValue())) {
                ++numberOfPredFails;
                continue;
            }
            if (result >= worstResult) continue;
            worstResult = result;
        }
        if (numberOfAdvertPredicates - numberOfRequestPredicates < numberOfPredFails) {
            worstResult = 0;
        }
        if (worstResult == 10) {
            worstResult = 0;
        }
        return worstResult;
    }

    private Vector<Integer> compareClassPropertyPredicates(RuleProperties requestRuleProps, RuleProperties advertRuleProps) {
        Vector reqProps = (Vector)requestRuleProps.getClassProperties().clone();
        Vector advProps = (Vector)advertRuleProps.getClassProperties().clone();
        Vector<Integer> predicateMatchingResult = new Vector<Integer>();
        Vector<OWLClassImpl> remainingReqPreds = new Vector<OWLClassImpl>();
        block0: for (OWLClassImpl reqPredImpl : reqProps) {
            Vector<OWLClassImpl> potentialMatches = new Vector<OWLClassImpl>();
            Vector<Integer> referencedResults = new Vector<Integer>();
            int bestMatch = 0;
            for (OWLClassImpl advPredImpl : advProps) {
                if (this.taxonomyReasoner.isEquivalentClass((OWLDescription)reqPredImpl, (OWLDescription)advPredImpl)) {
                    bestMatch = MatchingResults.RULESTRUCTMATCH_MATCH.getValue();
                    potentialMatches.add(advPredImpl);
                    referencedResults.add(MatchingResults.RULESTRUCTMATCH_MATCH.getValue());
                    continue;
                }
                if (this.taxonomyReasoner.isSubClassOf((OWLDescription)reqPredImpl, (OWLDescription)advPredImpl)) {
                    if (requestRuleProps.getParamType().equals(PRERULE)) {
                        if (bestMatch >= MatchingResults.RULESTRUCTMATCH_SUBMATCHING_PRE.getValue()) continue;
                        bestMatch = MatchingResults.RULESTRUCTMATCH_SUBMATCHING_PRE.getValue();
                        potentialMatches.add(advPredImpl);
                        referencedResults.add(MatchingResults.RULESTRUCTMATCH_SUBMATCHING_PRE.getValue());
                        continue;
                    }
                    if (!requestRuleProps.getParamType().equals(EFFRULE) || bestMatch >= MatchingResults.RULESTRUCTMATCH_SUBMATCHING_EFF.getValue()) continue;
                    bestMatch = MatchingResults.RULESTRUCTMATCH_SUBMATCHING_EFF.getValue();
                    potentialMatches.add(advPredImpl);
                    referencedResults.add(MatchingResults.RULESTRUCTMATCH_SUBMATCHING_EFF.getValue());
                    continue;
                }
                if (!this.taxonomyReasoner.isSubClassOf((OWLDescription)advPredImpl, (OWLDescription)reqPredImpl)) continue;
                if (requestRuleProps.getParamType().equals(PRERULE)) {
                    if (bestMatch >= MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_PRE.getValue()) continue;
                    bestMatch = MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_PRE.getValue();
                    potentialMatches.add(advPredImpl);
                    referencedResults.add(MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_PRE.getValue());
                    continue;
                }
                if (!requestRuleProps.getParamType().equals(EFFRULE) || bestMatch >= MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_EFF.getValue()) continue;
                bestMatch = MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_EFF.getValue();
                potentialMatches.add(advPredImpl);
                referencedResults.add(MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_EFF.getValue());
            }
            if (referencedResults.size() == 0) {
                predicateMatchingResult.add(MatchingResults.RULESTRUCTMATCH_FAIL.getValue());
                remainingReqPreds.add(reqPredImpl);
            }
            int counter = 0;
            int bestResult = 0;
            Vector<OWLClassImpl> candidates = new Vector<OWLClassImpl>();
            for (Integer resultValue : referencedResults) {
                OWLClassImpl advPredicate = (OWLClassImpl)potentialMatches.get(counter);
                if (resultValue == bestResult) {
                    candidates.add(advPredicate);
                } else if (resultValue > bestResult) {
                    candidates.clear();
                    candidates.add(advPredicate);
                }
                ++counter;
            }
            for (OWLClassImpl advPredImpl : candidates) {
                boolean match = this.compareArguments(requestRuleProps.getSWRLAtomForClass(reqPredImpl).getAllArguments(), advertRuleProps.getSWRLAtomForClass(advPredImpl).getAllArguments());
                if (!match) continue;
                predicateMatchingResult.add(bestMatch);
                advProps.remove(advPredImpl);
                continue block0;
            }
        }
        return predicateMatchingResult;
    }

    private Vector<Integer> compareDataPropertyPredicates(RuleProperties requestRuleProps, RuleProperties advertRuleProps) {
        Vector reqProps = (Vector)requestRuleProps.getDataProperties().clone();
        Vector advProps = (Vector)advertRuleProps.getDataProperties().clone();
        Vector<Integer> predicateMatchingResult = new Vector<Integer>();
        Vector<OWLDataPropertyImpl> remainingReqPreds = new Vector<OWLDataPropertyImpl>();
        block0: for (OWLDataPropertyImpl reqPredImpl : reqProps) {
            Vector<OWLDataPropertyImpl> potentialMatches = new Vector<OWLDataPropertyImpl>();
            Vector<Integer> referencedResults = new Vector<Integer>();
            int bestMatch = 0;
            for (OWLDataPropertyImpl advPredImpl : advProps) {
                if (this.taxonomyReasoner.isEquivalentProperty((OWLDataProperty)reqPredImpl, (OWLDataProperty)advPredImpl)) {
                    bestMatch = MatchingResults.RULESTRUCTMATCH_MATCH.getValue();
                    potentialMatches.add(advPredImpl);
                    referencedResults.add(MatchingResults.RULESTRUCTMATCH_MATCH.getValue());
                    continue;
                }
                if (this.taxonomyReasoner.isSubPropertyOf((OWLDataProperty)reqPredImpl, (OWLDataProperty)advPredImpl)) {
                    if (requestRuleProps.getParamType().equals(PRERULE)) {
                        if (bestMatch >= MatchingResults.RULESTRUCTMATCH_SUBMATCHING_PRE.getValue()) continue;
                        bestMatch = MatchingResults.RULESTRUCTMATCH_SUBMATCHING_PRE.getValue();
                        potentialMatches.add(advPredImpl);
                        referencedResults.add(MatchingResults.RULESTRUCTMATCH_SUBMATCHING_PRE.getValue());
                        continue;
                    }
                    if (!requestRuleProps.getParamType().equals(EFFRULE) || bestMatch >= MatchingResults.RULESTRUCTMATCH_SUBMATCHING_EFF.getValue()) continue;
                    bestMatch = MatchingResults.RULESTRUCTMATCH_SUBMATCHING_EFF.getValue();
                    potentialMatches.add(advPredImpl);
                    referencedResults.add(MatchingResults.RULESTRUCTMATCH_SUBMATCHING_EFF.getValue());
                    continue;
                }
                if (!this.taxonomyReasoner.isSubPropertyOf((OWLDataProperty)advPredImpl, (OWLDataProperty)reqPredImpl)) continue;
                if (requestRuleProps.getParamType().equals(PRERULE)) {
                    if (bestMatch >= MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_PRE.getValue()) continue;
                    bestMatch = MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_PRE.getValue();
                    potentialMatches.add(advPredImpl);
                    referencedResults.add(MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_PRE.getValue());
                    continue;
                }
                if (!requestRuleProps.getParamType().equals(EFFRULE) || bestMatch >= MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_EFF.getValue()) continue;
                bestMatch = MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_EFF.getValue();
                potentialMatches.add(advPredImpl);
                referencedResults.add(MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_EFF.getValue());
            }
            if (referencedResults.size() == 0) {
                predicateMatchingResult.add(MatchingResults.RULESTRUCTMATCH_FAIL.getValue());
                remainingReqPreds.add(reqPredImpl);
            }
            int counter = 0;
            int bestResult = 0;
            Vector<OWLDataPropertyImpl> candidates = new Vector<OWLDataPropertyImpl>();
            for (Integer resultValue : referencedResults) {
                OWLDataPropertyImpl advPredicate = (OWLDataPropertyImpl)potentialMatches.get(counter);
                if (resultValue == bestResult) {
                    candidates.add(advPredicate);
                } else if (resultValue > bestResult) {
                    candidates.clear();
                    candidates.add(advPredicate);
                }
                ++counter;
            }
            for (OWLDataPropertyImpl advPredImpl : candidates) {
                boolean match = this.compareArguments(requestRuleProps.getSWRLAtomForData(reqPredImpl).getAllArguments(), advertRuleProps.getSWRLAtomForData(advPredImpl).getAllArguments());
                if (!match) continue;
                predicateMatchingResult.add(bestMatch);
                advProps.remove(advPredImpl);
                continue block0;
            }
        }
        return predicateMatchingResult;
    }

    private Vector<Integer> compareObjectPropertyPredicates(RuleProperties requestRuleProps, RuleProperties advertRuleProps) {
        Vector reqProps = (Vector)requestRuleProps.getObjectProperties().clone();
        Vector advProps = (Vector)advertRuleProps.getObjectProperties().clone();
        Vector<Integer> predicateMatchingResult = new Vector<Integer>();
        Vector<OWLObjectPropertyImpl> remainingReqPreds = new Vector<OWLObjectPropertyImpl>();
        block0: for (OWLObjectPropertyImpl reqPredImpl : reqProps) {
            Vector<OWLObjectPropertyImpl> potentialMatches = new Vector<OWLObjectPropertyImpl>();
            Vector<Integer> referencedResults = new Vector<Integer>();
            int bestMatch = 0;
            for (OWLObjectPropertyImpl advPredImpl : advProps) {
                if (this.taxonomyReasoner.isEquivalentProperty((OWLObjectProperty)reqPredImpl, (OWLObjectProperty)advPredImpl)) {
                    bestMatch = MatchingResults.RULESTRUCTMATCH_MATCH.getValue();
                    potentialMatches.add(advPredImpl);
                    referencedResults.add(MatchingResults.RULESTRUCTMATCH_MATCH.getValue());
                    continue;
                }
                if (this.taxonomyReasoner.isSubPropertyOf((OWLObjectProperty)reqPredImpl, (OWLObjectProperty)advPredImpl)) {
                    if (requestRuleProps.getParamType().equals(PRERULE)) {
                        if (bestMatch >= MatchingResults.RULESTRUCTMATCH_SUBMATCHING_PRE.getValue()) continue;
                        bestMatch = MatchingResults.RULESTRUCTMATCH_SUBMATCHING_PRE.getValue();
                        potentialMatches.add(advPredImpl);
                        referencedResults.add(MatchingResults.RULESTRUCTMATCH_SUBMATCHING_PRE.getValue());
                        continue;
                    }
                    if (!requestRuleProps.getParamType().equals(EFFRULE) || bestMatch >= MatchingResults.RULESTRUCTMATCH_SUBMATCHING_EFF.getValue()) continue;
                    bestMatch = MatchingResults.RULESTRUCTMATCH_SUBMATCHING_EFF.getValue();
                    potentialMatches.add(advPredImpl);
                    referencedResults.add(MatchingResults.RULESTRUCTMATCH_SUBMATCHING_EFF.getValue());
                    continue;
                }
                if (!this.taxonomyReasoner.isSubPropertyOf((OWLObjectProperty)advPredImpl, (OWLObjectProperty)reqPredImpl)) continue;
                if (requestRuleProps.getParamType().equals(PRERULE)) {
                    if (bestMatch >= MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_PRE.getValue()) continue;
                    bestMatch = MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_PRE.getValue();
                    potentialMatches.add(advPredImpl);
                    referencedResults.add(MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_PRE.getValue());
                    continue;
                }
                if (!requestRuleProps.getParamType().equals(EFFRULE) || bestMatch >= MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_EFF.getValue()) continue;
                bestMatch = MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_EFF.getValue();
                potentialMatches.add(advPredImpl);
                referencedResults.add(MatchingResults.RULESTRUCTMATCH_SUPERMATCHING_EFF.getValue());
            }
            if (referencedResults.size() == 0) {
                predicateMatchingResult.add(MatchingResults.RULESTRUCTMATCH_FAIL.getValue());
                remainingReqPreds.add(reqPredImpl);
            }
            int counter = 0;
            int bestResult = 0;
            Vector<OWLObjectPropertyImpl> candidates = new Vector<OWLObjectPropertyImpl>();
            for (Integer resultValue : referencedResults) {
                OWLObjectPropertyImpl advPredicate = (OWLObjectPropertyImpl)potentialMatches.get(counter);
                if (resultValue == bestResult) {
                    candidates.add(advPredicate);
                } else if (resultValue > bestResult) {
                    candidates.clear();
                    candidates.add(advPredicate);
                }
                ++counter;
            }
            for (OWLObjectPropertyImpl advPredImpl : candidates) {
                boolean match = this.compareArguments(requestRuleProps.getSWRLAtomForObject(reqPredImpl).getAllArguments(), advertRuleProps.getSWRLAtomForObject(advPredImpl).getAllArguments());
                if (!match) continue;
                predicateMatchingResult.add(bestMatch);
                advProps.remove(advPredImpl);
                continue block0;
            }
        }
        return predicateMatchingResult;
    }

    private RuleProperties classifyRuleAtoms(Set<SWRLAtom> body, String paramType) {
        RuleProperties ruleProps = new RuleProperties();
        ruleProps.setParamType(paramType);
        for (SWRLAtom atom : body) {
            Object predicate = atom.getPredicate();
            if (predicate instanceof OWLObjectPropertyImpl) {
                ruleProps.addObjectProperty((OWLObjectPropertyImpl)predicate, atom);
                continue;
            }
            if (predicate instanceof OWLDataPropertyImpl) {
                ruleProps.addDataProperty((OWLDataPropertyImpl)predicate, atom);
                continue;
            }
            if (predicate instanceof OWLClassImpl) {
                ruleProps.addClassProperty((OWLClassImpl)predicate, atom);
                continue;
            }
            if (predicate instanceof SWRLBuiltInsVocabulary) {
                SWRLBuiltInsVocabulary builtInVocab = (SWRLBuiltInsVocabulary)predicate;
                ruleProps.addBuiltInProperty(builtInVocab, atom);
                continue;
            }
            this.logger.error((Object)("Unknown predicate type in rule atom: " + atom));
        }
        return ruleProps;
    }

    private boolean compareArguments(Collection<SWRLAtomObject> reqArgs, Collection<SWRLAtomObject> advArgs) {
        boolean matching = false;
        if (reqArgs.size() != advArgs.size()) {
            return false;
        }
        Iterator<SWRLAtomObject> iter = reqArgs.iterator();
        while (iter.hasNext()) {
            Iterator<SWRLAtomObject> iterator = advArgs.iterator();
            if (!iterator.hasNext()) continue;
            SWRLAtomObject advArg = iterator.next();
            SWRLAtomObject reqArg = iter.next();
            matching = this.compareArgument(reqArg, advArg);
            if (!matching) {
                return matching;
            }
            ArrayList<SWRLAtomObject> temp = new ArrayList<SWRLAtomObject>();
            boolean first = true;
            for (SWRLAtomObject element : advArgs) {
                if (first) {
                    first = false;
                    continue;
                }
                temp.add(element);
            }
            advArgs = temp;
        }
        return matching;
    }

    private boolean compareArgument(SWRLAtomObject reqArg, SWRLAtomObject advArg) {
        boolean matching = false;
        if (reqArg instanceof SWRLAtomDVariableImpl && advArg instanceof SWRLAtomDVariableImpl) {
            matching = this.compareSWRLAtomDVariableImpl((SWRLAtomDVariableImpl)reqArg, (SWRLAtomDVariableImpl)advArg);
        }
        if (reqArg instanceof SWRLAtomIVariableImpl && advArg instanceof SWRLAtomIVariableImpl) {
            matching = this.compareSWRLAtomIVariableImpl((SWRLAtomIVariableImpl)reqArg, (SWRLAtomIVariableImpl)advArg);
        }
        if (reqArg instanceof SWRLAtomConstantObjectImpl) {
            OWLConstant reqConst;
            if (advArg instanceof SWRLAtomConstantObjectImpl) {
                reqConst = ((SWRLAtomConstantObjectImpl)reqArg).getConstant();
                OWLConstant advConst = ((SWRLAtomConstantObjectImpl)advArg).getConstant();
                matching = this.compareOWLConstant(reqConst, advConst);
            } else if (advArg instanceof SWRLAtomDVariableImpl) {
                reqConst = ((SWRLAtomConstantObjectImpl)reqArg).getConstant();
                SWRLAtomDVariableImpl advDVariable = (SWRLAtomDVariableImpl)advArg;
                matching = this.compareConstantVariable(reqConst, advDVariable);
            }
        }
        if (reqArg instanceof SWRLAtomIndividualObjectImpl && advArg instanceof SWRLAtomIndividualObjectImpl) {
            OWLIndividual reqInd = ((SWRLAtomIndividualObjectImpl)reqArg).getIndividual();
            OWLIndividual advInd = ((SWRLAtomIndividualObjectImpl)advArg).getIndividual();
            matching = this.compareOWLIndividual(reqInd, advInd);
        }
        return matching;
    }

    private boolean compareConstantVariable(OWLConstant reqConst, SWRLAtomDVariableImpl advDVariable) {
        if (this.constantRelation.containsKey(reqConst.getLiteral())) {
            URI variableURI = this.constantRelation.get(reqConst.getLiteral());
            return variableURI.equals(advDVariable.getURI());
        }
        this.constantRelation.put(reqConst.getLiteral(), advDVariable.getURI());
        return true;
    }

    private boolean compareOWLIndividual(OWLIndividual req, OWLIndividual adv) {
        boolean matching = false;
        boolean parameterCheck = false;
        this.logger.trace((Object)("Req Individual: " + req.toString()));
        this.logger.trace((Object)("Adv Individual: " + adv.toString()));
        Set reqTypes = req.getTypes(this.reqOntology);
        Set advTypes = adv.getTypes(this.advOntology);
        for (OWLDescription description : reqTypes) {
            if (!description.toString().equals("Input") && !description.toString().equals("Output") && !description.toString().equals("Local")) continue;
            parameterCheck = true;
        }
        if (!reqTypes.toString().equals(advTypes.toString())) {
            return false;
        }
        if (parameterCheck) {
            Map advDataProps;
            Map reqDataProps = req.getDataPropertyValues(this.reqOntology);
            if (reqDataProps.equals(advDataProps = adv.getDataPropertyValues(this.advOntology))) {
                matching = true;
            }
        } else {
            matching = true;
        }
        return matching;
    }

    private boolean compareOWLConstant(OWLConstant req, OWLConstant adv) {
        boolean matching = false;
        if (req.isTyped() && adv.isTyped()) {
            OWLTypedConstant reqTypedConstant = req.asOWLTypedConstant();
            OWLDataType reqDataType = reqTypedConstant.getDataType();
            OWLTypedConstant advTypedConstant = adv.asOWLTypedConstant();
            OWLDataType advDataType = advTypedConstant.getDataType();
            if (reqDataType.toString().equals(advDataType.toString()) && reqTypedConstant.getLiteral().equals(advTypedConstant.getLiteral())) {
                matching = true;
            }
        }
        return matching;
    }

    private boolean compareSWRLAtomIVariableImpl(SWRLAtomIVariableImpl req, SWRLAtomIVariableImpl adv) {
        boolean matching = false;
        this.logger.trace((Object)("URI of ReqVariable: " + req.getURI().toString()));
        this.logger.trace((Object)("URI of AdvVariable: " + adv.getURI().toString()));
        if (req.getURI().equals(adv.getURI())) {
            matching = true;
        } else if (this.argumentRelation.containsKey(req.getURI())) {
            matching = this.argumentRelation.get(req.getURI()).equals(adv.getURI());
        } else {
            this.argumentRelation.put(req.getURI(), adv.getURI());
            matching = true;
        }
        return matching;
    }

    private boolean compareSWRLAtomDVariableImpl(SWRLAtomDVariableImpl req, SWRLAtomDVariableImpl adv) {
        boolean matching = false;
        this.logger.trace((Object)("URI of ReqVariable: " + req.getURI().toString()));
        this.logger.trace((Object)("URI of AdvVariable: " + adv.getURI().toString()));
        if (req.getURI().equals(adv.getURI())) {
            matching = true;
        } else if (this.argumentRelation.containsKey(req.getURI())) {
            matching = this.argumentRelation.get(req.getURI()).equals(adv.getURI());
        } else {
            this.argumentRelation.put(req.getURI(), adv.getURI());
            matching = true;
        }
        return matching;
    }
}

