/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.servicematcher.matcher;

import de.dailab.jiactng.agentcore.ontology.IServiceDescription;
import de.dailab.jiactng.servicematcher.ServiceDescription;
import de.dailab.jiactng.servicematcher.evaluator.ExcelAccessor;
import de.dailab.jiactng.servicematcher.matcher.IOParamMatcher;
import de.dailab.jiactng.servicematcher.matcher.RuleReasoningMatcher;
import de.dailab.jiactng.servicematcher.matcher.RuleStructureMatcher;
import de.dailab.jiactng.servicematcher.matcher.ServiceNameMatcher;
import de.dailab.jiactng.servicematcher.matcher.TextSimilarityMatcher;
import de.dailab.jiactng.servicematcher.owlsparser.OWLSAnalyzer;
import de.dailab.jiactng.servicematcher.result.ServiceMatchingResult;
import de.dfki.sme2.IMatchmakerPlugin;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Level;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;

public class ServiceMatcher
implements IMatchmakerPlugin {
    public static final String LOGGING_LEVEL = "debug";
    public static final String INPUT_TAG = "input";
    public static final String OUTPUT_TAG = "output";
    public static final String LOCAL_URI = "http://127.0.0.1/services/1.1/";
    private static final String PRERULE = "PRE";
    private static final String EFFRULE = "EFF";
    private Log4JLogger logger = (Log4JLogger)LogFactory.getLog(ServiceMatcher.class);
    private OWLOntologyManager manager = null;
    private Reasoner taxonomyReasoner = null;
    private ArrayList<ServiceDescription> serviceAdverts = new ArrayList();
    private ArrayList<String> loadedProfiles = new ArrayList();
    private HashMap<Integer, ArrayList<ServiceMatchingResult>> rankedMatchingResults = new HashMap();
    public int counter = 0;
    public long totalParamCompareTime = 0L;

    public ServiceMatcher(OWLOntologyManager ontologyManager) {
        this.logger.getLogger().setLevel(Level.toLevel((String)LOGGING_LEVEL));
        if (ontologyManager != null) {
            this.manager = ontologyManager;
        } else {
            this.logger.warn((Object)"OntologyManager is null, creating new instance... This may lead to wrong matching results!");
            this.manager = OWLManager.createOWLOntologyManager();
        }
    }

    @Override
    public void input(URL serviceURL) {
        this.logger.debug((Object)("The following service is being read in to the service matcher: " + serviceURL.toString()));
        this.addServiceDescriptions(this.readServiceDescriptionsFromFiles(serviceURL));
        this.logger.debug((Object)("Number of loaded service adverts: " + this.serviceAdverts.size()));
    }

    @Override
    public Hashtable<URL, Vector<URL>> query(URL queryURL) {
        long query_begin = System.currentTimeMillis();
        ArrayList<Object> servReqList = new ArrayList();
        Hashtable<URL, Vector<URL>> overallResult = new Hashtable<URL, Vector<URL>>();
        servReqList = this.readServiceDescriptionsFromFiles(queryURL);
        for (IServiceDescription iServiceDescription : servReqList) {
            ArrayList<IServiceDescription> results = this.findAllMatches(iServiceDescription);
            Vector<URL> resultURLs = new Vector<URL>();
            for (IServiceDescription rsd : results) {
                try {
                    resultURLs.add(((ServiceDescription)rsd).getProfileURI().toURL());
                }
                catch (MalformedURLException e) {
                    this.logger.error((Object)("Illegal URL found in ServiceDescription '" + ((ServiceDescription)rsd).getProfileURI() + "'"), (Throwable)e);
                }
            }
            overallResult.put(queryURL, resultURLs);
        }
        long l = System.currentTimeMillis();
        this.logger.debug((Object)("QueryResponseTime: " + (l - query_begin)));
        ++this.counter;
        this.totalParamCompareTime += l - query_begin;
        this.logger.debug((Object)("Average Response Time: " + this.totalParamCompareTime / (long)this.counter));
        return overallResult;
    }

    public IServiceDescription findBestMatch(IServiceDescription template) {
        this.rankedMatchingResults = new HashMap();
        IServiceDescription bestMatch = null;
        ServiceDescription servReq = (ServiceDescription)template;
        this.taxonomyReasoner = new Reasoner(this.manager);
        ExcelAccessor excelAccess = null;
        int counter = 1;
        for (ServiceDescription servAdv : this.serviceAdverts) {
            ServiceMatchingResult matchingResult = this.matchRequestAndAdvert(servReq, servAdv, excelAccess, counter);
            this.addToServiceMatchingResults(matchingResult);
        }
        ArrayList<ServiceMatchingResult> sortedResult = this.getServiceMatchingResults();
        if (sortedResult != null && sortedResult.size() > 0) {
            bestMatch = sortedResult.get(0).getDescription();
            this.logger.debug((Object)("Best matched service: " + bestMatch.toString()));
        }
        return bestMatch;
    }

    public ArrayList<IServiceDescription> findAllMatches(IServiceDescription template) {
        this.rankedMatchingResults = new HashMap();
        ArrayList<IServiceDescription> matchedServices = new ArrayList<IServiceDescription>();
        ServiceDescription servReq = (ServiceDescription)template;
        this.taxonomyReasoner = new Reasoner(this.manager);
        ExcelAccessor excelAccess = null;
        int counter = 1;
        for (ServiceDescription servAdv : this.serviceAdverts) {
            ServiceMatchingResult matchingResult = this.matchRequestAndAdvert(servReq, servAdv, excelAccess, counter);
            this.addToServiceMatchingResults(matchingResult);
        }
        ArrayList<ServiceMatchingResult> sortedResult = this.getServiceMatchingResults();
        if (sortedResult != null) {
            for (ServiceMatchingResult smr : sortedResult) {
                matchedServices.add(smr.getDescription());
            }
        }
        return matchedServices;
    }

    public ArrayList<ServiceMatchingResult> getServiceMatchingResults() {
        ArrayList<ServiceMatchingResult> ret = new ArrayList<ServiceMatchingResult>();
        int i = 25;
        while (i > 0) {
            ArrayList<ServiceMatchingResult> rankedResultsForValue = this.rankedMatchingResults.get(i);
            if (rankedResultsForValue != null) {
                ret.addAll(rankedResultsForValue);
            }
            --i;
        }
        return ret;
    }

    private ServiceMatchingResult matchRequestAndAdvert(ServiceDescription servReq, ServiceDescription servAdv, ExcelAccessor excelAccess, int row) {
        ServiceMatchingResult matchingResult = new ServiceMatchingResult(servAdv);
        boolean reason = this.shouldBeReasoned(servReq, servAdv);
        if (!reason) {
            return matchingResult;
        }
        boolean success = this.loadOntologiesIntoReasoner(servReq, servAdv);
        ServiceNameMatcher snMatcher = new ServiceNameMatcher(this.logger);
        int serviceNameResult = snMatcher.compareServiceNames(servReq.getName(), servAdv.getName());
        matchingResult.setNameMatchingResult(serviceNameResult, servReq.getName(), servAdv.getName());
        TextSimilarityMatcher tsm = new TextSimilarityMatcher();
        int textResult = tsm.compareTextualServiceDescriptions(servReq.getTextualServiceDescription(), servAdv.getTextualServiceDescription(), excelAccess, row);
        matchingResult.setTextMatchingResult(textResult);
        Vector inReq = (Vector)servReq.getInputClasses().clone();
        Vector outReq = (Vector)servReq.getOutputClasses().clone();
        Vector inAdv = (Vector)servAdv.getInputClasses().clone();
        Vector outAdv = (Vector)servAdv.getOutputClasses().clone();
        IOParamMatcher paramComparison = new IOParamMatcher((Log)this.logger);
        int matchingLevelIn = paramComparison.compareParams(inReq, inAdv, this.taxonomyReasoner, INPUT_TAG, matchingResult);
        int matchingLevelOut = paramComparison.compareParams(outReq, outAdv, this.taxonomyReasoner, OUTPUT_TAG, matchingResult);
        matchingResult.setInputOverallMatchingResult(matchingLevelIn);
        matchingResult.setOutputOverallMatchingResult(matchingLevelOut);
        RuleStructureMatcher ruleStructureMatcher = new RuleStructureMatcher(this.manager, this.taxonomyReasoner, this.logger);
        int preRuleStructureMatchingValue = ruleStructureMatcher.compareAllRules(servReq, servAdv, PRERULE);
        matchingResult.setPreConditionRuleStructureResult(preRuleStructureMatchingValue);
        ruleStructureMatcher = new RuleStructureMatcher(this.manager, this.taxonomyReasoner, this.logger);
        int effRuleStructureMatchingValue = ruleStructureMatcher.compareAllRules(servReq, servAdv, EFFRULE);
        matchingResult.setEffectRuleStructureResult(effRuleStructureMatchingValue);
        if (servReq.getInputIndividualsAsURIs().size() > 0 && servAdv.getPreRules().size() > 0) {
            RuleReasoningMatcher ruleReasoningMatcher = new RuleReasoningMatcher(this.manager, this.taxonomyReasoner, servReq, servAdv, this.logger);
            boolean bl = ruleReasoningMatcher.reason();
        }
        return matchingResult;
    }

    public boolean checkPreconditionOnIndividuals(IServiceDescription servReqI, IServiceDescription servAdvI) {
        if (this.taxonomyReasoner == null) {
            this.taxonomyReasoner = new Reasoner(this.manager);
        }
        ServiceDescription servReq = (ServiceDescription)servReqI;
        ServiceDescription servAdv = (ServiceDescription)servAdvI;
        if (servReq.getInputIndividualsAsURIs().size() > 0 && servAdv.getPreRules().size() > 0) {
            RuleReasoningMatcher ruleReasoningMatcher = new RuleReasoningMatcher(this.manager, this.taxonomyReasoner, servReq, servAdv, this.logger);
            return ruleReasoningMatcher.reason();
        }
        return false;
    }

    public boolean checkPreconditionOnIndividuals(URI individualsURI, IServiceDescription servAdvI) {
        if (this.taxonomyReasoner == null) {
            this.taxonomyReasoner = new Reasoner(this.manager);
        }
        ServiceDescription servAdv = (ServiceDescription)servAdvI;
        if (individualsURI != null && servAdv.getPreRules().size() > 0) {
            RuleReasoningMatcher ruleReasoningMatcher = new RuleReasoningMatcher(this.manager, this.taxonomyReasoner, individualsURI, servAdv, this.logger);
            return ruleReasoningMatcher.reason();
        }
        return false;
    }

    private boolean loadOntologiesIntoReasoner(ServiceDescription servReq, ServiceDescription servAdv) {
        TreeSet<String> allReferencedOnts = new TreeSet<String>();
        allReferencedOnts.addAll(servReq.getReferencedOntologies());
        allReferencedOnts.addAll(servAdv.getReferencedOntologies());
        if (this.taxonomyReasoner == null) {
            this.taxonomyReasoner = new Reasoner(this.manager);
        }
        TreeSet<OWLOntology> ontos = new TreeSet<OWLOntology>();
        for (String element : allReferencedOnts) {
            OWLOntology ont = this.manager.getOntology(URI.create(element));
            if (ont == null) {
                try {
                    ont = this.manager.loadOntologyFromPhysicalURI(URI.create(element));
                }
                catch (OWLOntologyCreationException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            ontos.add(ont);
        }
        this.taxonomyReasoner.loadOntologies(ontos);
        return true;
    }

    private boolean shouldBeReasoned(ServiceDescription servReq, ServiceDescription servAdv) {
        if (servReq.getInputs().size() < servAdv.getInputs().size()) {
            this.logger.info((Object)"Number of input params! #Request.Inputs < #Advert.Inputs ");
            return false;
        }
        if (servReq.getOutputs().size() > servAdv.getOutputs().size()) {
            this.logger.info((Object)"Number of output params! #Request.Outputs > #Advert.Outputs");
            return false;
        }
        return true;
    }

    private void addToServiceMatchingResults(ServiceMatchingResult matcherResult) {
        int result = matcherResult.getOverallResult();
        ArrayList<ServiceMatchingResult> resultValues = this.rankedMatchingResults.get(result);
        if (resultValues == null) {
            resultValues = new ArrayList();
        }
        resultValues.add(matcherResult);
        this.rankedMatchingResults.put(result, resultValues);
    }

    private ArrayList<IServiceDescription> readServiceRequestFromURI(URL queryURL) {
        return null;
    }

    private ArrayList<IServiceDescription> readServiceDescriptionsFromFiles(URL serviceURL) {
        ArrayList<IServiceDescription> ret = new ArrayList<IServiceDescription>();
        String url = serviceURL.toString();
        String profileURI = "";
        ArrayList<String> unsuitableProfiles = new ArrayList<String>();
        if (url.startsWith("file")) {
            File profileDir = new File(serviceURL.getPath().toString());
            File[] files = null;
            files = profileDir.isFile() ? new File[]{profileDir} : profileDir.listFiles();
            int i = 0;
            while (i < files.length) {
                File profile = files[i];
                this.loadedProfiles.add(profile.toString());
                String address = profile.toString();
                int start = address.indexOf("1.1\\") + 4;
                if (start != 3) {
                    String tail = address.substring(start);
                    profileURI = LOCAL_URI + tail;
                } else {
                    String temp = address.substring(address.lastIndexOf("\\") + 1);
                    profileURI = LOCAL_URI + temp;
                }
                ServiceDescription servAdv = OWLSAnalyzer.getServiceDescription(profileURI, this.manager, (Log)this.logger);
                if (servAdv == null) {
                    unsuitableProfiles.add(profileURI);
                } else {
                    servAdv.setLocalFile(profile);
                    ret.add(servAdv);
                }
                ++i;
            }
        } else {
            URI physicalURI = URI.create(url);
            ServiceDescription servAdv = OWLSAnalyzer.getServiceDescription(physicalURI.toString(), this.manager, (Log)this.logger);
            if (servAdv == null) {
                unsuitableProfiles.add(profileURI);
            } else {
                ret.add(servAdv);
            }
        }
        for (String string : unsuitableProfiles) {
            this.logger.error((Object)("Profile not found by manager: " + string));
        }
        return ret;
    }

    public void addServiceDescriptions(List<IServiceDescription> descriptionList) {
        for (IServiceDescription desc : descriptionList) {
            if (!(desc instanceof ServiceDescription)) continue;
            this.serviceAdverts.add((ServiceDescription)desc);
        }
    }

    public void setServiceDescriptions(List<IServiceDescription> descriptionList) {
        this.serviceAdverts.clear();
        for (IServiceDescription desc : descriptionList) {
            if (!(desc instanceof ServiceDescription)) continue;
            this.serviceAdverts.add((ServiceDescription)desc);
        }
    }

    public ArrayList<ServiceDescription> getLoadedServiceDescriptions() {
        return this.serviceAdverts;
    }

    public int getNumberOfLoadedServiceDescriptions() {
        return this.serviceAdverts.size();
    }

    public boolean resetLoadedServiceDescriptions() {
        this.serviceAdverts.clear();
        return true;
    }
}

