/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.servicematcher.matcher;

import de.dailab.jiactng.servicematcher.evaluator.ExcelAccessor;
import de.dailab.jiactng.servicematcher.result.MatchingResults;
import uk.ac.shef.wit.simmetrics.similaritymetrics.BlockDistance;
import uk.ac.shef.wit.simmetrics.similaritymetrics.JaccardSimilarity;
import uk.ac.shef.wit.simmetrics.similaritymetrics.Jaro;
import uk.ac.shef.wit.simmetrics.similaritymetrics.JaroWinkler;
import uk.ac.shef.wit.simmetrics.similaritymetrics.Levenshtein;
import uk.ac.shef.wit.simmetrics.similaritymetrics.MatchingCoefficient;

public class TextSimilarityMatcher {
    public int compareTextualServiceDescriptions(String serviceRequestDescription, String serviceAdvertDescription, ExcelAccessor excelAccess, int row) {
        Levenshtein levenshteinTest = new Levenshtein();
        float numericResultLevenshtein = levenshteinTest.getSimilarity(serviceRequestDescription, serviceAdvertDescription);
        Jaro jaroTest = new Jaro();
        float numericResultJaro = jaroTest.getSimilarity(serviceRequestDescription, serviceAdvertDescription);
        JaroWinkler jaroWinklerTest = new JaroWinkler();
        float numericResultJaroWinkler = jaroWinklerTest.getSimilarity(serviceRequestDescription, serviceAdvertDescription);
        JaccardSimilarity jaccardTest = new JaccardSimilarity();
        float numericResultJaccard = jaccardTest.getSimilarity(serviceRequestDescription, serviceAdvertDescription);
        BlockDistance blockTest = new BlockDistance();
        float numericResultBlock = blockTest.getSimilarity(serviceRequestDescription, serviceAdvertDescription);
        MatchingCoefficient mcTest = new MatchingCoefficient();
        float numericResultMC = mcTest.getSimilarity(serviceRequestDescription, serviceAdvertDescription);
        float meanResult = numericResultMC / 1.0f;
        if ((double)meanResult < 0.5) {
            return MatchingResults.TEXTSIM_LESS_50.getValue();
        }
        if ((double)meanResult >= 0.5) {
            return MatchingResults.TEXTSIM_MORE_50.getValue();
        }
        if ((double)meanResult >= 0.6) {
            return MatchingResults.TEXTSIM_MORE_60.getValue();
        }
        if ((double)meanResult >= 0.7) {
            return MatchingResults.TEXTSIM_MORE_70.getValue();
        }
        if ((double)meanResult >= 0.8) {
            return MatchingResults.TEXTSIM_MORE_80.getValue();
        }
        if ((double)meanResult >= 0.9) {
            return MatchingResults.TEXTSIM_MORE_90.getValue();
        }
        return MatchingResults.TEXTSIM_PERFECT.getValue();
    }

    public static void main(String[] args) {
        TextSimilarityMatcher tsm = new TextSimilarityMatcher();
        tsm.compareTextualServiceDescriptions("This service gives you information for the scholarships offered by the given government, it is available to get the degree from any government (university or organization).", "This service provides infos about fundings offered by a given government for a given award.", null, 0);
    }
}

