/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.servicematcher.owlsparser;

import de.dailab.jiactng.servicematcher.ServiceDescription;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.SWRLRule;

public class OWLSAnalyzer {
    public static final String INPUT_PROPERTY = "hasInput";
    public static final String OUTPUT_PROPERTY = "hasOutput";
    public static final String PRE_PROPERTY = "hasPrecondition";
    public static final String EFF_PROPERTY = "hasEffect";
    public static final String PROFILE_IDENTIFIER = "Profile";
    private static OWLOntology ontology;
    private static OWLOntologyManager manager;
    private static Log logger;
    private static Vector<String> inputs;
    private static Vector<String> outputs;
    private static Set<SWRLRule> precondtionRules;
    private static Set<SWRLRule> effectRules;
    static SWRLRule testRule;

    static {
        logger = null;
        inputs = new Vector();
        outputs = new Vector();
        precondtionRules = new TreeSet<SWRLRule>();
        effectRules = new TreeSet<SWRLRule>();
        testRule = null;
    }

    private static String searchServiceName() {
        String profileName = "";
        OWLOntology localOnt = ontology;
        for (OWLDataPropertyAssertionAxiom odpaa : localOnt.getAxioms(AxiomType.DATA_PROPERTY_ASSERTION)) {
            if (!((OWLDataPropertyExpression)odpaa.getProperty()).toString().equals("serviceName")) continue;
            profileName = ((OWLConstant)odpaa.getObject()).getLiteral();
            break;
        }
        return profileName;
    }

    private static String searchServiceTextDescription() {
        String textualServiceDescription = "";
        OWLOntology localOnt = ontology;
        for (OWLDataPropertyAssertionAxiom odpaa : localOnt.getAxioms(AxiomType.DATA_PROPERTY_ASSERTION)) {
            if (!((OWLDataPropertyExpression)odpaa.getProperty()).toString().equals("textDescription")) continue;
            textualServiceDescription = ((OWLConstant)odpaa.getObject()).getLiteral();
            break;
        }
        return textualServiceDescription;
    }

    public static ServiceDescription getServiceDescription(String profileURI, OWLOntologyManager man, Log log) {
        logger = log;
        logger.debug((Object)("Reading description from: " + profileURI));
        inputs.clear();
        outputs.clear();
        precondtionRules.clear();
        effectRules.clear();
        manager = man;
        URI physicalURI = URI.create(profileURI);
        ontology = manager.getOntology(physicalURI);
        if (ontology == null) {
            try {
                ontology = manager.loadOntologyFromPhysicalURI(physicalURI);
            }
            catch (OWLOntologyCreationException e) {
                e.printStackTrace();
            }
        }
        return OWLSAnalyzer.createServiceDescriptionFromOntology(ontology);
    }

    public static ServiceDescription createServiceDescriptionFromOntology(OWLOntology ontology) {
        Vector<URI> ins = OWLSAnalyzer.searchInputParameters();
        Vector<URI> outs = OWLSAnalyzer.searchOutputParameters();
        if (ins.isEmpty() && outs.isEmpty()) {
            return null;
        }
        logger.debug((Object)("Inputs are: \n" + ins.toString()));
        logger.debug((Object)("Outputs are: \n" + outs.toString()));
        String profileName = OWLSAnalyzer.searchServiceName();
        String textualServiceDescription = OWLSAnalyzer.searchServiceTextDescription();
        OWLIndividual profileInd = OWLSAnalyzer.searchProfileID("presentedBy");
        Vector<SWRLRule> preRules = OWLSAnalyzer.getRules(PRE_PROPERTY);
        Vector<SWRLRule> effRules = OWLSAnalyzer.getRules(EFF_PROPERTY);
        Vector<OWLIndividual> inputIndividuals = OWLSAnalyzer.getOWLIndividualsFromParameter(ins, manager);
        Vector<OWLIndividual> outputIndividuals = OWLSAnalyzer.getOWLIndividualsFromParameter(outs, manager);
        Vector<OWLClass> inputClasses = OWLSAnalyzer.getOWLClassFromParameter(ins, manager);
        Vector<OWLClass> outputClasses = OWLSAnalyzer.getOWLClassFromParameter(outs, manager);
        ServiceDescription servAdv = new ServiceDescription(profileName, ontology, preRules, effRules, inputClasses, outputClasses, inputIndividuals, outputIndividuals, textualServiceDescription);
        return servAdv;
    }

    private static OWLIndividual searchProfileID(String objectPropertyValue) {
        OWLOntology localOnt = ontology;
        for (OWLObjectPropertyAssertionAxiom oopaa : localOnt.getAxioms(AxiomType.OBJECT_PROPERTY_ASSERTION)) {
            if (!objectPropertyValue.equals(((OWLObjectPropertyExpression)oopaa.getProperty()).toString())) continue;
            OWLIndividual profileInd = oopaa.getSubject();
            return profileInd;
        }
        return null;
    }

    private static Vector<OWLClass> getOWLClassFromParameter(Vector<URI> paramOnts, OWLOntologyManager manager) {
        Vector<OWLClass> clses = new Vector<OWLClass>();
        OWLClass cls = null;
        OWLDataFactory factory = manager.getOWLDataFactory();
        for (URI paramOntURI : paramOnts) {
            cls = null;
            cls = OWLSAnalyzer.getClassForIndividual(paramOntURI = OWLSAnalyzer.checkForSimpleDataTypes(paramOntURI), manager);
            if (cls == null) {
                cls = factory.getOWLClass(paramOntURI);
            }
            clses.add(cls);
        }
        return clses;
    }

    private static OWLClass getClassForIndividual(URI paramOntURI, OWLOntologyManager manager) {
        Object indAxioms = null;
        Set classAssertions = null;
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLIndividual ind = factory.getOWLIndividual(paramOntURI);
        String pureURI = paramOntURI.toString().substring(0, paramOntURI.toString().lastIndexOf("#"));
        OWLOntology onto = manager.getOntology(URI.create(pureURI));
        if (onto != null) {
            classAssertions = onto.getClassAssertionAxioms(ind);
        }
        if (classAssertions != null || classAssertions.size() > 0) {
            for (OWLClassAssertionAxiom classAssertionAxiom : classAssertions) {
                Set classes = classAssertionAxiom.getClassesInSignature();
                for (OWLClass class1 : classes) {
                    String idenitifier = class1.getURI().toString().substring(class1.getURI().toString().indexOf("#") + 1);
                    if (idenitifier.equals("Thing")) continue;
                    return class1;
                }
            }
        }
        return null;
    }

    private static Vector<OWLIndividual> getOWLIndividualsFromParameter(Vector<URI> paramOnts, OWLOntologyManager manager) {
        Vector<OWLIndividual> inds = new Vector<OWLIndividual>();
        OWLDataFactory factory = manager.getOWLDataFactory();
        for (URI paramOntURI : paramOnts) {
            OWLClass cls = OWLSAnalyzer.getClassForIndividual(paramOntURI, manager);
            if (cls == null) continue;
            OWLIndividual ind = factory.getOWLIndividual(paramOntURI);
            inds.add(ind);
        }
        return inds;
    }

    private static URI checkForSimpleDataTypes(URI paramOntURI) {
        int decollator = paramOntURI.toString().indexOf("#");
        String uriHead = paramOntURI.toString().substring(0, decollator);
        String uriTail = paramOntURI.toString().substring(decollator + 1);
        if (uriHead.toLowerCase().equals("http://www.w3.org/2001/xmlschema")) {
            paramOntURI = URI.create("http://user.cs.tu-berlin.de/~masuch/owls/SimpleDataTypes.owl#" + uriTail);
        }
        return paramOntURI;
    }

    private static Vector<URI> searchOutputParameters() {
        return OWLSAnalyzer.searchObjectPropertyAxiom(OUTPUT_PROPERTY);
    }

    private static Vector<URI> searchInputParameters() {
        return OWLSAnalyzer.searchObjectPropertyAxiom(INPUT_PROPERTY);
    }

    private static Vector<URI> searchObjectPropertyAxiom(String objectPropertyValue) {
        Vector<URI> returnParameters = new Vector<URI>();
        OWLOntology localOnt = ontology;
        for (OWLObjectPropertyAssertionAxiom oopaa : localOnt.getAxioms(AxiomType.OBJECT_PROPERTY_ASSERTION)) {
            if (!objectPropertyValue.equals(((OWLObjectPropertyExpression)oopaa.getProperty()).toString()) || !((OWLObjectPropertyExpression)oopaa.getProperty()).asOWLObjectProperty().getURI().toString().equals("http://www.daml.org/services/owl-s/1.1/Profile.owl#" + objectPropertyValue)) continue;
            OWLIndividual object = (OWLIndividual)oopaa.getObject();
            String objectURI = String.valueOf(object.getURI().getScheme()) + ":" + object.getURI().getSchemeSpecificPart();
            if (!objectURI.equals(localOnt.getURI().toString())) {
                Set impOnts = manager.getImports(localOnt);
                for (OWLOntology impOnt : impOnts) {
                    if (!impOnt.getURI().toString().equals(objectURI)) continue;
                    Set axioms = impOnt.getAxioms(object);
                    for (OWLIndividualAxiom oWLIndividualAxiom : axioms) {
                    }
                    localOnt = impOnt;
                }
            }
            Map content = ((OWLIndividual)oopaa.getObject()).getDataPropertyValues(localOnt);
            Set odpeSet = content.keySet();
            for (OWLDataPropertyExpression element : odpeSet) {
                Set constantSet = (Set)content.get(element);
                for (OWLConstant constant : constantSet) {
                    int first = constant.toString().indexOf("\"") + 1;
                    int last = constant.toString().lastIndexOf("\"");
                    String uriString = constant.toString().substring(first, last);
                    URI uri = URI.create(uriString);
                    returnParameters.add(uri);
                }
            }
        }
        return returnParameters;
    }

    public static Vector<SWRLRule> getRules(String typeOfRule) {
        Vector<SWRLRule> preconditionRules = new Vector<SWRLRule>();
        Set rules = ontology.getRules();
        TreeSet<OWLIndividual> ruleIds = new TreeSet<OWLIndividual>();
        for (OWLObjectPropertyAssertionAxiom oopaa : ontology.getAxioms(AxiomType.OBJECT_PROPERTY_ASSERTION)) {
            if (!((OWLObjectPropertyExpression)oopaa.getProperty()).toString().equals(typeOfRule) || !oopaa.getSubject().getTypes(ontology).toString().contains(PROFILE_IDENTIFIER)) continue;
            ruleIds.add((OWLIndividual)oopaa.getObject());
        }
        for (SWRLRule rule : rules) {
            for (OWLIndividual individual : ruleIds) {
                if (!rule.getURI().getFragment().equals(individual.toString())) continue;
                preconditionRules.add(rule);
            }
        }
        return preconditionRules;
    }

    public static OWLOntology getOntology(String refURI) {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        URI physicalURI = URI.create(refURI);
        try {
            return manager.loadOntologyFromPhysicalURI(physicalURI);
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Set<SWRLRule> searchPublicObjectProperty(String objectPropertyValue, OWLOntology refURI) {
        OWLOntology localOnt = refURI;
        TreeSet<SWRLRule> preRules = new TreeSet<SWRLRule>();
        for (OWLObjectPropertyAssertionAxiom oopaa : localOnt.getAxioms(AxiomType.OBJECT_PROPERTY_ASSERTION)) {
            if (!objectPropertyValue.equals(((OWLObjectPropertyExpression)oopaa.getProperty()).toString())) continue;
            OWLIndividual ruleRef = (OWLIndividual)oopaa.getObject();
            for (OWLObjectPropertyAssertionAxiom axRule : localOnt.getAxioms(AxiomType.OBJECT_PROPERTY_ASSERTION)) {
                if (!axRule.getSubject().toString().equals(ruleRef.toString())) continue;
                URI ruleRefURI = ((OWLIndividual)axRule.getObject()).getURI();
                for (SWRLRule rule : localOnt.getRules()) {
                    if (!ruleRefURI.equals(rule.getURI())) continue;
                    preRules.add(rule);
                }
            }
        }
        return preRules;
    }

    public static void main(String[] args) {
        try {
            manager = OWLManager.createOWLOntologyManager();
            Log logger = LogFactory.getLog(OWLSAnalyzer.class);
            String profileURI = "http://127.0.0.1/services/1.1/surfing_destination_Alwaysservice.owls";
            ontology = manager.loadOntologyFromPhysicalURI(URI.create(profileURI));
            OWLSAnalyzer.getServiceDescription(profileURI, manager, logger);
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
    }

    public static SWRLRule getRule() {
        manager = OWLManager.createOWLOntologyManager();
        URI physicalURI = URI.create("file:./profiles/BabelFishTranslator.owl");
        try {
            ontology = manager.loadOntologyFromPhysicalURI(physicalURI);
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
        Set rules = ontology.getRules();
        Iterator iterator = rules.iterator();
        while (iterator.hasNext()) {
            SWRLRule rule;
            testRule = rule = (SWRLRule)iterator.next();
        }
        return testRule;
    }
}

