/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.servicematcher.result;

import de.dailab.jiactng.agentcore.ontology.IServiceDescription;
import de.dailab.jiactng.servicematcher.result.MatchingResults;
import de.dailab.jiactng.servicematcher.result.ParamResult;
import java.util.Vector;
import org.semanticweb.owl.model.OWLClass;

public class ServiceMatchingResult {
    public final int NAME_MATCHING_MAX_RESULT = MatchingResults.NAMEMATCHING_MATCH.getValue();
    public final int PARAM_TAXONOMY_MATCHING_MAX_RESULT = MatchingResults.TAXMATCHING_MATCH.getValue();
    public final int RULE_STRUCTURE_MATCHING_MAX_RESULT = MatchingResults.RULESTRUCTMATCH_MATCH.getValue();
    public final int RULE_REASONING_MATCHING_MAX_RESULT = MatchingResults.RULEREASONING_MATCH.getValue();
    public final int TEXT_DESCRIPTION_STRING_MATCHING_MAX_RESULT = MatchingResults.TEXTSIM_PERFECT.getValue();
    private int _overallMatchingResult = 0;
    private int _overallMatchingPossible = 2 * this.PARAM_TAXONOMY_MATCHING_MAX_RESULT + this.NAME_MATCHING_MAX_RESULT;
    private int _nameMatchingResult = 0;
    private int _textMatchingResult = 0;
    private int _inputMatchingResult = 0;
    private int _outputMatchingResult = 0;
    private String _serviceNameReq = "";
    private String _serviceNameAdv = "";
    private Vector<ParamResult> _singleInputResults = new Vector();
    private Vector<ParamResult> _singleOutputResults = new Vector();
    private Vector<OWLClass> _unmatchableInputParam = new Vector();
    private Vector<OWLClass> _unmatchableOutputParam = new Vector();
    private int _preConditionRuleStructureResult = 0;
    private int _effectRuleStructureResult = 0;
    private int _preconditionRuleReasoningResult = 0;
    private int _effectRuleReasoningResult;
    private IServiceDescription description = null;

    public int getPreconditionRuleStructureResult() {
        return this._preConditionRuleStructureResult;
    }

    public int getEffectRuleStructureResult() {
        return this._effectRuleStructureResult;
    }

    public int getPreconditionRuleReasoningResult() {
        return this._preconditionRuleReasoningResult;
    }

    public int getEffectRuleReasoningResult() {
        return this._effectRuleReasoningResult;
    }

    public ServiceMatchingResult(IServiceDescription description) {
        this.description = description;
    }

    public int getInputMatchingResult() {
        return this._inputMatchingResult;
    }

    public int getOutputMatchingResult() {
        return this._outputMatchingResult;
    }

    public int getNameMatchingResult() {
        return this._nameMatchingResult;
    }

    public int getTextMatchingResult() {
        return this._textMatchingResult;
    }

    public String getAdvServiceName() {
        return this._serviceNameAdv;
    }

    public void setNameMatchingResult(int nameResult, String reqName, String advName) {
        this._nameMatchingResult = nameResult;
        this._serviceNameReq = reqName;
        this._serviceNameAdv = advName;
        this.addToOverallResult(nameResult);
    }

    public void setTextMatchingResult(int textMatchingResult) {
        this._textMatchingResult = textMatchingResult;
    }

    public void setInputOverallMatchingResult(int inputResult) {
        this._inputMatchingResult = inputResult;
        this.addToOverallResult(inputResult);
    }

    public void setOutputOverallMatchingResult(int outputResult) {
        this._outputMatchingResult = outputResult;
        this.addToOverallResult(outputResult);
    }

    public void setInputParamResult(int singleParamResult, OWLClass reqParam, OWLClass advParam) {
        ParamResult inputResult = new ParamResult(singleParamResult, reqParam, advParam);
        this._singleInputResults.add(inputResult);
    }

    public void setOutputParamResult(int singleParamResult, OWLClass reqParam, OWLClass advParam) {
        ParamResult outputResult = new ParamResult(singleParamResult, reqParam, advParam);
        this._singleOutputResults.add(outputResult);
    }

    public void setInputUnmatchableParam(OWLClass inputClass) {
        this._unmatchableInputParam.add(inputClass);
    }

    public void setOutputUnmatchableParam(OWLClass outputClass) {
        this._unmatchableOutputParam.add(outputClass);
    }

    public void setPreConditionRuleStructureResult(int preStructureResult) {
        this.addToOverallResult(preStructureResult);
        this.addToOverallPossible(this.RULE_STRUCTURE_MATCHING_MAX_RESULT);
        this._preConditionRuleStructureResult = preStructureResult;
    }

    public void setEffectRuleStructureResult(int effStructureResult) {
        this.addToOverallResult(effStructureResult);
        this.addToOverallPossible(this.RULE_STRUCTURE_MATCHING_MAX_RESULT);
        this._effectRuleStructureResult = effStructureResult;
    }

    public void setPreConditionRuleReasoningResult(int preReasoningResult) {
        this.addToOverallResult(preReasoningResult);
        this.addToOverallPossible(this.RULE_REASONING_MATCHING_MAX_RESULT);
        this._preconditionRuleReasoningResult = preReasoningResult;
    }

    public void setEffectRuleReasoningResult(int effReasoningResult) {
        this.addToOverallResult(effReasoningResult);
        this.addToOverallPossible(this.RULE_REASONING_MATCHING_MAX_RESULT);
        this._effectRuleReasoningResult = effReasoningResult;
    }

    private void addToOverallResult(int result) {
        this._overallMatchingResult += result;
    }

    private void addToOverallPossible(int possible) {
        this._overallMatchingPossible += possible;
    }

    public int getOverallResult() {
        return this._overallMatchingResult;
    }

    public int getOverallPossible() {
        return this._overallMatchingPossible;
    }

    public IServiceDescription getDescription() {
        return this.description;
    }

    public void setDescription(IServiceDescription description) {
        this.description = description;
    }
}

