/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.test;

import java.net.URI;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;

public class PelletPerformanceTest {
    public static void main(String[] args) {
        PelletPerformanceTest.test3();
    }

    private static void test3() {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        Reasoner reasoner = new Reasoner(manager);
        try {
            boolean sub;
            OWLOntology ont = manager.loadOntology(URI.create("http://127.0.0.1/ontology/extendedCamera.owl"));
            reasoner.loadOntology(ont);
            ont = manager.loadOntology(URI.create("http://127.0.0.1/ontology/Mid-level-ontology.owl"));
            reasoner.loadOntology(ont);
            OWLDataFactory factory = manager.getOWLDataFactory();
            OWLClass digV = factory.getOWLClass(URI.create("http://127.0.0.1/ontology/extendedCamera.owl#Digital-Video"));
            OWLClass dig = factory.getOWLClass(URI.create("http://127.0.0.1/ontology/Mid-level-ontology.owl#WarmFront"));
            boolean equiv = reasoner.isEquivalentClass((OWLDescription)dig, (OWLDescription)digV);
            if (equiv) {
                System.out.println("Classes are equivalent!");
            }
            if (sub = reasoner.isSubClassOf((OWLDescription)dig, (OWLDescription)digV)) {
                System.out.println("Classes have subclass relation");
            }
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
    }

    private static void test2() {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        Reasoner reasoner = new Reasoner(manager);
        try {
            boolean sub;
            OWLOntology ont = manager.loadOntology(URI.create("http://127.0.0.1/ontology/Mid-level-ontology.owl"));
            reasoner.loadOntology(ont);
            ont = manager.loadOntology(URI.create("http://127.0.0.1/ontology/extendedCamera.owl"));
            ont = manager.loadOntology(URI.create("http://127.0.0.1/ontology/concept.owl"));
            reasoner.loadOntology(ont);
            System.out.println("Loaded Mid Ont");
            OWLDataFactory factory = manager.getOWLDataFactory();
            OWLClass adjective = factory.getOWLClass(URI.create("http://127.0.0.1/ontology/Mid-level-ontology.owl#Banker"));
            OWLClass word = factory.getOWLClass(URI.create("http://127.0.0.1/ontology/Mid-level-ontology.owl#Report"));
            boolean equiv = reasoner.isEquivalentClass((OWLDescription)adjective, (OWLDescription)word);
            if (equiv) {
                System.out.println("Classes are equivalent!");
            }
            if (sub = reasoner.isSubClassOf((OWLDescription)adjective, (OWLDescription)word)) {
                System.out.println("Classes have subclass relation");
            }
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
    }

    private static void test1() {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        Reasoner reasoner = new Reasoner(manager);
        try {
            boolean sub;
            OWLOntology ont1 = manager.loadOntology(URI.create("http://127.0.0.1/ontology/portal.owl"));
            reasoner.loadOntology(ont1);
            System.out.println("Loaded 1");
            OWLOntology ont2 = manager.loadOntology(URI.create("http://127.0.0.1/ontology/books.owl"));
            reasoner.loadOntology(ont2);
            System.out.println("Loaded 2");
            OWLOntology ont3 = manager.loadOntology(URI.create("http://127.0.0.1/ontology/support.owl"));
            reasoner.loadOntology(ont3);
            System.out.println("Loaded 3");
            OWLOntology ont4 = manager.loadOntology(URI.create("http://127.0.0.1/ontology/Mid-level-ontology.owl"));
            reasoner.loadOntology(ont4);
            System.out.println("Loaded 4");
            OWLOntology ont5 = manager.loadOntology(URI.create("http://127.0.0.1/ontology/SUMO.owl"));
            reasoner.loadOntology(ont5);
            System.out.println("Loaded 5");
            OWLOntology ont6 = manager.loadOntology(URI.create("http://127.0.0.1/ontology/concept.owl"));
            reasoner.loadOntology(ont6);
            System.out.println("Loaded 6");
            OWLOntology ont7 = manager.loadOntology(URI.create("http://127.0.0.1/ontology/my_ontology.owl"));
            reasoner.loadOntology(ont7);
            System.out.println("Loaded 7");
            OWLOntology ont8 = manager.loadOntology(URI.create("http://127.0.0.1/ontology/wine.owl"));
            reasoner.loadOntology(ont8);
            System.out.println("Loaded 8");
            OWLOntology ont9 = manager.loadOntology(URI.create("http://127.0.0.1/ontology/food.owl"));
            reasoner.loadOntology(ont9);
            System.out.println("Loaded 9");
            OWLOntology ont10 = manager.loadOntology(URI.create("http://127.0.0.1/ontology/travel.owl"));
            reasoner.loadOntology(ont10);
            System.out.println("Loaded 10");
            OWLOntology ont11 = manager.loadOntology(URI.create("http://127.0.0.1/ontology/extendedCamera.owl"));
            reasoner.loadOntology(ont11);
            System.out.println("Loaded 11");
            OWLDataFactory factory = manager.getOWLDataFactory();
            OWLClass adjective = factory.getOWLClass(URI.create("http://127.0.0.1/ontology/SUMO.owl#Adjective"));
            OWLClass word = factory.getOWLClass(URI.create("http://127.0.0.1/ontology/SUMO.owl#Word"));
            boolean equiv = reasoner.isEquivalentClass((OWLDescription)adjective, (OWLDescription)word);
            if (equiv) {
                System.out.println("Classes are equivalent!");
            }
            if (sub = reasoner.isSubClassOf((OWLDescription)adjective, (OWLDescription)word)) {
                System.out.println("Classes have subclass relation");
            }
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
    }
}

