/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.builtins.BuiltInRegistry;
import com.clarkparsia.pellet.rules.builtins.NoSuchBuiltIn;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.RuleAtomVisitor;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import java.util.HashSet;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;

public class UsableRuleFilter {
    public static final Logger log = KnowledgeBase.log;
    private static BodyAtomFilter bodyFilter = new BodyAtomFilter();
    private static HeadAtomFilter headFilter = new HeadAtomFilter();

    public static boolean isUsable(Rule rule) {
        HashSet<AtomVariable> bodyVars = new HashSet<AtomVariable>();
        for (RuleAtom ruleAtom : rule.getBody()) {
            ruleAtom.accept(bodyFilter);
            if (!bodyFilter.isUsable()) {
                log.warning("Ignoring rule " + rule + ":" + bodyFilter.getMessage());
                return false;
            }
            bodyVars.addAll(VariableUtils.getVars(ruleAtom));
        }
        for (RuleAtom ruleAtom : rule.getHead()) {
            ruleAtom.accept(headFilter);
            if (!bodyVars.containsAll(VariableUtils.getVars(ruleAtom))) {
                log.warning("Ignoring rule " + rule + ": Head atom " + ruleAtom + " contains variables not found in body.");
                return false;
            }
            if (headFilter.isUsable()) continue;
            log.warning("Ignoring rule " + rule + ":" + headFilter.getMessage());
            return false;
        }
        return true;
    }

    private static class HeadAtomFilter
    implements RuleAtomVisitor {
        private boolean usable;
        private String usageMessage;

        private HeadAtomFilter() {
        }

        public String getMessage() {
            return this.usageMessage;
        }

        public boolean isUsable() {
            return this.usable;
        }

        public void visit(BuiltInAtom atom) {
            this.usable = false;
            this.usageMessage = "Builtin atoms in rule heads are not currently supported";
        }

        public void visit(ClassAtom atom) {
            this.usable = true;
        }

        public void visit(DataRangeAtom atom) {
            this.usable = false;
            this.usageMessage = "DataRange atoms in rule heads are not currently supported";
        }

        public void visit(DatavaluedPropertyAtom atom) {
            this.usable = true;
        }

        public void visit(DifferentIndividualsAtom atom) {
            this.usable = true;
        }

        public void visit(IndividualPropertyAtom atom) {
            this.usable = true;
        }

        public void visit(SameIndividualAtom atom) {
            this.usable = true;
        }
    }

    private static class BodyAtomFilter
    implements RuleAtomVisitor {
        private boolean usable;
        private String usageMessage;

        private BodyAtomFilter() {
        }

        public String getMessage() {
            return this.usageMessage;
        }

        public boolean isUsable() {
            return this.usable;
        }

        public void visit(BuiltInAtom atom) {
            BuiltIn builtin = BuiltInRegistry.instance.getBuiltIn((String)atom.getPredicate());
            if (builtin.equals(NoSuchBuiltIn.instance)) {
                this.usable = false;
                this.usageMessage = "No builtin for " + (String)atom.getPredicate();
            } else {
                this.usable = true;
            }
        }

        public void visit(ClassAtom atom) {
            this.usable = true;
        }

        public void visit(DataRangeAtom atom) {
            this.usable = true;
        }

        public void visit(DatavaluedPropertyAtom atom) {
            this.usable = true;
        }

        public void visit(DifferentIndividualsAtom atom) {
            this.usable = true;
        }

        public void visit(IndividualPropertyAtom atom) {
            this.usable = true;
        }

        public void visit(SameIndividualAtom atom) {
            this.usable = true;
        }
    }
}

