/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.sme2;

import de.dfki.owlsmx.SimilarityMatchingEngine;
import de.dfki.owlsmx.data.MatchedService;
import de.dfki.owlsmx.exceptions.MatchingException;
import de.dfki.owlsmx.sme2.Logger;
import de.dfki.sme2.IMatchmakerPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Hashtable;
import java.util.SortedSet;
import java.util.Vector;

public class OWLSM3
implements IMatchmakerPlugin {
    private static java.util.logging.Logger logger = Logger.getLogger("OWLSMX");
    private static final double SYN_THRESHOLD = 0.51;
    private final SimilarityMatchingEngine _mm_impl = new SimilarityMatchingEngine();
    private Hashtable<URL, Vector<URL>> _result = new Hashtable();
    private static final String FILE = "file://";

    public OWLSM3() {
        this._mm_impl.setSimilarityMeasure((short)2);
    }

    public void input(URL serviceURL) {
        try {
            String[] _service_names;
            String[] stringArray = _service_names = OWLSM3.names(serviceURL);
            int n = _service_names.length;
            int n2 = 0;
            while (n2 < n) {
                String service_name = stringArray[n2];
                try {
                    URI uri = new URI(service_name);
                    this._mm_impl.addService(uri);
                }
                catch (Exception e) {
                    logger.severe("Error adding service: " + service_name + " " + e.toString());
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.severe("Can't parse services - " + e.toString());
        }
    }

    public Hashtable<URL, Vector<URL>> query(URL queryURL) {
        this._result.clear();
        try {
            String[] query_names = OWLSM3.names(queryURL);
            int i = 0;
            while (i < query_names.length) {
                logger.severe("query");
                Vector<URL> replies = new Vector<URL>();
                try {
                    URL query = new URL(query_names[i]);
                    SortedSet reply = this._mm_impl.matchRequest(OWLSM3.inputstream(query), 5, 0.51);
                    reply = SimilarityMatchingEngine.sortMatchingResult((SortedSet)reply, (int)0);
                    for (MatchedService result : reply) {
                        replies.add(result.serviceURI.toURL());
                    }
                    this._result.put(query, replies);
                    logger.severe("finished query");
                }
                catch (FileNotFoundException e) {
                    System.out.println("File not found: " + query_names[i]);
                    logger.severe("error" + e.toString());
                }
                catch (MatchingException e) {
                    System.out.println("Can't query: " + query_names[i]);
                    logger.severe("error" + e.toString());
                }
                catch (Exception e) {
                    System.out.println("Invalid url: " + query_names[i]);
                    logger.severe("error" + e.toString());
                }
                ++i;
            }
        }
        catch (IOException e) {
            logger.severe("Can't get queries - " + e.toString());
            return null;
        }
        return this._result;
    }

    private static String[] names(URL url) throws IOException {
        File file;
        if (url.toString().startsWith(FILE) && (file = new File(url.toString().substring(FILE.length()))).isDirectory()) {
            String[] list = file.list(FileNameFilter.OWLS);
            int i = 0;
            while (i < list.length) {
                list[i] = String.valueOf(url.toString().replaceAll(FILE, "file:///")) + list[i];
                ++i;
            }
            return list;
        }
        return new String[]{url.toString().replaceAll(FILE, "file:///")};
    }

    private static InputStream inputstream(URI uri) throws IOException {
        if (uri.toString().startsWith(FILE)) {
            return new FileInputStream(uri.toString().substring(FILE.length()));
        }
        return uri.toURL().openStream();
    }

    private static InputStream inputstream(URL url) throws IOException, URISyntaxException {
        return OWLSM3.inputstream(url.toURI());
    }

    public static class FileNameFilter
    implements FilenameFilter {
        public static final FileNameFilter OWLS = new FileNameFilter(".owls");
        private final String _suffix;

        public FileNameFilter(String suffix) {
            this._suffix = suffix;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this._suffix);
        }
    }
}

