/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.sme2;

import de.dfki.owlsmx.SimilarityMatchingEngine;
import de.dfki.owlsmx.data.MatchedService;
import de.dfki.owlsmx.exceptions.MatchingException;
import de.dfki.owlsmx.sme2.Logger;
import de.dfki.owlsmx.sme2.TestCollection;
import de.dfki.sme2.IMatchmakerPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class OWLSMXAnalysisOutput
implements IMatchmakerPlugin {
    private static java.util.logging.Logger logger = Logger.getLogger("OWLSMX");
    private static final double SYN_THRESHOLD = -1.0;
    private final SimilarityMatchingEngine _mm_impl = new SimilarityMatchingEngine();
    private Hashtable<URL, Vector<URL>> _result = new Hashtable();
    private TestCollection tc;
    private static final String FILE = "file://";

    public OWLSMXAnalysisOutput() {
        this._mm_impl.setSimilarityMeasure((short)2);
        this._mm_impl.setIntegrative(true);
        this._mm_impl.setStructural(true);
        this.tc = TestCollection.parse("testcollections\\owls-tc2_2_rev_2\\owls-tc.xml");
    }

    public void input(URL serviceURL) {
        try {
            String[] _service_names;
            String[] stringArray = _service_names = OWLSMXAnalysisOutput.names(serviceURL);
            int n = _service_names.length;
            int n2 = 0;
            while (n2 < n) {
                String service_name = stringArray[n2];
                try {
                    URI uri = new URI(service_name);
                    this._mm_impl.addService(uri);
                }
                catch (Exception e) {
                    logger.severe("Error adding service: " + service_name + " " + e.toString());
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.severe("Can't parse services - " + e.toString());
        }
    }

    public Hashtable<URL, Vector<URL>> query(URL queryURL) {
        this._result.clear();
        try {
            String[] query_names = OWLSMXAnalysisOutput.names(queryURL);
            int i = 0;
            while (i < query_names.length) {
                logger.severe("query");
                Vector<URL> replies = new Vector<URL>();
                try {
                    URL query = new URL(query_names[i]);
                    SortedSet reply = this._mm_impl.matchRequest(OWLSMXAnalysisOutput.inputstream(query), 5, -1.0);
                    reply = SimilarityMatchingEngine.sortMatchingResult((SortedSet)reply, (int)3);
                    for (MatchedService result : reply) {
                        replies.add(result.serviceURI.toURL());
                    }
                    this.outputResults(query, reply);
                    this._result.put(query, replies);
                    logger.severe("finished query");
                }
                catch (FileNotFoundException e) {
                    System.out.println("File not found: " + query_names[i]);
                    logger.severe("error" + e.toString());
                }
                catch (MatchingException e) {
                    System.out.println("Can't query: " + query_names[i]);
                    logger.severe("error" + e.toString());
                }
                catch (Exception e) {
                    System.out.println("Invalid url: " + query_names[i]);
                    logger.severe("error" + e.toString());
                }
                ++i;
            }
        }
        catch (IOException e) {
            logger.severe("Can't get queries - " + e.toString());
            return null;
        }
        return this._result;
    }

    private void outputResults(URL query, SortedSet<MatchedService> rankingMX3) {
        try {
            FileWriter writer = new FileWriter("OWLS-MX_results.txt", true);
            SortedSet rankingLB = SimilarityMatchingEngine.sortMatchingResult(rankingMX3, (int)1);
            SortedSet rankingIR = SimilarityMatchingEngine.sortMatchingResult(rankingMX3, (int)2);
            TreeSet<MatchedService> rankingMX2 = new TreeSet<MatchedService>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    int domS1 = ((MatchedService)o1).getDegreeOfMatch();
                    int domS2 = ((MatchedService)o2).getDegreeOfMatch();
                    double simS1 = ((MatchedService)o1).getSyntacticSimilarity();
                    double simS2 = ((MatchedService)o2).getSyntacticSimilarity();
                    if (simS1 < 0.51 && simS2 < 0.51) {
                        return 0;
                    }
                    if (simS1 >= 0.51 && simS2 < 0.51) {
                        return -1;
                    }
                    if (simS1 < 0.51 && simS2 >= 0.51) {
                        return 1;
                    }
                    if (domS1 < domS2) {
                        return -1;
                    }
                    if (domS1 > domS2) {
                        return 1;
                    }
                    if (simS1 > simS2) {
                        return -1;
                    }
                    return 1;
                }
            });
            rankingMX2.addAll(rankingMX3);
            TreeSet<MatchedService> rankingS = new TreeSet<MatchedService>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    double simS1 = ((MatchedService)o1).structure;
                    double simS2 = ((MatchedService)o2).structure;
                    if (simS1 > simS2) {
                        return -1;
                    }
                    return 1;
                }
            });
            rankingS.addAll(rankingMX3);
            int rMX3 = 1;
            for (MatchedService result : rankingMX3) {
                String queryID = query.toString();
                String serviceID = result.serviceURI.toString();
                String isRel = this.tc.getRelevanceSet(query).isBinaryRelevant(result.serviceURI.toURL()) ? "1" : "0";
                String relMX3 = result.svm > 0.0 ? "1" : "0";
                String relMX2 = result.getSyntacticSimilarity() >= 0.51 ? "1" : "0";
                String relLB = result.getDegreeOfMatch() > 5 ? "1" : "0";
                String relIR = result.getSyntacticSimilarity() >= 0.51 ? "1" : "0";
                String relS = result.structure >= 0.51 ? "1" : "0";
                String rankMX3 = result.svm > 0.0 ? new Integer(rMX3).toString() : "-";
                String rankMX2 = "-";
                if (result.getSyntacticSimilarity() >= 0.51) {
                    int rMX2 = 1;
                    for (MatchedService temp : rankingMX2) {
                        if (temp.equals(result)) {
                            rankMX2 = new Integer(rMX2).toString();
                            break;
                        }
                        ++rMX2;
                    }
                }
                String rankLB = "-";
                if (result.getDegreeOfMatch() < 4) {
                    int rLB = 1;
                    for (MatchedService temp : rankingLB) {
                        if (temp.equals(result)) {
                            rankLB = new Integer(rLB).toString();
                            break;
                        }
                        ++rLB;
                    }
                }
                String rankIR = "-";
                if (result.getSyntacticSimilarity() >= 0.51) {
                    int rIR = 1;
                    for (MatchedService temp : rankingIR) {
                        if (temp.equals(result)) {
                            rankIR = new Integer(rIR).toString();
                            break;
                        }
                        ++rIR;
                    }
                }
                String rankS = "-";
                if (result.structure >= 0.51) {
                    int rS = 1;
                    for (MatchedService temp : rankingS) {
                        if (temp.equals(result)) {
                            rankS = new Integer(rS).toString();
                            break;
                        }
                        ++rS;
                    }
                }
                String resultMX3 = new Double(result.svm).toString();
                String resultMX2 = result.getDegreeOfMatch() == 0 && result.getSyntacticSimilarity() >= 0.51 ? "Exact" : (result.getDegreeOfMatch() == 1 && result.getSyntacticSimilarity() >= 0.51 ? "Plug-in" : (result.getDegreeOfMatch() == 2 && result.getSyntacticSimilarity() >= 0.51 ? "Subsumes" : (result.getDegreeOfMatch() == 3 && result.getSyntacticSimilarity() >= 0.51 ? "Subsumed-by" : (result.getSyntacticSimilarity() >= 0.51 ? "Nearest-neighbour" : "Fail"))));
                resultMX2 = String.valueOf(resultMX2) + ":" + result.getSyntacticSimilarity();
                String resultLB = result.getDegreeOfMatch() == 0 ? "Exact" : (result.getDegreeOfMatch() == 1 ? "Plug-in" : (result.getDegreeOfMatch() == 2 ? "Subsumes" : (result.getDegreeOfMatch() == 3 ? "Subsumed-by" : "Fail")));
                String resultIR = new Double(result.getSyntacticSimilarity()).toString();
                String resultS = new Double(result.structure).toString();
                writer.write("(" + queryID + "," + serviceID + "," + isRel + "," + relMX3 + "," + relMX2 + "," + relLB + "," + relIR + "," + relS + "," + rankMX3 + "," + rankMX2 + "," + rankLB + "," + rankIR + "," + rankS + "," + resultMX3 + "," + resultMX2 + "," + resultLB + "," + resultIR + "," + resultS + ")\n");
                ++rMX3;
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String[] names(URL url) throws IOException {
        File file;
        if (url.toString().startsWith(FILE) && (file = new File(url.toString().substring(FILE.length()))).isDirectory()) {
            String[] list = file.list(FileNameFilter.OWLS);
            int i = 0;
            while (i < list.length) {
                list[i] = String.valueOf(url.toString().replaceAll(FILE, "file:///")) + list[i];
                ++i;
            }
            return list;
        }
        return new String[]{url.toString().replaceAll(FILE, "file:///")};
    }

    private static InputStream inputstream(URI uri) throws IOException {
        if (uri.toString().startsWith(FILE)) {
            return new FileInputStream(uri.toString().substring(FILE.length()));
        }
        return uri.toURL().openStream();
    }

    private static InputStream inputstream(URL url) throws IOException, URISyntaxException {
        return OWLSMXAnalysisOutput.inputstream(url.toURI());
    }

    public static class FileNameFilter
    implements FilenameFilter {
        public static final FileNameFilter OWLS = new FileNameFilter(".owls");
        private final String _suffix;

        public FileNameFilter(String suffix) {
            this._suffix = suffix;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this._suffix);
        }
    }
}

