/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.sme2;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class RelevanceSet {
    private HashSet<URL> binaryRelevants = new HashSet();
    private HashSet<URL> binaryIrrelevants = new HashSet();
    private HashMap<String, Double> grades = new HashMap();
    private HashMap<URL, String> gradedRelevants = new HashMap();
    private HashSet<URL> gradedIrrelevants = new HashSet();

    public void addGrade(String grade, double gain) {
        this.grades.put(grade, new Double(gain));
    }

    public void addAsBinaryRelevant(URL service) {
        this.binaryRelevants.add(service);
    }

    public void addAsBinaryIrrelevant(URL service) {
        this.binaryIrrelevants.add(service);
    }

    public void addAsGradedRelevant(URL service, String grade) {
        this.gradedRelevants.put(service, grade);
    }

    public void addAsGradedIrrelevant(URL service) {
        this.gradedIrrelevants.add(service);
    }

    public boolean isBinaryRelevant(URL service) {
        return this.binaryRelevants.contains(service);
    }

    public boolean isBinaryIrrelevant(URL service) {
        return this.binaryIrrelevants.contains(service);
    }

    public boolean isGradedRelevant(URL service) {
        return this.gradedRelevants.containsKey(service);
    }

    public boolean isGradedIrrelevant(URL service) {
        return this.gradedIrrelevants.contains(service);
    }

    public String getGradeOfRelevance(URL service) {
        if (this.gradedRelevants.containsKey(service)) {
            return this.gradedRelevants.get(service);
        }
        if (this.gradedIrrelevants.contains(service)) {
            return "irrelevant";
        }
        return "unknown";
    }

    public double getGain(URL service) {
        String grade = this.getGradeOfRelevance(service);
        if (this.grades.containsKey(grade)) {
            return this.grades.get(grade);
        }
        return 0.0;
    }

    public int getNumberOfBinaryJudgements() {
        return this.binaryRelevants.size() + this.binaryIrrelevants.size();
    }

    public int getNumberOfGradedJudgements() {
        return this.gradedRelevants.size() + this.gradedIrrelevants.size();
    }

    public Set<URL> getBinaryRelevants() {
        return this.binaryRelevants;
    }

    public Set<URL> getBinaryIrrelevants() {
        return this.binaryIrrelevants;
    }
}

