/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.sme2;

import de.dfki.owlsmx.sme2.RelevanceSet;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestCollection {
    private Collection<URL> serviceOffers = new LinkedList<URL>();
    private Map<URL, RelevanceSet> queries = new HashMap<URL, RelevanceSet>();
    private String name = null;
    private String type = "";
    private String description = "";
    private String authors = "";

    private TestCollection() {
    }

    public void addServiceOffer(URL offer) {
        this.serviceOffers.add(offer);
    }

    public Collection<URL> getServiceOffers() {
        return this.serviceOffers;
    }

    public int getNumberOfServiceOffers() {
        return this.serviceOffers.size();
    }

    public int getNumberOfRequests() {
        return this.queries.size();
    }

    public void addQuery(URL query, RelevanceSet relevanceSet) {
        this.queries.put(query, relevanceSet);
    }

    public Collection<URL> getQueries() {
        return this.queries.keySet();
    }

    public RelevanceSet getRelevanceSet(URL query) {
        return this.queries.get(query);
    }

    public String getAuthors() {
        return this.authors;
    }

    public void setAuthors(String authors) {
        this.authors = authors;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isBinaryComplete() {
        for (RelevanceSet set : this.queries.values()) {
            if (set.getNumberOfBinaryJudgements() == this.serviceOffers.size()) continue;
            return false;
        }
        return true;
    }

    public boolean isGradedComplete() {
        for (RelevanceSet set : this.queries.values()) {
            if (set.getNumberOfGradedJudgements() == this.serviceOffers.size()) continue;
            return false;
        }
        return true;
    }

    public static TestCollection parse(String xmlFileName) {
        TestCollection tc = new TestCollection();
        try {
            File xmlFile = new File(xmlFileName);
            xmlFileName = xmlFile.getAbsolutePath();
            String path = xmlFileName.substring(0, xmlFileName.lastIndexOf(File.separator));
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xmlFileName);
            NodeList nodes = doc.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node configNode = nodes.item(i);
                if (configNode.getNodeType() == 1) {
                    String configNodeName = configNode.getNodeName();
                    if (configNodeName.equals("proprietary")) {
                        tc.proprietaryReadTCData(path);
                    } else if (configNodeName.equals("type")) {
                        tc.type = configNode.getTextContent();
                    } else if (configNodeName.equals("authors")) {
                        tc.authors = configNode.getTextContent();
                    } else if (configNodeName.equals("description")) {
                        tc.description = configNode.getTextContent();
                    } else if (configNodeName.equals("name")) {
                        tc.name = configNode.getTextContent();
                    }
                }
                ++i;
            }
            if (tc.name == null) {
                tc.name = xmlFile.getName().replaceFirst(".xml", "");
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        return tc;
    }

    private void proprietaryReadTCData(String directory) {
        File[] requests;
        File[] services;
        File offerDir = new File(String.valueOf(directory) + File.separator + "services");
        offerDir = new File(String.valueOf(offerDir.getAbsolutePath()) + File.separator + offerDir.list()[0]);
        File[] fileArray = services = offerDir.listFiles();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            File service = fileArray[n2];
            try {
                if (service.isFile()) {
                    this.serviceOffers.add(service.toURI().toURL());
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        File requestDir = new File(String.valueOf(directory) + File.separator + "queries");
        requestDir = new File(String.valueOf(requestDir.getAbsolutePath()) + File.separator + requestDir.list()[0]);
        File[] fileArray2 = requests = requestDir.listFiles();
        int n3 = requests.length;
        int n4 = 0;
        while (n4 < n3) {
            File request = fileArray2[n4];
            try {
                if (request.isFile()) {
                    this.queries.put(request.toURI().toURL(), new RelevanceSet());
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            ++n4;
        }
        File relevanceSetsDir = new File(String.valueOf(directory) + File.separator + "relevance_sets");
        block8: for (URL query : this.queries.keySet()) {
            String queryPath = query.getPath();
            String fileName = queryPath.substring(queryPath.lastIndexOf(47) + 1);
            String[] stringArray = relevanceSetsDir.list();
            int n5 = stringArray.length;
            int n6 = 0;
            while (n6 < n5) {
                String relDir = stringArray[n6];
                String relName = relDir.substring(relDir.indexOf(45) + 1);
                if (fileName.equals(relName)) {
                    File relSetDir = new File(String.valueOf(directory) + File.separator + "relevance_sets" + File.separator + relDir);
                    String[] stringArray2 = relSetDir.list();
                    int n7 = stringArray2.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        String relFile = stringArray2[n8];
                        try {
                            this.queries.get(query).addAsBinaryRelevant(new File(String.valueOf(offerDir.toString()) + File.separator + relFile).toURI().toURL());
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                        ++n8;
                    }
                    for (URL offer : this.serviceOffers) {
                        if (this.queries.get(query).isBinaryRelevant(offer)) continue;
                        this.queries.get(query).addAsBinaryIrrelevant(offer);
                    }
                    continue block8;
                }
                ++n6;
            }
        }
    }

    public Collection<TestCollection> nFold(int n, long randomSeed) {
        int foldSize = this.serviceOffers.size() / n;
        int overhang = this.serviceOffers.size() % n;
        LinkedList<URL> tmpOffers = new LinkedList<URL>(this.serviceOffers);
        HashSet<TestCollection> resultTCs = new HashSet<TestCollection>();
        Random rnd = new Random(randomSeed);
        int i = 0;
        while (i < n) {
            TestCollection tc = new TestCollection();
            tc.setName(String.valueOf(this.name) + " fold " + (i + 1));
            tc.setDescription("Automatically derived from " + this.name + ".");
            tc.setAuthors(this.authors);
            int mod = i < overhang ? 1 : 0;
            int j = 0;
            while (j < foldSize + mod) {
                int offerIndex = rnd.nextInt(tmpOffers.size());
                tc.addServiceOffer(tmpOffers.get(offerIndex));
                tmpOffers.remove(offerIndex);
                ++j;
            }
            for (URL query : this.queries.keySet()) {
                RelevanceSet relSet = new RelevanceSet();
                HashSet<URL> binaryRelevants = new HashSet<URL>();
                HashSet<URL> binaryIrrelevants = new HashSet<URL>();
                Collection<URL> reducedOffers = tc.getServiceOffers();
                for (URL offer : reducedOffers) {
                    if (this.queries.get(query).isBinaryRelevant(offer)) {
                        binaryRelevants.add(offer);
                        continue;
                    }
                    if (!this.queries.get(query).isBinaryIrrelevant(offer)) continue;
                    binaryIrrelevants.add(offer);
                }
                for (URL offer : binaryRelevants) {
                    relSet.addAsBinaryRelevant(offer);
                }
                for (URL offer : binaryIrrelevants) {
                    relSet.addAsBinaryIrrelevant(offer);
                }
                if (binaryRelevants.isEmpty()) continue;
                tc.addQuery(query, relSet);
            }
            if (!tc.queries.isEmpty()) {
                resultTCs.add(tc);
            }
            ++i;
        }
        return resultTCs;
    }

    public String toString() {
        return this.name;
    }
}

