/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdUpdate;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.Iterator;
import java.util.List;

public class update
extends CmdUpdate {
    ArgDecl updateArg = new ArgDecl(true, "--update");
    ArgDecl dumpArg = new ArgDecl(false, "--dump");
    List requestFiles = null;
    boolean dump = false;

    public static void main(String[] argv) {
        new update(argv).mainRun();
    }

    protected update(String[] argv) {
        super(argv);
        super.add(this.updateArg, "--update=FILE", "Update commands to execute");
        super.add(this.dumpArg, "--dump", "Dump the resulting graph store");
    }

    protected void processModulesAndArgs() {
        this.requestFiles = this.getValues(this.updateArg);
        this.dump = this.contains(this.dumpArg);
        super.processModulesAndArgs();
    }

    protected String getCommandName() {
        return Utils.className((Object)this);
    }

    protected String getSummary() {
        return this.getCommandName() + " --desc=assembler [--dump] --update=<request file>";
    }

    protected void execUpdate(GraphStore graphStore) {
        if (this.requestFiles.size() == 0 && this.getPositional().size() == 0) {
            throw new CmdException("Nothing to do");
        }
        Iterator iter = this.requestFiles.iterator();
        while (iter.hasNext()) {
            String filename = (String)iter.next();
            this.execOneFile(filename, graphStore);
        }
        iter = super.getPositional().iterator();
        while (iter.hasNext()) {
            String requestString = (String)iter.next();
            this.execOne(requestString, graphStore);
        }
        if (this.dump) {
            SSE.write((DatasetGraph)graphStore);
        }
    }

    private void execOneFile(String filename, GraphStore store) {
        UpdateRequest req = UpdateFactory.read((String)filename);
        UpdateFactory.create((UpdateRequest)req, (GraphStore)store).execute();
    }

    private void execOne(String requestString, GraphStore store) {
        UpdateRequest req = UpdateFactory.create((String)requestString);
        UpdateFactory.create((UpdateRequest)req, (GraphStore)store).execute();
    }
}

