/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import arq.examples.larq.ExLucene1;
import arq.examples.larq.ExLucene2;
import arq.examples.larq.ExLucene3;
import arq.examples.larq.ExLucene4;
import arq.examples.larq.ExLucene5;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.larq.IndexBuilderModel;
import com.hp.hpl.jena.query.larq.IndexBuilderNode;
import com.hp.hpl.jena.query.larq.IndexBuilderString;
import com.hp.hpl.jena.query.larq.IndexBuilderSubject;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import com.hp.hpl.jena.query.larq.LARQ;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.junit.TestLARQUtils;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestLARQ1
extends TestCase {
    static final String datafile = "testing/LARQ/data-1.ttl";

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestLARQ1.class);
        ts.setName("LARQ-code");
        return ts;
    }

    public void test_ext_1() {
        IndexBuilderNode b = new IndexBuilderNode();
        Model model = ModelFactory.createDefaultModel();
        Resource r = model.createResource("http://example/r");
        b.index((RDFNode)r, "foo");
        b.closeWriter();
        IndexLARQ index = b.getIndex();
        NodeIterator nIter = index.searchModelByIndex("foo");
        TestLARQ1.assertEquals((int)1, (int)TestLARQUtils.count((Iterator)nIter));
        nIter = index.searchModelByIndex("foo");
        Resource r2 = (Resource)nIter.nextNode();
        TestLARQ1.assertEquals((Object)r, (Object)r2);
    }

    public void test_ext_2() {
        IndexBuilderNode b = new IndexBuilderNode();
        Model model = ModelFactory.createDefaultModel();
        Literal lit = model.createLiteral("example");
        b.index((RDFNode)lit, "foo");
        b.closeWriter();
        IndexLARQ index = b.getIndex();
        NodeIterator nIter = index.searchModelByIndex("foo");
        TestLARQ1.assertEquals((int)1, (int)TestLARQUtils.count((Iterator)nIter));
        nIter = index.searchModelByIndex("foo");
        Literal lit2 = (Literal)nIter.nextNode();
        TestLARQ1.assertEquals((Object)lit, (Object)lit2);
    }

    public void test_ext_3() {
        IndexBuilderNode b = new IndexBuilderNode();
        Model model = ModelFactory.createDefaultModel();
        Resource bnode = model.createResource();
        b.index((RDFNode)bnode, "foo");
        b.closeWriter();
        IndexLARQ index = b.getIndex();
        NodeIterator nIter = index.searchModelByIndex("foo");
        TestLARQ1.assertEquals((int)1, (int)TestLARQUtils.count((Iterator)nIter));
        nIter = index.searchModelByIndex("foo");
        Resource bnode2 = (Resource)nIter.nextNode();
        TestLARQ1.assertEquals((Object)bnode, (Object)bnode2);
        TestLARQ1.assertTrue((boolean)bnode2.isAnon());
    }

    public void test_ext_4() {
        IndexBuilderNode b = new IndexBuilderNode();
        Model model = ModelFactory.createDefaultModel();
        Resource r = model.createResource("http://example/r");
        b.index((RDFNode)r, "foo");
        b.closeWriter();
        IndexLARQ index = b.getIndex();
        NodeIterator nIter = index.searchModelByIndex("bah");
        TestLARQ1.assertFalse((boolean)nIter.hasNext());
    }

    public void test_ext_5() {
        IndexBuilderNode b = new IndexBuilderNode();
        Model model = ModelFactory.createDefaultModel();
        Resource r = model.createResource("http://example/r");
        StringReader sr = new StringReader("foo");
        b.index((RDFNode)r, (Reader)sr);
        b.closeWriter();
        IndexLARQ index = b.getIndex();
        NodeIterator nIter = index.searchModelByIndex("foo");
        TestLARQ1.assertEquals((int)1, (int)TestLARQUtils.count((Iterator)nIter));
        nIter = index.searchModelByIndex("foo");
        Resource r2 = (Resource)nIter.nextNode();
        TestLARQ1.assertEquals((Object)r, (Object)r2);
    }

    public void test_ext_6() {
        IndexBuilderNode b = new IndexBuilderNode();
        Model model = ModelFactory.createDefaultModel();
        Resource r1 = model.createResource("http://example/r1");
        Resource r2 = model.createResource("http://example/r2");
        StringReader sr = new StringReader("R1");
        b.index((RDFNode)r1, (Reader)sr);
        IndexLARQ index = b.getIndex();
        NodeIterator nIter = index.searchModelByIndex("R1");
        TestLARQ1.assertEquals((int)1, (int)TestLARQUtils.count((Iterator)nIter));
        nIter = index.searchModelByIndex("R2");
        TestLARQ1.assertEquals((int)0, (int)TestLARQUtils.count((Iterator)nIter));
        b.index((RDFNode)r2, (Reader)new StringReader("R2"));
        nIter = index.searchModelByIndex("R2");
        TestLARQ1.assertEquals((int)0, (int)TestLARQUtils.count((Iterator)nIter));
        index = b.getIndex();
        nIter = index.searchModelByIndex("R2");
        TestLARQ1.assertEquals((int)1, (int)TestLARQUtils.count((Iterator)nIter));
    }

    public void test_index_literal_1() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString());
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        TestLARQ1.assertEquals((int)3, (int)TestLARQUtils.count((Iterator)nIter));
        index.close();
    }

    public void test_index_literal_2() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString(DC.title));
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        TestLARQ1.assertEquals((int)2, (int)TestLARQUtils.count((Iterator)nIter));
    }

    public void test_index_literal_3() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString());
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        while (nIter.hasNext()) {
            RDFNode n = nIter.nextNode();
            TestLARQ1.assertTrue((boolean)(n instanceof Literal));
            TestLARQ1.assertTrue((boolean)model.contains(null, null, n));
            boolean b = model.contains(null, DC.title, n) || model.contains(null, RDFS.label, n);
            TestLARQ1.assertTrue((String)"DC.title or RDFS.label", (boolean)b);
        }
    }

    public void test_index_literal_4() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString(DC.title));
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        while (nIter.hasNext()) {
            RDFNode n = nIter.nextNode();
            TestLARQ1.assertTrue((boolean)(n instanceof Literal));
            TestLARQ1.assertTrue((boolean)model.contains(null, DC.title, n));
            TestLARQ1.assertFalse((boolean)model.contains(null, RDFS.label, n));
        }
    }

    public void test_index_subject_1() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderSubject());
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        TestLARQ1.assertEquals((int)3, (int)TestLARQUtils.count((Iterator)nIter));
    }

    public void test_index_subject_2() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderSubject(DC.title));
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        TestLARQ1.assertEquals((int)2, (int)TestLARQUtils.count((Iterator)nIter));
    }

    public void test_index_subject_3() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderSubject());
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        while (nIter.hasNext()) {
            RDFNode n = nIter.nextNode();
            TestLARQ1.assertTrue((boolean)(n instanceof Resource));
            TestLARQ1.assertTrue((boolean)model.contains((Resource)n, null, (RDFNode)null));
            boolean b = model.contains((Resource)n, DC.title, (RDFNode)null) || model.contains((Resource)n, RDFS.label, (RDFNode)null);
            TestLARQ1.assertTrue((String)"subject with DC.title or RDFS.label", (boolean)b);
        }
    }

    public void test_index_subject_4() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderSubject(DC.title));
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        while (nIter.hasNext()) {
            RDFNode n = nIter.nextNode();
            TestLARQ1.assertTrue((boolean)(n instanceof Resource));
            TestLARQ1.assertTrue((boolean)model.contains((Resource)n, null, (RDFNode)null));
            TestLARQ1.assertTrue((boolean)model.contains((Resource)n, DC.title, (RDFNode)null));
        }
    }

    public void test_negative_1() {
        IndexLARQ index = TestLARQUtils.createIndex(datafile, (IndexBuilderModel)new IndexBuilderString());
        TestLARQ1.assertFalse((boolean)index.hasMatch("+iceberg"));
    }

    public void test_negative_2() {
        IndexLARQ index = TestLARQUtils.createIndex(datafile, (IndexBuilderModel)new IndexBuilderString(DC.title));
        TestLARQ1.assertFalse((boolean)index.hasMatch("+iceberg"));
    }

    public void test_negative_3() {
        IndexLARQ index = TestLARQUtils.createIndex(datafile, (IndexBuilderModel)new IndexBuilderSubject());
        TestLARQ1.assertFalse((boolean)index.hasMatch("+iceberg"));
    }

    public void test_negative_4() {
        IndexLARQ index = TestLARQUtils.createIndex(datafile, (IndexBuilderModel)new IndexBuilderSubject(DC.title));
        TestLARQ1.assertFalse((boolean)index.hasMatch("+iceberg"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_textMatches_index_registration_1() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString());
        TestLARQ1.assertFalse((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
        try {
            LARQ.setDefaultIndex((IndexLARQ)index);
            TestLARQ1.assertTrue((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
            QueryExecution qExec = TestLARQUtils.query(model, "{ ?lit pf:textMatch '+document' }");
            ResultSet rs = qExec.execSelect();
            TestLARQ1.assertEquals((int)3, (int)TestLARQUtils.count(rs));
            qExec.close();
            index.close();
            LARQ.removeDefaultIndex();
            TestLARQ1.assertFalse((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
        }
        finally {
            LARQ.removeDefaultIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_textMatches_index_registration_2() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString());
        TestLARQ1.assertFalse((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
        QueryExecution qExec = TestLARQUtils.query(model, "{ ?lit pf:textMatch '+document' }");
        try {
            LARQ.setDefaultIndex((Context)qExec.getContext(), (IndexLARQ)index);
            TestLARQ1.assertFalse((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
            TestLARQ1.assertTrue((boolean)qExec.getContext().isDefined(LARQ.indexKey));
            ResultSet rs = qExec.execSelect();
            TestLARQ1.assertEquals((int)3, (int)TestLARQUtils.count(rs));
            qExec.close();
            index.close();
            LARQ.removeDefaultIndex((Context)qExec.getContext());
            TestLARQ1.assertFalse((boolean)qExec.getContext().isDefined(LARQ.indexKey));
            TestLARQ1.assertFalse((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
        }
        finally {
            LARQ.removeDefaultIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_larq_example_1() throws Exception {
        PrintStream pOut = System.out;
        PrintStream pNull = new PrintStream(new ByteArrayOutputStream());
        System.setOut(pNull);
        try {
            ExLucene1.main(null);
        }
        finally {
            System.setOut(pOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_larq_example_2() throws Exception {
        PrintStream pOut = System.out;
        PrintStream pNull = new PrintStream(new ByteArrayOutputStream());
        System.setOut(pNull);
        try {
            ExLucene2.main(null);
        }
        finally {
            System.setOut(pOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_larq_example_3() throws Exception {
        PrintStream pOut = System.out;
        PrintStream pNull = new PrintStream(new ByteArrayOutputStream());
        System.setOut(pNull);
        try {
            ExLucene3.main(null);
        }
        finally {
            System.setOut(pOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_larq_example_4() throws Exception {
        PrintStream pOut = System.out;
        PrintStream pNull = new PrintStream(new ByteArrayOutputStream());
        System.setOut(pNull);
        try {
            ExLucene4.main(null);
        }
        finally {
            System.setOut(pOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_larq_example_5() throws Exception {
        PrintStream pOut = System.out;
        PrintStream pNull = new PrintStream(new ByteArrayOutputStream());
        System.setOut(pNull);
        try {
            ExLucene5.main(null);
        }
        finally {
            System.setOut(pOut);
        }
    }
}

