/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprTypeException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeFunctions;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.vocabulary.XSD;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestNodeFunctions
extends TestCase {
    private static final double accuracyExact = 0.0;
    private static final double accuracyClose = 1.0E-6;

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestNodeFunctions.class);
        ts.setName(Utils.classShortName((Class)TestNodeFunctions.class));
        return ts;
    }

    public void testSameTerm1() {
        Node n1 = Node.createLiteral((String)"xyz");
        Node n2 = Node.createLiteral((String)"xyz");
        TestNodeFunctions.assertTrue((boolean)NodeFunctions.sameTerm((Node)n1, (Node)n2));
    }

    public void testSameTerm2() {
        Node n1 = Node.createLiteral((String)"xyz");
        Node n2 = Node.createLiteral((String)"abc");
        TestNodeFunctions.assertFalse((boolean)NodeFunctions.sameTerm((Node)n1, (Node)n2));
    }

    public void testSameTerm3() {
        Node n1 = Node.createLiteral((String)"xyz");
        Node n2 = Node.createURI((String)"xyz");
        TestNodeFunctions.assertFalse((boolean)NodeFunctions.sameTerm((Node)n1, (Node)n2));
    }

    public void testSameTerm4() {
        Node n1 = Node.createLiteral((String)"xyz");
        Node n2 = Node.createLiteral((String)"xyz", null, (RDFDatatype)XSDDatatype.XSDstring);
        TestNodeFunctions.assertFalse((boolean)NodeFunctions.sameTerm((Node)n1, (Node)n2));
    }

    public void testSameTerm5() {
        Node n1 = Node.createLiteral((String)"xyz", (String)"en", null);
        Node n2 = Node.createLiteral((String)"xyz", null, null);
        TestNodeFunctions.assertFalse((boolean)NodeFunctions.sameTerm((Node)n1, (Node)n2));
    }

    public void testSameTerm6() {
        Node n1 = Node.createLiteral((String)"xyz", (String)"en", null);
        Node n2 = Node.createLiteral((String)"xyz", (String)"EN", null);
        TestNodeFunctions.assertTrue((boolean)NodeFunctions.sameTerm((Node)n1, (Node)n2));
    }

    public void testRDFtermEquals1() {
        Node n1 = Node.createURI((String)"xyz");
        Node n2 = Node.createLiteral((String)"xyz", null, null);
        TestNodeFunctions.assertFalse((boolean)NodeFunctions.rdfTermEquals((Node)n1, (Node)n2));
    }

    public void testRDFtermEquals3() {
        Node n1 = Node.createLiteral((String)"xyz");
        Node n2 = Node.createLiteral((String)"xyz", (String)"en", null);
        try {
            NodeFunctions.rdfTermEquals((Node)n1, (Node)n2);
            TestNodeFunctions.fail((String)"Expected an exception from rdfTermEquals");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    public void testRDFtermEquals2() {
        Node n1 = Node.createLiteral((String)"xyz", (String)"en", null);
        Node n2 = Node.createLiteral((String)"xyz", (String)"EN", null);
        TestNodeFunctions.assertTrue((boolean)NodeFunctions.rdfTermEquals((Node)n1, (Node)n2));
    }

    public void testStr1() {
        NodeValue nv = NodeValue.makeNodeInteger((long)56L);
        NodeValue s = NodeFunctions.str((NodeValue)nv);
        TestNodeFunctions.assertEquals((String)"56", (String)s.getString());
    }

    public void testStr2() {
        NodeValue nv = NodeValue.makeInteger((long)56L);
        NodeValue s = NodeFunctions.str((NodeValue)nv);
        TestNodeFunctions.assertEquals((String)"56", (String)s.getString());
    }

    public void testStr3() {
        NodeValue nv = NodeValue.makeNode((String)"abc", (String)"fr", (String)null);
        NodeValue s = NodeFunctions.str((NodeValue)nv);
        TestNodeFunctions.assertEquals((String)"abc", (String)s.getString());
    }

    public void testStr4() {
        Node n = Node.createAnon();
        try {
            String s = NodeFunctions.str((Node)n);
            TestNodeFunctions.fail((String)"Expect a type exception but call succeeded");
        }
        catch (ExprTypeException exprTypeException) {
            // empty catch block
        }
    }

    public void testDatatype1() {
        NodeValue nv = NodeValue.makeInteger((long)5L);
        Node n = nv.asNode();
        Node r = NodeFunctions.datatype((Node)n);
        TestNodeFunctions.assertEquals((Object)XSD.integer.asNode(), (Object)r);
    }

    public void testDatatype2() {
        NodeValue nv = NodeValue.makeInteger((long)5L);
        NodeValue r = NodeFunctions.datatype((NodeValue)nv);
        NodeValue e = NodeValue.makeNode((Node)XSD.integer.asNode());
        TestNodeFunctions.assertEquals((Object)e, (Object)r);
    }

    public void testDatatype3() {
        NodeValue nv = NodeValue.makeString((String)"abc");
        NodeValue r = NodeFunctions.datatype((NodeValue)nv);
        NodeValue e = NodeValue.makeNode((Node)XSD.xstring.asNode());
        TestNodeFunctions.assertEquals((Object)e, (Object)r);
    }

    public void testDatatype4() {
        NodeValue nv = NodeValue.makeNode((String)"abc", (String)"fr", (String)null);
        try {
            NodeValue r = NodeFunctions.datatype((NodeValue)nv);
            TestNodeFunctions.fail((String)"Expect a type exception but call succeeded");
        }
        catch (ExprTypeException exprTypeException) {
            // empty catch block
        }
    }

    public void testDatatype5() {
        try {
            NodeValue nv = NodeValue.makeNode((Node)Node.createURI((String)"http://example"));
            NodeValue r = NodeFunctions.datatype((NodeValue)nv);
            TestNodeFunctions.fail((String)"Expect a type exception but call succeeded");
        }
        catch (ExprTypeException exprTypeException) {
            // empty catch block
        }
    }

    public void testDatatype6() {
        NodeValue nv = NodeValue.makeNode((Node)Node.createAnon());
        try {
            NodeValue r = NodeFunctions.datatype((NodeValue)nv);
            TestNodeFunctions.fail((String)"Expect a type exception but call succeeded");
        }
        catch (ExprTypeException exprTypeException) {
            // empty catch block
        }
    }

    public void testLang1() {
        Node n = Node.createLiteral((String)"abc", (String)"en-gb", null);
        TestNodeFunctions.assertEquals((String)"en-gb", (String)NodeFunctions.lang((Node)n));
    }

    public void testLang2() {
        NodeValue nv = NodeValue.makeNode((String)"abc", (String)"en", (String)null);
        NodeValue r = NodeFunctions.lang((NodeValue)nv);
        NodeValue e = NodeValue.makeString((String)"en");
        TestNodeFunctions.assertEquals((Object)e, (Object)r);
    }

    public void testLang3() {
        NodeValue nv = NodeValue.makeInteger((long)5L);
        NodeValue r = NodeFunctions.lang((NodeValue)nv);
        NodeValue e = NodeValue.makeString((String)"");
        TestNodeFunctions.assertEquals((Object)e, (Object)r);
    }

    public void testLang4() {
        NodeValue nv = NodeValue.makeNode((Node)Node.createLiteral((String)"simple"));
        NodeValue r = NodeFunctions.lang((NodeValue)nv);
        NodeValue e = NodeValue.makeString((String)"");
        TestNodeFunctions.assertEquals((Object)e, (Object)r);
    }

    public void testLang5() {
        NodeValue nv = NodeValue.makeNode((Node)Node.createURI((String)"http://example/"));
        try {
            NodeValue r = NodeFunctions.lang((NodeValue)nv);
            TestNodeFunctions.fail((String)"Expect a type exception but call succeeded");
        }
        catch (ExprTypeException exprTypeException) {
            // empty catch block
        }
    }

    public void testLangMatches1() {
        NodeValue nv = NodeValue.makeString((String)"en");
        NodeValue pat = NodeValue.makeString((String)"en");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        TestNodeFunctions.assertEquals((Object)NodeValue.TRUE, (Object)r);
        TestNodeFunctions.assertFalse((boolean)NodeValue.FALSE.equals((Object)r));
    }

    public void testLangMatches2() {
        NodeValue nv = NodeValue.makeString((String)"en");
        NodeValue pat = NodeValue.makeString((String)"fr");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        TestNodeFunctions.assertEquals((Object)NodeValue.FALSE, (Object)r);
        TestNodeFunctions.assertFalse((boolean)NodeValue.TRUE.equals((Object)r));
    }

    public void testLangMatches3() {
        NodeValue nv = NodeValue.makeString((String)"en-gb");
        NodeValue pat = NodeValue.makeString((String)"en-gb");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        TestNodeFunctions.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    public void testLangMatches4() {
        NodeValue nv = NodeValue.makeString((String)"en-gb");
        NodeValue pat = NodeValue.makeString((String)"en");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        TestNodeFunctions.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    public void testLangMatches5() {
        NodeValue nv = NodeValue.makeString((String)"abc");
        NodeValue pat = NodeValue.makeString((String)"*");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        TestNodeFunctions.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    public void testLangMatches6() {
        NodeValue nv = NodeValue.makeString((String)"x-y-z");
        NodeValue pat = NodeValue.makeString((String)"x");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        TestNodeFunctions.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    public void testLangMatches7() {
        NodeValue nv = NodeValue.makeString((String)"x");
        NodeValue pat = NodeValue.makeString((String)"x-y-z");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        TestNodeFunctions.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    public void testLangMatches8() {
        NodeValue nv = NodeValue.makeString((String)"");
        NodeValue pat = NodeValue.makeString((String)"*");
        NodeValue r = NodeFunctions.langMatches((NodeValue)nv, (NodeValue)pat);
        TestNodeFunctions.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    public void testIsIRI_1() {
        NodeValue nv = NodeValue.makeNode((Node)Node.createURI((String)"http://example/"));
        NodeValue r = NodeFunctions.isIRI((NodeValue)nv);
        TestNodeFunctions.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    public void testIsIRI_2() {
        NodeValue nv = NodeValue.makeNode((Node)Node.createLiteral((String)"http://example/"));
        NodeValue r = NodeFunctions.isIRI((NodeValue)nv);
        TestNodeFunctions.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    public void testIsBlank1() {
        NodeValue nv = NodeValue.makeNode((Node)Node.createAnon());
        NodeValue r = NodeFunctions.isBlank((NodeValue)nv);
        TestNodeFunctions.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    public void testIsBlank2() {
        NodeValue nv = NodeValue.makeNode((Node)Node.createLiteral((String)"xyz"));
        NodeValue r = NodeFunctions.isBlank((NodeValue)nv);
        TestNodeFunctions.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    public void testIsBlank3() {
        NodeValue nv = NodeValue.makeNode((Node)Node.createURI((String)"http://example/"));
        NodeValue r = NodeFunctions.isBlank((NodeValue)nv);
        TestNodeFunctions.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }

    public void testIsLiteral1() {
        NodeValue nv = NodeValue.makeNode((Node)Node.createLiteral((String)"xyz"));
        NodeValue r = NodeFunctions.isLiteral((NodeValue)nv);
        TestNodeFunctions.assertEquals((Object)NodeValue.TRUE, (Object)r);
    }

    public void testIsLiteral2() {
        NodeValue nv = NodeValue.makeNode((Node)Node.createURI((String)"http://example/"));
        NodeValue r = NodeFunctions.isLiteral((NodeValue)nv);
        TestNodeFunctions.assertEquals((Object)NodeValue.FALSE, (Object)r);
    }
}

