/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.path.Path;
import com.hp.hpl.jena.sparql.path.PathEval;
import com.hp.hpl.jena.sparql.path.PathParser;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderPath;
import com.hp.hpl.jena.sparql.sse.writers.WriterPath;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPath
extends TestCase {
    static Graph graph1 = GraphUtils.makeDefaultGraph();
    static Graph graph2 = GraphUtils.makeDefaultGraph();
    static Node n1 = Node.createURI((String)"n1");
    static Node n2 = Node.createURI((String)"n2");
    static Node n3 = Node.createURI((String)"n3");
    static Node n4 = Node.createURI((String)"n4");
    static Node p = Node.createURI((String)"http://example/p");
    static Node q = Node.createURI((String)"http://example/q");
    static PrefixMapping pmap = new PrefixMappingImpl();

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestPath.class);
        ts.setName(Utils.classShortName((Class)TestPath.class));
        return ts;
    }

    public void testParsePath_01() {
        this.parse(":p");
    }

    public void testParsePath_02() {
        this.parse("(:p)");
    }

    public void testParsePath_03() {
        this.parse("^:p");
    }

    public void testParsePath_04() {
        this.parse(":p*");
    }

    public void testParsePath_05() {
        this.parse(":p+");
    }

    public void testParsePath_06() {
        this.parse(":p?");
    }

    public void testParsePath_10() {
        this.parse(":p/:q");
    }

    public void testParsePath_11() {
        this.parse(":p|:q");
    }

    public void testParsePath_12() {
        this.parse(":p{1}");
    }

    public void testParsePath_13() {
        this.parse(":p{1,}");
    }

    public void testParsePath_14() {
        this.parse(":p{1,2}");
    }

    public void testParsePath_15() {
        this.parse(":p^:q");
    }

    public void testParsePath_16() {
        this.parse("^:p^:q");
    }

    public void testParsePath_17() {
        this.parse("^:p/:q");
    }

    public void testParsePath_18() {
        this.parse("^(:p/:q)");
    }

    public void testParsePath_19() {
        this.parse("^(:p^:q)");
    }

    public void testParsePath_20() {
        this.parse(":p^(:q/:r)");
    }

    public void testParsePathErr_01() {
        this.parse("", false);
    }

    public void testParsePathErr_02() {
        this.parse("()", false);
    }

    public void testParsePathErr_03() {
        this.parse(":p :q", false);
    }

    public void testParseEquals_1() {
        TestPath.parse("(:p)", ":p");
    }

    public void testParseEquals_2() {
        TestPath.parse(":p/(:q/:r)", ":p/:q/:r");
    }

    public void testParseEquals_3() {
        TestPath.parse("(:p/:q)|:r", ":p/:q|:r");
    }

    public void testParseEquals_4() {
        TestPath.parse(":p|(:q/:r)", ":p|:q/:r");
    }

    public void testParseEquals_5() {
        TestPath.parse("^:p/:q", "(^:p)/:q");
    }

    private void parse(String string) {
        this.parse(string, true);
    }

    private void parse(String string, boolean expectLegal) {
        Prologue prologue = new Prologue(pmap);
        Path p = null;
        try {
            p = PathParser.parse((String)string, (Prologue)prologue);
            if (!expectLegal) {
                TestPath.fail((String)("Expected error; " + string));
            }
        }
        catch (QueryParseException ex) {
            if (expectLegal) {
                TestPath.fail((String)("Expected success: " + string + ": " + ex.getMessage()));
            }
            return;
        }
        String x = p.toString(prologue);
        Path p2 = PathParser.parse((String)x, (Prologue)prologue);
        TestPath.assertEquals((Object)p, (Object)p2);
        String sse2 = WriterPath.asString((Path)p, (Prologue)prologue);
        Item item = SSE.parseItem((String)sse2, (PrefixMapping)pmap);
        p2 = BuilderPath.buildPath((Item)item);
        TestPath.assertEquals((Object)p, (Object)p2);
    }

    private static void parse(String path1, String path2) {
        Prologue prologue = new Prologue(pmap);
        Path p1 = PathParser.parse((String)path1, (Prologue)prologue);
        Path p2 = PathParser.parse((String)path2, (Prologue)prologue);
        TestPath.assertEquals((Object)p1, (Object)p2);
    }

    public void testPath_01() {
        TestPath.test(graph1, n1, ":p", new Node[]{n2});
    }

    public void testPath_02() {
        TestPath.test(graph1, n1, ":p{0}", new Node[]{n1});
    }

    public void testPath_03() {
        TestPath.test(graph1, n1, ":p{1}", new Node[]{n2});
    }

    public void testPath_04() {
        TestPath.test(graph1, n1, ":p{2}", new Node[]{n3});
    }

    public void testPath_05() {
        TestPath.test(graph1, n1, ":p{0,1}", new Node[]{n1, n2});
    }

    public void testPath_06() {
        TestPath.test(graph1, n1, ":p{0,2}", new Node[]{n1, n2, n3});
    }

    public void testPath_07() {
        TestPath.test(graph1, n1, ":p{1,2}", new Node[]{n2, n3});
    }

    public void testPath_08() {
        TestPath.test(graph1, n1, ":p{9,9}", new Node[0]);
    }

    public void testPath_09() {
        TestPath.test(graph1, n1, ":p{0,9}", new Node[]{n1, n2, n3, n4});
    }

    public void testPath_10() {
        TestPath.test(graph1, n1, ":p*", new Node[]{n1, n2, n3, n4});
    }

    public void testPath_11() {
        TestPath.test(graph1, n1, ":p+", new Node[]{n2, n3, n4});
    }

    public void testPath_12() {
        TestPath.test(graph1, n1, ":p?", new Node[]{n1, n2});
    }

    public void testPath_13() {
        TestPath.test(graph1, n1, ":p/:p", new Node[]{n3});
    }

    public void testPath_14() {
        TestPath.test(graph1, n2, "^:p", new Node[]{n1});
    }

    public void testPath_15() {
        TestPath.test(graph1, n2, "^:p^:p", new Node[0]);
    }

    public void testPath_16() {
        TestPath.test(graph1, n4, "^:p^:p", new Node[]{n2});
    }

    public void testPath_17() {
        TestPath.test(graph1, n4, "^(:p/:p)", new Node[]{n2});
    }

    public void testPath_18() {
        TestPath.test(graph1, n2, "^:p/:p", new Node[]{n2});
    }

    public void testPath_20() {
        TestPath.test(graph2, n1, ":p", new Node[]{n2, n3});
    }

    public void testPath_21() {
        TestPath.test(graph2, n1, ":p/:q", new Node[]{n4});
    }

    public void testPath_22() {
        TestPath.test(graph2, n2, "^:p|:q", new Node[]{n1, n4});
    }

    public void testPath_23() {
        TestPath.test(graph2, n2, "^(:p|^:q)*", new Node[]{n1, n2, n4});
    }

    public void testPath_24() {
        TestPath.testReverse(graph1, n2, ":p", new Node[]{n1});
    }

    public void testPath_25() {
        TestPath.testReverse(graph1, n3, ":p/:p", new Node[]{n1});
    }

    private static void test(Graph graph, Node start, String string, Node[] expectedNodes) {
        TestPath.test(graph, start, string, expectedNodes, true);
    }

    private static void testReverse(Graph graph, Node start, String string, Node[] expectedNodes) {
        TestPath.test(graph, start, string, expectedNodes, false);
    }

    private static void test(Graph graph, Node start, String string, Node[] expectedNodes, boolean directionForward) {
        Path p = PathParser.parse((String)string, (PrefixMapping)pmap);
        Iterator resultsIter = directionForward ? PathEval.eval((Graph)graph, (Node)start, (Path)p) : PathEval.evalReverse((Graph)graph, (Node)start, (Path)p);
        HashSet<Node> results = new HashSet<Node>();
        while (resultsIter.hasNext()) {
            results.add((Node)resultsIter.next());
        }
        HashSet<Node> expected = new HashSet<Node>(Arrays.asList(expectedNodes));
        TestPath.assertEquals(expected, results);
    }

    static {
        pmap.setNsPrefixes(PrefixMapping.Standard);
        pmap.setNsPrefix("", "http://example/");
        graph1.add(new Triple(n1, p, n2));
        graph1.add(new Triple(n2, p, n3));
        graph1.add(new Triple(n3, p, n4));
        graph2.add(new Triple(n1, p, n2));
        graph2.add(new Triple(n1, p, n3));
        graph2.add(new Triple(n2, q, n4));
        graph2.add(new Triple(n3, q, n4));
    }
}

