/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpLabel;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderNode;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSSE_Builder
extends TestCase {
    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestSSE_Builder.class);
        ts.setName("SSE Op");
        return ts;
    }

    public void test_01() {
        SSE.parseTriple((String)"[triple ?s ?p ?o]");
    }

    public void test_02() {
        SSE.parseTriple((String)"[?s ?p ?o]");
    }

    public void test_03() {
        SSE.parseTriple((String)"[?s ?p ?o]");
    }

    public void test_04() {
        SSE.parseTriple((String)"(?s ?p ?o)");
    }

    public void test_05() {
        SSE.parseQuad((String)"(_ ?s ?p ?o)");
    }

    public void test_06() {
        SSE.parseQuad((String)"(quad _ ?s ?p ?o)");
    }

    public void test_07() {
        SSE.parseExpr((String)"1");
    }

    public void test_08() {
        SSE.parseExpr((String)"(+ 1 2)");
    }

    public void testOp_01() {
        TestSSE_Builder.opSame("(null)");
    }

    public void testOp_02() {
        TestSSE_Builder.opSame("(null)", (Op)OpNull.create());
    }

    public void testOp_03() {
        TestSSE_Builder.opSame("(bgp [triple ?s ?p ?o])");
    }

    public void testOp_04() {
        TestSSE_Builder.opSame("(label 'ABC' (table unit))", OpLabel.create((Object)"ABC", (Op)OpTable.unit()));
    }

    private static void opSame(String str) {
        TestSSE_Builder.opSame(str, SSE.parseOp((String)str));
    }

    private static void opSame(String str, Op other) {
        Op op = SSE.parseOp((String)str);
        TestSSE_Builder.assertEquals((Object)op, (Object)other);
    }

    public void testBuildInt_01() {
        Item item = SSE.parseItem((String)"1");
        int i = BuilderNode.buildInt((Item)item);
        TestSSE_Builder.assertEquals((int)1, (int)i);
    }

    public void testBuildInt_02() {
        Item item = SSE.parseItem((String)"1");
        int i = BuilderNode.buildInt((Item)item, (int)23);
        TestSSE_Builder.assertEquals((int)1, (int)i);
    }

    public void testBuildInt_03() {
        Item item = SSE.parseItem((String)"_");
        int i = BuilderNode.buildInt((Item)item, (int)23);
        TestSSE_Builder.assertEquals((int)23, (int)i);
    }
}

