/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites.optimizer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.optimizer.Optimizer;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Constants;
import com.hp.hpl.jena.sparql.suites.optimizer.Util;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestEnabled
extends TestCase {
    private static Triple triple1 = null;
    private static Triple triple2 = null;
    private static Model model = null;
    private static final String testDataFileName = "testing/Optimizer/Test-data.n3";

    public TestEnabled(String title) {
        super(title);
    }

    protected static void oneTimeSetUp() {
        triple1 = new Triple((Node)Var.alloc((String)"x"), RDFS.label.asNode(), (Node)Var.alloc((String)"y"));
        triple2 = new Triple((Node)Var.alloc((String)"x"), RDF.type.asNode(), RDFS.Class.asNode());
        model = Util.readModel(testDataFileName);
    }

    protected static void oneTimeTearDown() {
        model.close();
    }

    public void testDefaultEnabled() {
        this.isEnabled();
    }

    public void testDisable() {
        Optimizer.enable();
        Optimizer.disable();
        this.isDisabled();
    }

    public void testEnable() {
        Optimizer.disable();
        Optimizer.enable();
        this.isEnabled();
    }

    public static Test suite() {
        TestSuite ts = new TestSuite("TestEnabled");
        ts.addTest((Test)new TestEnabled("testDefaultEnabled"));
        ts.addTest((Test)new TestEnabled("testDisable"));
        ts.addTest((Test)new TestEnabled("testEnable"));
        TestSetup wrapper = new TestSetup((Test)ts){

            protected void setUp() {
                TestEnabled.oneTimeSetUp();
            }

            protected void tearDown() {
                TestEnabled.oneTimeTearDown();
            }
        };
        return wrapper;
    }

    private void isEnabled() {
        QueryExecution qe = this.runQuery(this.getQuery());
        Boolean isEnabled = (Boolean)qe.getContext().get(Constants.isEnabled);
        if (isEnabled != null) {
            TestEnabled.assertTrue((isEnabled == true ? 1 : 0) != 0);
        } else {
            TestEnabled.assertTrue((boolean)false);
        }
        qe.close();
    }

    private void isDisabled() {
        QueryExecution qe = this.runQuery(this.getQuery());
        Boolean isEnabled = (Boolean)qe.getContext().get(Constants.isEnabled);
        if (isEnabled != null) {
            TestEnabled.assertTrue((isEnabled == false ? 1 : 0) != 0);
        } else {
            TestEnabled.assertTrue((boolean)false);
        }
        qe.close();
    }

    private Query getQuery() {
        ElementTriplesBlock el = new ElementTriplesBlock();
        el.addTriple(triple1);
        el.addTriple(triple2);
        Query q = QueryFactory.make();
        q.setQuerySelectType();
        q.setQueryResultStar(true);
        q.setQueryPattern((Element)el);
        return q;
    }

    private QueryExecution runQuery(Query q) {
        QueryExecution qe = QueryExecutionFactory.create((Query)q, (Model)model);
        ResultSet rs = qe.execSelect();
        ResultSetFormatter.consume((ResultSet)rs);
        return qe;
    }
}

