/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites.optimizer;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.core.BasicPatternGraph;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.ProbabilityFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Constants;
import com.hp.hpl.jena.sparql.suites.optimizer.Util;
import com.hp.hpl.jena.sparql.util.Context;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestGraphOptimize
extends TestCase {
    private String heuristic;
    private BasicPattern patternIn;
    private BasicPattern patternOut;
    private static Model testsM;
    private static Model graphM;
    private static Context context;
    private static final String testDataFileName = "testing/Optimizer/Test-data.n3";
    private static final String testCaseFileName = "testing/Optimizer/TestGraphOptimize-manifest.n3";

    public TestGraphOptimize(String title, String heuristic, BasicPattern patternIn, BasicPattern patternOut) {
        super(title);
        this.heuristic = heuristic;
        this.patternIn = patternIn;
        this.patternOut = patternOut;
    }

    public void runTest() {
        BasicPatternGraph graph = new BasicPatternGraph(this.patternIn, Util.getHeuristic(this.heuristic, context, graphM.getGraph()));
        BasicPattern patternOpt = graph.optimize();
        TestGraphOptimize.assertTrue((boolean)patternOpt.equals((Object)this.patternOut));
    }

    public static void oneTimeSetUp() {
        context.set(Constants.PF, (Object)ProbabilityFactory.createDefaultModel((Model)Util.readModel(testDataFileName), null));
    }

    public static void oneTimeTearDown() {
        graphM.close();
        testsM.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Test suite() {
        TestSuite ts = new TestSuite("TestGraphOptimize");
        testsM = Util.readModel(testCaseFileName);
        graphM = Util.readModel(testDataFileName);
        QueryExecution qe = QueryExecutionFactory.create((String)TestGraphOptimize.queryTestCases(), (Model)testsM);
        try {
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution solution = rs.nextSolution();
                String title = solution.getLiteral("title").getLexicalForm();
                String heuristic = solution.getLiteral("heuristic").getLexicalForm();
                Seq patternInR = testsM.getSeq(solution.getResource("patternIn"));
                Seq patternOutR = testsM.getSeq(solution.getResource("patternOut"));
                BasicPattern patternIn = TestGraphOptimize.getBasicPattern(patternInR);
                BasicPattern patternOut = TestGraphOptimize.getBasicPattern(patternOutR);
                ts.addTest((Test)new TestGraphOptimize(title, heuristic, patternIn, patternOut));
            }
        }
        finally {
            qe.close();
        }
        TestSetup wrapper = new TestSetup((Test)ts){

            protected void setUp() {
                TestGraphOptimize.oneTimeSetUp();
            }

            protected void tearDown() {
                TestGraphOptimize.oneTimeTearDown();
            }
        };
        return wrapper;
    }

    private static BasicPattern getBasicPattern(Seq patternR) {
        BasicPattern pattern = new BasicPattern();
        NodeIterator iter = patternR.iterator();
        while (iter.hasNext()) {
            String[] triple = ((Literal)iter.next()).getLexicalForm().split(" ");
            pattern.add(new Triple(Util.createNode(triple[0]), Util.createNode(triple[1]), Util.createNode(triple[2])));
        }
        return pattern;
    }

    private static String queryTestCases() {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX dc: <http://purl.org/dc/elements/1.1/>PREFIX : <http://www.w3.org/2006/03/test-description#>SELECT ?title ?heuristic ?patternIn ?patternOut WHERE {?tc rdf:type :TestCase .?tc dc:title ?title .?tc :heuristic ?heuristic .?tc :patternIn ?patternIn .?tc :patternOut ?patternOut .}ORDER BY ASC(?title)";
    }

    static {
        context = ARQ.getContext();
    }
}

