/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.pddxml.relaxer;

import de.dfki.pddxml.relaxer.Effect;
import de.dfki.pddxml.relaxer.IRNode;
import de.dfki.pddxml.relaxer.IRVisitable;
import de.dfki.pddxml.relaxer.IRVisitor;
import de.dfki.pddxml.relaxer.Parameters;
import de.dfki.pddxml.relaxer.Precondition;
import de.dfki.pddxml.relaxer.RStack;
import de.dfki.pddxml.relaxer.UJAXP;
import de.dfki.pddxml.relaxer.URelaxer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Action
implements Serializable,
Cloneable,
IRVisitable,
IRNode {
    private String name_;
    private Parameters parameters_;
    private Precondition precondition_;
    private Effect effect_;
    private IRNode parentRNode_;

    public Action() {
        this.name_ = "";
    }

    public Action(Action source) {
        this.setup(source);
    }

    public Action(RStack stack) {
        this.setup(stack);
    }

    public Action(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Action(Element element) {
        this.setup(element);
    }

    public Action(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Action(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Action(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Action(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Action(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Action(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Action source) {
        this.setName(source.getName());
        if (source.parameters_ != null) {
            this.setParameters((Parameters)source.getParameters().clone());
        }
        if (source.precondition_ != null) {
            this.setPrecondition((Precondition)source.getPrecondition().clone());
        }
        if (source.effect_ != null) {
            this.setEffect((Effect)source.getEffect().clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.setParameters(new Parameters(stack));
        this.setPrecondition(new Precondition(stack));
        this.setEffect(new Effect(stack));
    }

    public Object clone() {
        return new Action(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("action");
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        this.parameters_.makeElement(element);
        this.precondition_.makeElement(element);
        this.effect_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final Parameters getParameters() {
        return this.parameters_;
    }

    public final void setParameters(Parameters parameters) {
        this.parameters_ = parameters;
        if (parameters != null) {
            parameters.rSetParentRNode(this);
        }
    }

    public final Precondition getPrecondition() {
        return this.precondition_;
    }

    public final void setPrecondition(Precondition precondition) {
        this.precondition_ = precondition;
        if (precondition != null) {
            precondition.rSetParentRNode(this);
        }
    }

    public final Effect getEffect() {
        return this.effect_;
    }

    public final void setEffect(Effect effect) {
        this.effect_ = effect;
        if (effect != null) {
            effect.rSetParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<action");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        buffer.append(">");
        this.parameters_.makeTextElement(buffer);
        this.precondition_.makeTextElement(buffer);
        this.effect_.makeTextElement(buffer);
        buffer.append("</action>");
    }

    public void makePddlElement(StringBuffer buffer) {
        buffer.append("(:action ");
        if (this.name_ != null) {
            String predicateName = URelaxer.escapeAttrQuot(URelaxer.getString(this.getName()));
            if (predicateName.contains("#")) {
                buffer.append(predicateName.substring(predicateName.indexOf("#") + 1));
            } else {
                buffer.append(predicateName);
            }
        }
        buffer.append(" ");
        this.parameters_.makePddlElement(buffer);
        this.precondition_.makePddlElement(buffer);
        this.effect_.makePddlElement(buffer);
        buffer.append(")");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<action");
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        buffer.write(">");
        this.parameters_.makeTextElement(buffer);
        this.precondition_.makeTextElement(buffer);
        this.effect_.makeTextElement(buffer);
        buffer.write("</action>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<action");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        buffer.print(">");
        this.parameters_.makeTextElement(buffer);
        this.precondition_.makeTextElement(buffer);
        this.effect_.makeTextElement(buffer);
        buffer.print("</action>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public boolean enter(IRVisitor visitor) {
        return visitor.enter(this);
    }

    @Override
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList<Cloneable> classNodes = new ArrayList<Cloneable>();
        if (this.parameters_ != null) {
            classNodes.add(this.parameters_);
        }
        if (this.precondition_ != null) {
            classNodes.add(this.precondition_);
        }
        if (this.effect_ != null) {
            classNodes.add(this.effect_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "action")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "name")) {
            return false;
        }
        $match$ = true;
        if (!Parameters.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        if (!Precondition.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        if (!Effect.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Action.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Action.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

