/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.pddxml.relaxer;

import de.dfki.pddxml.relaxer.Action;
import de.dfki.pddxml.relaxer.IRNode;
import de.dfki.pddxml.relaxer.IRVisitable;
import de.dfki.pddxml.relaxer.IRVisitor;
import de.dfki.pddxml.relaxer.RStack;
import de.dfki.pddxml.relaxer.UJAXP;
import de.dfki.pddxml.relaxer.URelaxer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Actions
implements Serializable,
Cloneable,
IRVisitable,
IRNode {
    private List action_ = new ArrayList();
    private IRNode parentRNode_;

    public Actions() {
    }

    public Actions(Actions source) {
        this.setup(source);
    }

    public Actions(RStack stack) {
        this.setup(stack);
    }

    public Actions(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Actions(Element element) {
        this.setup(element);
    }

    public Actions(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Actions(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Actions(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Actions(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Actions(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Actions(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Actions source) {
        this.action_.clear();
        int size = source.action_.size();
        int i = 0;
        while (i < size) {
            this.addAction((Action)source.getAction(i).clone());
            ++i;
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.action_.clear();
        while (Action.isMatch(stack)) {
            this.addAction(new Action(stack));
        }
    }

    public Object clone() {
        return new Actions(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("actions");
        int size = this.action_.size();
        int i = 0;
        while (i < size) {
            Action value = (Action)this.action_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final Action[] getAction() {
        Action[] array = new Action[this.action_.size()];
        return this.action_.toArray(array);
    }

    public final void setAction(Action[] action) {
        this.action_.clear();
        int i = 0;
        while (i < action.length) {
            this.addAction(action[i]);
            ++i;
        }
        i = 0;
        while (i < action.length) {
            action[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final void setAction(Action action) {
        this.action_.clear();
        this.addAction(action);
        if (action != null) {
            action.rSetParentRNode(this);
        }
    }

    public final void addAction(Action action) {
        this.action_.add(action);
        if (action != null) {
            action.rSetParentRNode(this);
        }
    }

    public final void addAction(Action[] action) {
        int i = 0;
        while (i < action.length) {
            this.addAction(action[i]);
            ++i;
        }
        i = 0;
        while (i < action.length) {
            action[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final int sizeAction() {
        return this.action_.size();
    }

    public final Action getAction(int index) {
        return (Action)this.action_.get(index);
    }

    public final void setAction(int index, Action action) {
        this.action_.set(index, action);
        if (action != null) {
            action.rSetParentRNode(this);
        }
    }

    public final void addAction(int index, Action action) {
        this.action_.add(index, action);
        if (action != null) {
            action.rSetParentRNode(this);
        }
    }

    public final void removeAction(int index) {
        this.action_.remove(index);
    }

    public final void removeAction(Action action) {
        this.action_.remove(action);
    }

    public final void clearAction() {
        this.action_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<actions");
        buffer.append(">");
        int size = this.action_.size();
        int i = 0;
        while (i < size) {
            Action value = (Action)this.action_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</actions>");
    }

    public void makePddlElement(StringBuffer buffer) {
        int size = this.action_.size();
        int i = 0;
        while (i < size) {
            Action value = (Action)this.action_.get(i);
            value.makePddlElement(buffer);
            ++i;
        }
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<actions");
        buffer.write(">");
        int size = this.action_.size();
        int i = 0;
        while (i < size) {
            Action value = (Action)this.action_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.write("</actions>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<actions");
        buffer.print(">");
        int size = this.action_.size();
        int i = 0;
        while (i < size) {
            Action value = (Action)this.action_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</actions>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public boolean enter(IRVisitor visitor) {
        return visitor.enter(this);
    }

    @Override
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.action_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "actions")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        while (Action.isMatchHungry(target)) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Actions.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Actions.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

