/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.pddxml.relaxer;

import de.dfki.pddxml.relaxer.Cardinality;
import de.dfki.pddxml.relaxer.Conjunction;
import de.dfki.pddxml.relaxer.Disjunction;
import de.dfki.pddxml.relaxer.Exists;
import de.dfki.pddxml.relaxer.ForAll;
import de.dfki.pddxml.relaxer.IExpressionChoice;
import de.dfki.pddxml.relaxer.IRNode;
import de.dfki.pddxml.relaxer.IRVisitable;
import de.dfki.pddxml.relaxer.IRVisitor;
import de.dfki.pddxml.relaxer.Negation;
import de.dfki.pddxml.relaxer.Predicate;
import de.dfki.pddxml.relaxer.RStack;
import de.dfki.pddxml.relaxer.UJAXP;
import de.dfki.pddxml.relaxer.URelaxer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Conditional
implements Serializable,
Cloneable,
IRVisitable,
IRNode,
IExpressionChoice {
    private IExpressionChoice expression1_;
    private IExpressionChoice expression2_;
    private IRNode parentRNode_;

    public Conditional() {
    }

    public Conditional(Conditional source) {
        this.setup(source);
    }

    public Conditional(RStack stack) {
        this.setup(stack);
    }

    public Conditional(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Conditional(Element element) {
        this.setup(element);
    }

    public Conditional(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Conditional(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Conditional(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Conditional(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Conditional(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Conditional(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Conditional source) {
        if (source.expression1_ != null) {
            this.setExpression1((IExpressionChoice)source.getExpression1().clone());
        }
        if (source.expression2_ != null) {
            this.setExpression2((IExpressionChoice)source.getExpression2().clone());
        }
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        if (Predicate.isMatch(stack)) {
            this.setExpression1(new Predicate(stack));
        } else if (Cardinality.isMatch(stack)) {
            this.setExpression1(new Cardinality(stack));
        } else if (ForAll.isMatch(stack)) {
            this.setExpression1(new ForAll(stack));
        } else if (Exists.isMatch(stack)) {
            this.setExpression1(new Exists(stack));
        } else if (Conjunction.isMatch(stack)) {
            this.setExpression1(new Conjunction(stack));
        } else if (Disjunction.isMatch(stack)) {
            this.setExpression1(new Disjunction(stack));
        } else if (Negation.isMatch(stack)) {
            this.setExpression1(new Negation(stack));
        } else if (Conditional.isMatch(stack)) {
            this.setExpression1(new Conditional(stack));
        } else {
            throw new IllegalArgumentException();
        }
        if (Predicate.isMatch(stack)) {
            this.setExpression2(new Predicate(stack));
        } else if (Cardinality.isMatch(stack)) {
            this.setExpression2(new Cardinality(stack));
        } else if (ForAll.isMatch(stack)) {
            this.setExpression2(new ForAll(stack));
        } else if (Exists.isMatch(stack)) {
            this.setExpression2(new Exists(stack));
        } else if (Conditional.isMatch(stack)) {
            this.setExpression2(new Conditional(stack));
        } else if (Conjunction.isMatch(stack)) {
            this.setExpression2(new Conjunction(stack));
        } else if (Disjunction.isMatch(stack)) {
            this.setExpression2(new Disjunction(stack));
        } else if (Negation.isMatch(stack)) {
            this.setExpression2(new Negation(stack));
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Object clone() {
        return new Conditional(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("if");
        this.expression1_.makeElement(element);
        this.expression2_.makeElement(element);
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final IExpressionChoice getExpression1() {
        return this.expression1_;
    }

    public final void setExpression1(IExpressionChoice expression1) {
        this.expression1_ = expression1;
        if (expression1 != null) {
            expression1.rSetParentRNode(this);
        }
    }

    public final IExpressionChoice getExpression2() {
        return this.expression2_;
    }

    public final void setExpression2(IExpressionChoice expression2) {
        this.expression2_ = expression2;
        if (expression2 != null) {
            expression2.rSetParentRNode(this);
        }
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<if");
        this.expression1_.makeTextAttribute(buffer);
        this.expression2_.makeTextAttribute(buffer);
        buffer.append(">");
        this.expression1_.makeTextElement(buffer);
        this.expression2_.makeTextElement(buffer);
        buffer.append("</if>");
    }

    @Override
    public void makePddlElement(StringBuffer buffer) {
        buffer.append("(when ");
        this.expression1_.makeTextAttribute(buffer);
        this.expression2_.makeTextAttribute(buffer);
        this.expression1_.makePddlElement(buffer);
        this.expression2_.makePddlElement(buffer);
        buffer.append(")");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<if");
        this.expression1_.makeTextAttribute(buffer);
        this.expression2_.makeTextAttribute(buffer);
        buffer.write(">");
        this.expression1_.makeTextElement(buffer);
        this.expression2_.makeTextElement(buffer);
        buffer.write("</if>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<if");
        this.expression1_.makeTextAttribute(buffer);
        this.expression2_.makeTextAttribute(buffer);
        buffer.print(">");
        this.expression1_.makeTextElement(buffer);
        this.expression2_.makeTextElement(buffer);
        buffer.print("</if>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public boolean enter(IRVisitor visitor) {
        return visitor.enter(this);
    }

    @Override
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList<IExpressionChoice> classNodes = new ArrayList<IExpressionChoice>();
        if (this.expression1_ != null) {
            classNodes.add(this.expression1_);
        }
        if (this.expression2_ != null) {
            classNodes.add(this.expression2_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "if")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (Predicate.isMatchHungry(target)) {
            $match$ = true;
        } else if (Cardinality.isMatchHungry(target)) {
            $match$ = true;
        } else if (ForAll.isMatchHungry(target)) {
            $match$ = true;
        } else if (Exists.isMatchHungry(target)) {
            $match$ = true;
        } else if (Conjunction.isMatchHungry(target)) {
            $match$ = true;
        } else if (Disjunction.isMatchHungry(target)) {
            $match$ = true;
        } else if (Negation.isMatchHungry(target)) {
            $match$ = true;
        } else if (Conditional.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return false;
        }
        if (Predicate.isMatchHungry(target)) {
            $match$ = true;
        } else if (Cardinality.isMatchHungry(target)) {
            $match$ = true;
        } else if (ForAll.isMatchHungry(target)) {
            $match$ = true;
        } else if (Exists.isMatchHungry(target)) {
            $match$ = true;
        } else if (Conditional.isMatchHungry(target)) {
            $match$ = true;
        } else if (Conjunction.isMatchHungry(target)) {
            $match$ = true;
        } else if (Disjunction.isMatchHungry(target)) {
            $match$ = true;
        } else if (Negation.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Conditional.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Conditional.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

