/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.pddxml.relaxer;

import de.dfki.pddxml.relaxer.Cardinality;
import de.dfki.pddxml.relaxer.Conditional;
import de.dfki.pddxml.relaxer.Conjunction;
import de.dfki.pddxml.relaxer.Exists;
import de.dfki.pddxml.relaxer.ForAll;
import de.dfki.pddxml.relaxer.IExpressionChoice;
import de.dfki.pddxml.relaxer.IRNode;
import de.dfki.pddxml.relaxer.IRVisitable;
import de.dfki.pddxml.relaxer.IRVisitor;
import de.dfki.pddxml.relaxer.Negation;
import de.dfki.pddxml.relaxer.Predicate;
import de.dfki.pddxml.relaxer.RStack;
import de.dfki.pddxml.relaxer.UJAXP;
import de.dfki.pddxml.relaxer.URelaxer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Disjunction
implements Serializable,
Cloneable,
IRVisitable,
IRNode,
IExpressionChoice {
    private List expression_ = new ArrayList();
    private IRNode parentRNode_;

    public Disjunction() {
    }

    public Disjunction(Disjunction source) {
        this.setup(source);
    }

    public Disjunction(RStack stack) {
        this.setup(stack);
    }

    public Disjunction(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Disjunction(Element element) {
        this.setup(element);
    }

    public Disjunction(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Disjunction(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Disjunction(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Disjunction(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Disjunction(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Disjunction(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Disjunction source) {
        this.expression_.clear();
        int size = source.expression_.size();
        int i = 0;
        while (i < size) {
            this.addExpression((IExpressionChoice)source.getExpression(i).clone());
            ++i;
        }
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.expression_.clear();
        while (true) {
            if (Predicate.isMatch(stack)) {
                this.addExpression(new Predicate(stack));
                continue;
            }
            if (Conditional.isMatch(stack)) {
                this.addExpression(new Conditional(stack));
                continue;
            }
            if (Cardinality.isMatch(stack)) {
                this.addExpression(new Cardinality(stack));
                continue;
            }
            if (ForAll.isMatch(stack)) {
                this.addExpression(new ForAll(stack));
                continue;
            }
            if (Exists.isMatch(stack)) {
                this.addExpression(new Exists(stack));
                continue;
            }
            if (Conjunction.isMatch(stack)) {
                this.addExpression(new Conjunction(stack));
                continue;
            }
            if (Disjunction.isMatch(stack)) {
                this.addExpression(new Disjunction(stack));
                continue;
            }
            if (!Negation.isMatch(stack)) break;
            this.addExpression(new Negation(stack));
        }
    }

    @Override
    public Object clone() {
        return new Disjunction(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("or");
        int size = this.expression_.size();
        int i = 0;
        while (i < size) {
            IExpressionChoice value = (IExpressionChoice)this.expression_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final IExpressionChoice[] getExpression() {
        IExpressionChoice[] array = new IExpressionChoice[this.expression_.size()];
        return this.expression_.toArray(array);
    }

    public final void setExpression(IExpressionChoice[] expression) {
        this.expression_.clear();
        int i = 0;
        while (i < expression.length) {
            this.addExpression(expression[i]);
            ++i;
        }
        i = 0;
        while (i < expression.length) {
            expression[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final void setExpression(IExpressionChoice expression) {
        this.expression_.clear();
        this.addExpression(expression);
        if (expression != null) {
            expression.rSetParentRNode(this);
        }
    }

    public final void addExpression(IExpressionChoice expression) {
        this.expression_.add(expression);
        if (expression != null) {
            expression.rSetParentRNode(this);
        }
    }

    public final void addExpression(IExpressionChoice[] expression) {
        int i = 0;
        while (i < expression.length) {
            this.addExpression(expression[i]);
            ++i;
        }
        i = 0;
        while (i < expression.length) {
            expression[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final int sizeExpression() {
        return this.expression_.size();
    }

    public final IExpressionChoice getExpression(int index) {
        return (IExpressionChoice)this.expression_.get(index);
    }

    public final void setExpression(int index, IExpressionChoice expression) {
        this.expression_.set(index, expression);
        if (expression != null) {
            expression.rSetParentRNode(this);
        }
    }

    public final void addExpression(int index, IExpressionChoice expression) {
        this.expression_.add(index, expression);
        if (expression != null) {
            expression.rSetParentRNode(this);
        }
    }

    public final void removeExpression(int index) {
        this.expression_.remove(index);
    }

    public final void removeExpression(IExpressionChoice expression) {
        this.expression_.remove(expression);
    }

    public final void clearExpression() {
        this.expression_.clear();
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        IExpressionChoice value;
        buffer.append("<or");
        int size = this.expression_.size();
        int i = 0;
        while (i < size) {
            value = (IExpressionChoice)this.expression_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
        buffer.append(">");
        size = this.expression_.size();
        i = 0;
        while (i < size) {
            value = (IExpressionChoice)this.expression_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</or>");
    }

    @Override
    public void makePddlElement(StringBuffer buffer) {
        int size = this.expression_.size();
        if (size == 1) {
            IExpressionChoice value;
            buffer.append(" ");
            int i = 0;
            while (i < size) {
                value = (IExpressionChoice)this.expression_.get(i);
                value.makeTextAttribute(buffer);
                ++i;
            }
            size = this.expression_.size();
            i = 0;
            while (i < size) {
                value = (IExpressionChoice)this.expression_.get(i);
                value.makePddlElement(buffer);
                ++i;
            }
        } else {
            IExpressionChoice value;
            buffer.append("(or");
            int i = 0;
            while (i < size) {
                value = (IExpressionChoice)this.expression_.get(i);
                value.makeTextAttribute(buffer);
                ++i;
            }
            size = this.expression_.size();
            i = 0;
            while (i < size) {
                value = (IExpressionChoice)this.expression_.get(i);
                value.makePddlElement(buffer);
                ++i;
            }
            buffer.append(")");
        }
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        IExpressionChoice value;
        buffer.write("<or");
        int size = this.expression_.size();
        int i = 0;
        while (i < size) {
            value = (IExpressionChoice)this.expression_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
        buffer.write(">");
        size = this.expression_.size();
        i = 0;
        while (i < size) {
            value = (IExpressionChoice)this.expression_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.write("</or>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        IExpressionChoice value;
        buffer.print("<or");
        int size = this.expression_.size();
        int i = 0;
        while (i < size) {
            value = (IExpressionChoice)this.expression_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
        buffer.print(">");
        size = this.expression_.size();
        i = 0;
        while (i < size) {
            value = (IExpressionChoice)this.expression_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</or>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public boolean enter(IRVisitor visitor) {
        return visitor.enter(this);
    }

    @Override
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.expression_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "or")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (Predicate.isMatchHungry(target)) {
            $match$ = true;
        } else if (Conditional.isMatchHungry(target)) {
            $match$ = true;
        } else if (Cardinality.isMatchHungry(target)) {
            $match$ = true;
        } else if (ForAll.isMatchHungry(target)) {
            $match$ = true;
        } else if (Exists.isMatchHungry(target)) {
            $match$ = true;
        } else if (Conjunction.isMatchHungry(target)) {
            $match$ = true;
        } else if (Disjunction.isMatchHungry(target)) {
            $match$ = true;
        } else if (Negation.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return false;
        }
        while (true) {
            if (Predicate.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (Conditional.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (Cardinality.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (ForAll.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (Exists.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (Conjunction.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (Disjunction.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (!Negation.isMatchHungry(target)) break;
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Disjunction.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Disjunction.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

