/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.pddxml.relaxer;

import de.dfki.pddxml.relaxer.Actions;
import de.dfki.pddxml.relaxer.IRNode;
import de.dfki.pddxml.relaxer.IRVisitable;
import de.dfki.pddxml.relaxer.IRVisitor;
import de.dfki.pddxml.relaxer.Predicates;
import de.dfki.pddxml.relaxer.RStack;
import de.dfki.pddxml.relaxer.Requirements;
import de.dfki.pddxml.relaxer.Types;
import de.dfki.pddxml.relaxer.UJAXP;
import de.dfki.pddxml.relaxer.URelaxer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Domain
implements Serializable,
Cloneable,
IRVisitable,
IRNode {
    private String name_;
    private Requirements requirements_;
    private Types types_;
    private Predicates predicates_;
    private Actions actions_;
    private IRNode parentRNode_;

    public Domain() {
        this.name_ = "";
    }

    public Domain(Domain source) {
        this.setup(source);
    }

    public Domain(RStack stack) {
        this.setup(stack);
    }

    public Domain(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Domain(Element element) {
        this.setup(element);
    }

    public Domain(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Domain(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Domain(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Domain(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Domain(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Domain(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Domain source) {
        this.setName(source.getName());
        if (source.requirements_ != null) {
            this.setRequirements((Requirements)source.getRequirements().clone());
        }
        if (source.types_ != null) {
            this.setTypes((Types)source.getTypes().clone());
        }
        if (source.predicates_ != null) {
            this.setPredicates((Predicates)source.getPredicates().clone());
        }
        if (source.actions_ != null) {
            this.setActions((Actions)source.getActions().clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.setRequirements(new Requirements(stack));
        this.setTypes(new Types(stack));
        this.setPredicates(new Predicates(stack));
        this.setActions(new Actions(stack));
    }

    public Object clone() {
        return new Domain(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("define_domain");
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        this.requirements_.makeElement(element);
        this.types_.makeElement(element);
        this.predicates_.makeElement(element);
        this.actions_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final Requirements getRequirements() {
        return this.requirements_;
    }

    public final void setRequirements(Requirements requirements) {
        this.requirements_ = requirements;
        if (requirements != null) {
            requirements.rSetParentRNode(this);
        }
    }

    public final Types getTypes() {
        return this.types_;
    }

    public final void setTypes(Types types) {
        this.types_ = types;
        if (types != null) {
            types.rSetParentRNode(this);
        }
    }

    public final Predicates getPredicates() {
        return this.predicates_;
    }

    public final void setPredicates(Predicates predicates) {
        this.predicates_ = predicates;
        if (predicates != null) {
            predicates.rSetParentRNode(this);
        }
    }

    public final Actions getActions() {
        return this.actions_;
    }

    public final void setActions(Actions actions) {
        this.actions_ = actions;
        if (actions != null) {
            actions.rSetParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public String makePddlDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makePddlElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<define_domain");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        buffer.append(">");
        this.requirements_.makeTextElement(buffer);
        this.types_.makeTextElement(buffer);
        this.predicates_.makeTextElement(buffer);
        this.actions_.makeTextElement(buffer);
        buffer.append("</define_domain>");
    }

    public void makePddlElement(StringBuffer buffer) {
        buffer.append("(define(domain ");
        if (this.name_ != null) {
            String domainName = URelaxer.escapeAttrQuot(URelaxer.getString(this.getName()));
            buffer.append(domainName);
            buffer.append(")");
        }
        buffer.append("(:requirements :adl :existential-preconditions :universal-preconditions)");
        this.predicates_.makePddlElement(buffer);
        this.actions_.makePddlElement(buffer);
        buffer.append(")");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<define_domain");
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        buffer.write(">");
        this.requirements_.makeTextElement(buffer);
        this.types_.makeTextElement(buffer);
        this.predicates_.makeTextElement(buffer);
        this.actions_.makeTextElement(buffer);
        buffer.write("</define_domain>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<define_domain");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        buffer.print(">");
        this.requirements_.makeTextElement(buffer);
        this.types_.makeTextElement(buffer);
        this.predicates_.makeTextElement(buffer);
        this.actions_.makeTextElement(buffer);
        buffer.print("</define_domain>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public boolean enter(IRVisitor visitor) {
        return visitor.enter(this);
    }

    @Override
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList<Cloneable> classNodes = new ArrayList<Cloneable>();
        if (this.requirements_ != null) {
            classNodes.add(this.requirements_);
        }
        if (this.types_ != null) {
            classNodes.add(this.types_);
        }
        if (this.predicates_ != null) {
            classNodes.add(this.predicates_);
        }
        if (this.actions_ != null) {
            classNodes.add(this.actions_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "define_domain")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "name")) {
            return false;
        }
        $match$ = true;
        if (!Requirements.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        if (!Types.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        if (!Predicates.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        if (!Actions.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Domain.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Domain.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

