/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.pddxml.relaxer;

import de.dfki.pddxml.relaxer.Cardinality;
import de.dfki.pddxml.relaxer.Conditional;
import de.dfki.pddxml.relaxer.Conjunction;
import de.dfki.pddxml.relaxer.Disjunction;
import de.dfki.pddxml.relaxer.ForAll;
import de.dfki.pddxml.relaxer.IExpressionChoice;
import de.dfki.pddxml.relaxer.IRNode;
import de.dfki.pddxml.relaxer.IRVisitable;
import de.dfki.pddxml.relaxer.IRVisitor;
import de.dfki.pddxml.relaxer.Negation;
import de.dfki.pddxml.relaxer.Predicate;
import de.dfki.pddxml.relaxer.RStack;
import de.dfki.pddxml.relaxer.UJAXP;
import de.dfki.pddxml.relaxer.URelaxer;
import de.dfki.pddxml.relaxer.Variables;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Exists
implements Serializable,
Cloneable,
IRVisitable,
IRNode,
IExpressionChoice {
    private Variables variables_;
    private IExpressionChoice expression_;
    private IRNode parentRNode_;

    public Exists() {
    }

    public Exists(Exists source) {
        this.setup(source);
    }

    public Exists(RStack stack) {
        this.setup(stack);
    }

    public Exists(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Exists(Element element) {
        this.setup(element);
    }

    public Exists(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Exists(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Exists(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Exists(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Exists(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Exists(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Exists source) {
        if (source.variables_ != null) {
            this.setVariables((Variables)source.getVariables().clone());
        }
        if (source.expression_ != null) {
            this.setExpression((IExpressionChoice)source.getExpression().clone());
        }
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.setVariables(new Variables(stack));
        if (Predicate.isMatch(stack)) {
            this.setExpression(new Predicate(stack));
        } else if (Conditional.isMatch(stack)) {
            this.setExpression(new Conditional(stack));
        } else if (Cardinality.isMatch(stack)) {
            this.setExpression(new Cardinality(stack));
        } else if (ForAll.isMatch(stack)) {
            this.setExpression(new ForAll(stack));
        } else if (Exists.isMatch(stack)) {
            this.setExpression(new Exists(stack));
        } else if (Conjunction.isMatch(stack)) {
            this.setExpression(new Conjunction(stack));
        } else if (Disjunction.isMatch(stack)) {
            this.setExpression(new Disjunction(stack));
        } else if (Negation.isMatch(stack)) {
            this.setExpression(new Negation(stack));
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Object clone() {
        return new Exists(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("exists");
        this.variables_.makeElement(element);
        this.expression_.makeElement(element);
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final Variables getVariables() {
        return this.variables_;
    }

    public final void setVariables(Variables variables) {
        this.variables_ = variables;
        if (variables != null) {
            variables.rSetParentRNode(this);
        }
    }

    public final IExpressionChoice getExpression() {
        return this.expression_;
    }

    public final void setExpression(IExpressionChoice expression) {
        this.expression_ = expression;
        if (expression != null) {
            expression.rSetParentRNode(this);
        }
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<exists");
        this.expression_.makeTextAttribute(buffer);
        buffer.append(">");
        this.variables_.makeTextElement(buffer);
        this.expression_.makeTextElement(buffer);
        buffer.append("</exists>");
    }

    @Override
    public void makePddlElement(StringBuffer buffer) {
        buffer.append("(exists ");
        this.expression_.makeTextAttribute(buffer);
        this.variables_.makePddlElement(buffer);
        this.expression_.makePddlElement(buffer);
        buffer.append(")");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<exists");
        this.expression_.makeTextAttribute(buffer);
        buffer.write(">");
        this.variables_.makeTextElement(buffer);
        this.expression_.makeTextElement(buffer);
        buffer.write("</exists>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<exists");
        this.expression_.makeTextAttribute(buffer);
        buffer.print(">");
        this.variables_.makeTextElement(buffer);
        this.expression_.makeTextElement(buffer);
        buffer.print("</exists>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public boolean enter(IRVisitor visitor) {
        return visitor.enter(this);
    }

    @Override
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList<IRNode> classNodes = new ArrayList<IRNode>();
        if (this.variables_ != null) {
            classNodes.add(this.variables_);
        }
        if (this.expression_ != null) {
            classNodes.add(this.expression_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "exists")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!Variables.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        if (Predicate.isMatchHungry(target)) {
            $match$ = true;
        } else if (Conditional.isMatchHungry(target)) {
            $match$ = true;
        } else if (Cardinality.isMatchHungry(target)) {
            $match$ = true;
        } else if (ForAll.isMatchHungry(target)) {
            $match$ = true;
        } else if (Exists.isMatchHungry(target)) {
            $match$ = true;
        } else if (Conjunction.isMatchHungry(target)) {
            $match$ = true;
        } else if (Disjunction.isMatchHungry(target)) {
            $match$ = true;
        } else if (Negation.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Exists.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Exists.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

