/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.pddxml.relaxer;

import de.dfki.pddxml.relaxer.Cardinality;
import de.dfki.pddxml.relaxer.Conditional;
import de.dfki.pddxml.relaxer.Conjunction;
import de.dfki.pddxml.relaxer.Disjunction;
import de.dfki.pddxml.relaxer.Exists;
import de.dfki.pddxml.relaxer.ForAll;
import de.dfki.pddxml.relaxer.IExpressionChoice;
import de.dfki.pddxml.relaxer.Negation;
import de.dfki.pddxml.relaxer.Predicate;
import de.dfki.pddxml.relaxer.RStack;
import de.dfki.pddxml.relaxer.UJAXP;
import de.dfki.pddxml.relaxer.URelaxer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class InitState
implements Serializable,
Cloneable {
    private IExpressionChoice expression_;

    public InitState() {
    }

    public InitState(InitState source) {
        this.setup(source);
    }

    public InitState(RStack stack) {
        this.setup(stack);
    }

    public InitState(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public InitState(Element element) {
        this.setup(element);
    }

    public InitState(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public InitState(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public InitState(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public InitState(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public InitState(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public InitState(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(InitState source) {
        if (source.expression_ != null) {
            this.setExpression((IExpressionChoice)source.getExpression().clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        if (Conditional.isMatch(stack)) {
            this.setExpression(new Conditional(stack));
        } else if (Predicate.isMatch(stack)) {
            this.setExpression(new Predicate(stack));
        } else if (Cardinality.isMatch(stack)) {
            this.setExpression(new Cardinality(stack));
        } else if (Conjunction.isMatch(stack)) {
            this.setExpression(new Conjunction(stack));
        } else if (Disjunction.isMatch(stack)) {
            this.setExpression(new Disjunction(stack));
        } else if (ForAll.isMatch(stack)) {
            this.setExpression(new ForAll(stack));
        } else if (Exists.isMatch(stack)) {
            this.setExpression(new Exists(stack));
        } else if (Negation.isMatch(stack)) {
            this.setExpression(new Negation(stack));
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Object clone() {
        return new InitState(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("init");
        this.expression_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final IExpressionChoice getExpression() {
        return this.expression_;
    }

    public final void setExpression(IExpressionChoice expression) {
        this.expression_ = expression;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<init");
        this.expression_.makeTextAttribute(buffer);
        buffer.append(">");
        this.expression_.makeTextElement(buffer);
        buffer.append("</init>");
    }

    public void makePddlElement(StringBuffer buffer) {
        buffer.append("(:init ");
        this.expression_.makeTextAttribute(buffer);
        this.expression_.makePddlElement(buffer);
        if (buffer.toString().contains("and")) {
            buffer.replace(buffer.indexOf("and") - 1, buffer.indexOf("and"), "");
            buffer.replace(buffer.indexOf("and"), buffer.indexOf("and") + 3, "");
        }
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<init");
        this.expression_.makeTextAttribute(buffer);
        buffer.write(">");
        this.expression_.makeTextElement(buffer);
        buffer.write("</init>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<init");
        this.expression_.makeTextAttribute(buffer);
        buffer.print(">");
        this.expression_.makeTextElement(buffer);
        buffer.print("</init>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "init")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (Conditional.isMatchHungry(target)) {
            $match$ = true;
        } else if (Predicate.isMatchHungry(target)) {
            $match$ = true;
        } else if (Cardinality.isMatchHungry(target)) {
            $match$ = true;
        } else if (Conjunction.isMatchHungry(target)) {
            $match$ = true;
        } else if (Disjunction.isMatchHungry(target)) {
            $match$ = true;
        } else if (ForAll.isMatchHungry(target)) {
            $match$ = true;
        } else if (Exists.isMatchHungry(target)) {
            $match$ = true;
        } else if (Negation.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return InitState.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (InitState.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

