/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.pddxml.relaxer;

import de.dfki.pddxml.relaxer.RStack;
import de.dfki.pddxml.relaxer.UJAXP;
import de.dfki.pddxml.relaxer.URelaxer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PDDXMLObject
implements Serializable,
Cloneable {
    private String content_;
    private String type_;

    public PDDXMLObject() {
        this.type_ = "";
    }

    public PDDXMLObject(PDDXMLObject source) {
        this.setup(source);
    }

    public PDDXMLObject(RStack stack) {
        this.setup(stack);
    }

    public PDDXMLObject(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public PDDXMLObject(Element element) {
        this.setup(element);
    }

    public PDDXMLObject(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public PDDXMLObject(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public PDDXMLObject(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public PDDXMLObject(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public PDDXMLObject(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public PDDXMLObject(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(PDDXMLObject source) {
        this.setContent(source.getContent());
        this.setType(source.getType());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.content_ = URelaxer.getElementPropertyAsString(element);
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
    }

    public Object clone() {
        return new PDDXMLObject(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("object");
        URelaxer.setElementPropertyByString(element, this.content_);
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getContent() {
        return this.content_;
    }

    public final void setContent(String content) {
        this.content_ = content;
    }

    public final String getType() {
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<object");
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.append("</object>");
    }

    public void makePddlElement(StringBuffer buffer) {
        String objectName = URelaxer.escapeCharData(URelaxer.getString(this.getContent()));
        if (objectName.contains("#")) {
            buffer.append(objectName.substring(objectName.indexOf("#") + 1));
        } else {
            buffer.append(objectName);
        }
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<object");
        if (this.type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.write("</object>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<object");
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.print("</object>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getContentAsString() {
        return URelaxer.getString(this.getContent());
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public void setContentByString(String string) {
        this.setContent(string);
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "object")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "type")) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return PDDXMLObject.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (PDDXMLObject.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

