/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.pddxml.relaxer;

import de.dfki.pddxml.relaxer.IExpressionChoice;
import de.dfki.pddxml.relaxer.IRNode;
import de.dfki.pddxml.relaxer.IRVisitable;
import de.dfki.pddxml.relaxer.IRVisitor;
import de.dfki.pddxml.relaxer.Parameter;
import de.dfki.pddxml.relaxer.RStack;
import de.dfki.pddxml.relaxer.UJAXP;
import de.dfki.pddxml.relaxer.URelaxer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Predicate
implements Serializable,
Cloneable,
IRVisitable,
IRNode,
IExpressionChoice {
    private String name_;
    private List parameter_ = new ArrayList();
    private IRNode parentRNode_;

    public Predicate() {
        this.name_ = "";
    }

    public Predicate(Predicate source) {
        this.setup(source);
    }

    public Predicate(RStack stack) {
        this.setup(stack);
    }

    public Predicate(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Predicate(Element element) {
        this.setup(element);
    }

    public Predicate(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Predicate(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Predicate(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Predicate(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Predicate(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Predicate(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Predicate source) {
        this.setName(source.getName());
        this.parameter_.clear();
        int size = source.parameter_.size();
        int i = 0;
        while (i < size) {
            this.addParameter((Parameter)source.getParameter(i).clone());
            ++i;
        }
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.parameter_.clear();
        while (Parameter.isMatch(stack)) {
            this.addParameter(new Parameter(stack));
        }
    }

    @Override
    public Object clone() {
        return new Predicate(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("pred");
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        int size = this.parameter_.size();
        int i = 0;
        while (i < size) {
            Parameter value = (Parameter)this.parameter_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final Parameter[] getParameter() {
        Parameter[] array = new Parameter[this.parameter_.size()];
        return this.parameter_.toArray(array);
    }

    public final void setParameter(Parameter[] parameter) {
        this.parameter_.clear();
        int i = 0;
        while (i < parameter.length) {
            this.addParameter(parameter[i]);
            ++i;
        }
        i = 0;
        while (i < parameter.length) {
            parameter[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final void setParameter(Parameter parameter) {
        this.parameter_.clear();
        this.addParameter(parameter);
        if (parameter != null) {
            parameter.rSetParentRNode(this);
        }
    }

    public final void addParameter(Parameter parameter) {
        this.parameter_.add(parameter);
        if (parameter != null) {
            parameter.rSetParentRNode(this);
        }
    }

    public final void addParameter(Parameter[] parameter) {
        int i = 0;
        while (i < parameter.length) {
            this.addParameter(parameter[i]);
            ++i;
        }
        i = 0;
        while (i < parameter.length) {
            parameter[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final int sizeParameter() {
        return this.parameter_.size();
    }

    public final Parameter getParameter(int index) {
        return (Parameter)this.parameter_.get(index);
    }

    public final void setParameter(int index, Parameter parameter) {
        this.parameter_.set(index, parameter);
        if (parameter != null) {
            parameter.rSetParentRNode(this);
        }
    }

    public final void addParameter(int index, Parameter parameter) {
        this.parameter_.add(index, parameter);
        if (parameter != null) {
            parameter.rSetParentRNode(this);
        }
    }

    public final void removeParameter(int index) {
        this.parameter_.remove(index);
    }

    public final void removeParameter(Parameter parameter) {
        this.parameter_.remove(parameter);
    }

    public final void clearParameter() {
        this.parameter_.clear();
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<pred");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        buffer.append(">");
        int size = this.parameter_.size();
        int i = 0;
        while (i < size) {
            Parameter value = (Parameter)this.parameter_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</pred>");
    }

    @Override
    public void makePddlElement(StringBuffer buffer) {
        if (this.name_ != null) {
            buffer.append("(");
            String predicateName = URelaxer.escapeAttrQuot(URelaxer.getString(this.getName()));
            if (predicateName.contains("#")) {
                buffer.append(predicateName.substring(predicateName.indexOf("#") + 1));
            } else {
                buffer.append(predicateName);
            }
        }
        int size = this.parameter_.size();
        int i = 0;
        while (i < size) {
            buffer.append(" ");
            Parameter value = (Parameter)this.parameter_.get(i);
            value.makePddlElement(buffer);
            ++i;
        }
        buffer.append(")");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<pred");
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        buffer.write(">");
        int size = this.parameter_.size();
        int i = 0;
        while (i < size) {
            Parameter value = (Parameter)this.parameter_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.write("</pred>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<pred");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        buffer.print(">");
        int size = this.parameter_.size();
        int i = 0;
        while (i < size) {
            Parameter value = (Parameter)this.parameter_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</pred>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public boolean enter(IRVisitor visitor) {
        return visitor.enter(this);
    }

    @Override
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.parameter_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "pred")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "name")) {
            return false;
        }
        $match$ = true;
        if (!Parameter.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        while (Parameter.isMatchHungry(target)) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Predicate.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Predicate.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

